/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediaeffect;

import androidx.annotation.NonNull;
import com.serenegiant.glutils.TextureOffscreen;
import com.serenegiant.mediaeffect.ISource;
import com.serenegiant.mediaeffect.MediaEffectGLESBase;
import com.serenegiant.mediaeffect.MediaEffectKernel3x3Drawer;

public class MediaEffectGLESTwoPassBase
extends MediaEffectGLESBase {
    protected final MediaEffectKernel3x3Drawer mDrawer2;
    protected TextureOffscreen mOutputOffscreen2;

    public MediaEffectGLESTwoPassBase(int numTex, boolean isOES, String fss) {
        super(numTex, isOES, fss);
        this.mDrawer2 = null;
    }

    public MediaEffectGLESTwoPassBase(int numTex, String vss, String fss) {
        super(numTex, false, vss, fss);
        this.mDrawer2 = null;
    }

    public MediaEffectGLESTwoPassBase(int numTex, boolean isOES, String vss, String fss) {
        super(numTex, isOES, vss, fss);
        this.mDrawer2 = null;
    }

    public MediaEffectGLESTwoPassBase(int numTex, boolean isOES, String vss1, String fss1, String vss2, String fss2) {
        super(numTex, isOES, vss1, fss1);
        this.mDrawer2 = !vss1.equals(vss2) || !fss1.equals(fss2) ? new MediaEffectKernel3x3Drawer(isOES, vss2, fss2) : null;
    }

    @Override
    public void release() {
        if (this.mDrawer2 != null) {
            this.mDrawer2.release();
        }
        if (this.mOutputOffscreen2 != null) {
            this.mOutputOffscreen2.release();
            this.mOutputOffscreen2 = null;
        }
        super.release();
    }

    @Override
    public MediaEffectGLESBase resize(int width, int height) {
        super.resize(width, height);
        if (this.mDrawer2 != null) {
            this.mDrawer2.setTexSize(width, height);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@NonNull int[] src_tex_ids, int width, int height, int out_tex_id) {
        if (!this.mEnabled) {
            return;
        }
        if (this.mOutputOffscreen == null) {
            this.mOutputOffscreen = new TextureOffscreen(width, height, false);
        }
        this.mOutputOffscreen.bind();
        try {
            this.mDrawer.apply(src_tex_ids, this.mOutputOffscreen.getTexMatrix(), 0);
        }
        finally {
            this.mOutputOffscreen.unbind();
        }
        if (this.mOutputOffscreen2 == null) {
            this.mOutputOffscreen2 = new TextureOffscreen(width, height, false);
        }
        if (out_tex_id != this.mOutputOffscreen2.getTexture() || width != this.mOutputOffscreen2.getWidth() || height != this.mOutputOffscreen2.getHeight()) {
            this.mOutputOffscreen2.assignTexture(out_tex_id, width, height);
        }
        this.mOutputOffscreen2.bind();
        int[] ids = new int[]{this.mOutputOffscreen.getTexture()};
        try {
            if (this.mDrawer2 != null) {
                this.mDrawer2.apply(ids, this.mOutputOffscreen2.getTexMatrix(), 0);
            } else {
                this.mDrawer.apply(ids, this.mOutputOffscreen2.getTexMatrix(), 0);
            }
        }
        finally {
            this.mOutputOffscreen2.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@NonNull int[] src_tex_ids, @NonNull TextureOffscreen output) {
        if (!this.mEnabled) {
            return;
        }
        if (this.mOutputOffscreen == null) {
            this.mOutputOffscreen = new TextureOffscreen(output.getWidth(), output.getHeight(), false);
        }
        this.mOutputOffscreen.bind();
        try {
            this.mDrawer.apply(src_tex_ids, this.mOutputOffscreen.getTexMatrix(), 0);
        }
        finally {
            this.mOutputOffscreen.unbind();
        }
        output.bind();
        int[] ids = new int[]{this.mOutputOffscreen.getTexture()};
        try {
            if (this.mDrawer2 != null) {
                this.mDrawer2.apply(ids, output.getTexMatrix(), 0);
            } else {
                this.mDrawer.apply(ids, output.getTexMatrix(), 0);
            }
        }
        finally {
            output.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(ISource src) {
        if (!this.mEnabled) {
            return;
        }
        TextureOffscreen output_tex = src.getOutputTexture();
        int[] src_tex_ids = src.getSourceTexId();
        int width = src.getWidth();
        int height = src.getHeight();
        if (this.mOutputOffscreen == null) {
            this.mOutputOffscreen = new TextureOffscreen(width, height, false);
        }
        this.mOutputOffscreen.bind();
        try {
            this.mDrawer.apply(src_tex_ids, this.mOutputOffscreen.getTexMatrix(), 0);
        }
        finally {
            this.mOutputOffscreen.unbind();
        }
        output_tex.bind();
        int[] ids = new int[]{this.mOutputOffscreen.getTexture()};
        try {
            if (this.mDrawer2 != null) {
                this.mDrawer2.apply(ids, output_tex.getTexMatrix(), 0);
            } else {
                this.mDrawer.apply(ids, output_tex.getTexMatrix(), 0);
            }
        }
        finally {
            output_tex.unbind();
        }
    }
}

