/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.AudioEncoder;
import com.serenegiant.media.Encoder;
import com.serenegiant.media.IAudioEncoder;
import com.serenegiant.media.IMuxer;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.ISurfaceEncoder;
import com.serenegiant.media.IVideoEncoder;
import com.serenegiant.media.MediaMuxerWrapper;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.media.VideoMuxer;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public abstract class Recorder
implements IRecorder {
    private static final String TAG = Recorder.class.getSimpleName();
    public static final long CHECK_INTERVAL = 45000L;
    private final IRecorder.RecorderCallback mCallback;
    protected IMuxer mMuxer;
    private volatile int mEncoderCount;
    private volatile int mStartedCount;
    private int mState;
    protected Encoder mVideoEncoder;
    protected Encoder mAudioEncoder;
    private volatile boolean mVideoStarted;
    private volatile boolean mAudioStarted;
    private EosHandler mEosHandler;
    protected long mStartTime;
    private volatile boolean mReleased;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Recorder(IRecorder.RecorderCallback callback) {
        this.mCallback = callback;
        Recorder recorder = this;
        synchronized (recorder) {
            this.mState = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMuxer(IMuxer muxer) {
        if (!this.mReleased) {
            this.mMuxer = muxer;
            this.mStartedCount = 0;
            this.mEncoderCount = 0;
            Recorder recorder = this;
            synchronized (recorder) {
                this.mState = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() {
        Recorder recorder = this;
        synchronized (recorder) {
            if (this.mReleased) {
                throw new IllegalStateException("already released");
            }
            if (this.mState != 1) {
                throw new IllegalStateException("prepare:state=" + this.mState);
            }
        }
        try {
            if (this.mVideoEncoder != null) {
                this.mVideoEncoder.prepare();
            }
            if (this.mAudioEncoder != null) {
                this.mAudioEncoder.prepare();
            }
        }
        catch (Exception e) {
            this.callOnError(e);
            return;
        }
        recorder = this;
        synchronized (recorder) {
            this.mState = 2;
        }
        this.callOnPrepared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRecording() throws IllegalStateException {
        Recorder recorder = this;
        synchronized (recorder) {
            if (this.mReleased) {
                throw new IllegalStateException("already released");
            }
            if (this.mState != 2) {
                throw new IllegalStateException("start:not prepared");
            }
            this.mState = 3;
        }
        this.mStartTime = System.currentTimeMillis();
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.start();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.start();
        }
        if (this.mEosHandler == null) {
            this.mEosHandler = EosHandler.createHandler(this);
        }
        this.mEosHandler.startCheckFreeSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRecording() {
        if (this.mEosHandler != null) {
            this.mEosHandler.terminate();
            this.mEosHandler = null;
        }
        Recorder recorder = this;
        synchronized (recorder) {
            if (this.mState == 0 || this.mState == 1 || this.mState == 5) {
                return;
            }
            this.mState = 5;
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.stop();
        }
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.stop();
        }
        this.callOnStopped();
    }

    @Override
    public Surface getInputSurface() {
        return this.mVideoEncoder instanceof ISurfaceEncoder ? ((ISurfaceEncoder)this.mVideoEncoder).getInputSurface() : null;
    }

    @Override
    public Encoder getVideoEncoder() {
        return this.mVideoEncoder;
    }

    @Override
    public Encoder getAudioEncoder() {
        return this.mAudioEncoder;
    }

    @Override
    public synchronized boolean isStarted() {
        return !this.mReleased && this.mState == 4;
    }

    @Override
    public synchronized boolean isReady() {
        return !this.mReleased && (this.mState == 4 || this.mState == 2);
    }

    @Override
    public synchronized boolean isStopping() {
        return this.mState == 5;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.mState <= 1;
    }

    public boolean isReleased() {
        return this.mReleased;
    }

    @Override
    public synchronized int getState() {
        return this.mState;
    }

    @Override
    public IMuxer getMuxer() {
        return this.mMuxer;
    }

    @Override
    public void frameAvailableSoon() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.frameAvailableSoon();
        }
    }

    @Override
    public void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            if (this.mAudioEncoder != null) {
                this.mAudioEncoder.release();
            }
            if (this.mVideoEncoder != null) {
                this.mVideoEncoder.release();
            }
            if (this.mMuxer != null) {
                this.mMuxer.release();
            }
        }
        this.mAudioEncoder = null;
        this.mVideoEncoder = null;
        this.mMuxer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addEncoder(Encoder encoder) {
        Recorder recorder = this;
        synchronized (recorder) {
            if (this.mReleased) {
                throw new IllegalStateException("already released");
            }
            if (this.mState > 1) {
                throw new IllegalStateException("addEncoder already prepared/started");
            }
        }
        if (encoder instanceof IAudioEncoder) {
            if (this.mAudioEncoder != null) {
                throw new IllegalArgumentException("Audio encoder already added.");
            }
            this.mAudioEncoder = encoder;
        }
        if (encoder instanceof IVideoEncoder) {
            if (this.mVideoEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mVideoEncoder = encoder;
        }
        this.mEncoderCount = (this.mVideoEncoder != null ? 1 : 0) + (this.mAudioEncoder != null ? 1 : 0);
    }

    @Override
    public synchronized void removeEncoder(Encoder encoder) {
        if (encoder instanceof IVideoEncoder) {
            this.mVideoEncoder = null;
            this.mVideoStarted = false;
        }
        if (encoder instanceof AudioEncoder) {
            this.mAudioEncoder = null;
            this.mAudioStarted = false;
        }
        this.mEncoderCount = (this.mVideoEncoder != null ? 1 : 0) + (this.mAudioEncoder != null ? 1 : 0);
    }

    @Override
    public synchronized boolean start(Encoder encoder) {
        if (this.mReleased) {
            throw new IllegalStateException("already released");
        }
        if (this.mState != 3) {
            throw new IllegalStateException("muxer has not prepared:state=");
        }
        if (encoder.equals(this.mVideoEncoder)) {
            this.mVideoStarted = true;
        } else if (encoder.equals(this.mAudioEncoder)) {
            this.mAudioStarted = true;
        }
        ++this.mStartedCount;
        while (this.mState == 3 && this.mEncoderCount > 0) {
            boolean canStart;
            boolean bl = canStart = !(this.mVideoEncoder != null && !this.mVideoStarted || this.mAudioEncoder != null && !this.mAudioStarted);
            if (canStart) {
                this.mMuxer.start();
                this.mState = 4;
                this.notifyAll();
                this.callOnStarted();
                if (this.mEosHandler == null) break;
                this.mEosHandler.setDuration(VideoConfig.maxDuration);
                break;
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return this.mState == 4;
    }

    @Override
    public synchronized void stop(Encoder encoder) {
        if (encoder.equals(this.mVideoEncoder)) {
            if (this.mVideoStarted) {
                this.mVideoStarted = false;
                --this.mStartedCount;
            }
        } else if (encoder.equals(this.mAudioEncoder) && this.mAudioStarted) {
            this.mAudioStarted = false;
            --this.mStartedCount;
        }
        if (this.mEncoderCount > 0 && this.mStartedCount <= 0) {
            if (this.mState == 5) {
                this.mMuxer.stop();
            }
            this.mState = 1;
            this.mVideoEncoder = null;
            this.mAudioEncoder = null;
        }
    }

    @Override
    public synchronized int addTrack(Encoder encoder, MediaFormat format) {
        int trackIx;
        try {
            if (this.mReleased) {
                throw new IllegalStateException("already released");
            }
            if (this.mState != 3) {
                throw new IllegalStateException("muxer not ready:state=" + this.mState);
            }
            trackIx = this.mMuxer.addTrack(format);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"addTrack:", (Throwable)e);
            trackIx = -1;
            this.removeEncoder(encoder);
        }
        return trackIx;
    }

    @Override
    public void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        try {
            if (!this.mReleased && this.mStartedCount > 0) {
                this.mMuxer.writeSampleData(trackIndex, byteBuf, bufferInfo);
            }
        }
        catch (Exception e) {
            this.callOnError(e);
        }
    }

    protected void callOnPrepared() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onPrepared(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"onPrepared:", (Throwable)e);
            }
        }
    }

    protected void callOnStarted() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onStarted(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"onStarted:", (Throwable)e);
            }
        }
    }

    protected void callOnStopped() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onStopped(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"onStopped:", (Throwable)e);
            }
        }
    }

    protected void callOnError(Exception e) {
        if (!this.mReleased && this.mCallback != null) {
            try {
                this.mCallback.onError(e);
            }
            catch (Exception e1) {
                Log.e((String)TAG, (String)"onError:", (Throwable)e);
            }
        }
    }

    protected abstract boolean check();

    protected static IMuxer createMuxer(String output_oath) throws IOException {
        IMuxer result = VideoConfig.sUseMediaMuxer ? new MediaMuxerWrapper(output_oath, 0) : new VideoMuxer(output_oath);
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"NewApi"})
    protected static IMuxer createMuxer(int fd) throws IOException {
        void var1_4;
        if (VideoConfig.sUseMediaMuxer) {
            if (!BuildCheck.isOreo()) throw new RuntimeException("createMuxer from fd does not support now");
            ParcelFileDescriptor pfd = ParcelFileDescriptor.fromFd((int)fd);
            MediaMuxerWrapper mediaMuxerWrapper = new MediaMuxerWrapper(pfd.getFileDescriptor(), 0);
            return var1_4;
        } else {
            VideoMuxer videoMuxer = new VideoMuxer(fd);
        }
        return var1_4;
    }

    @SuppressLint(value={"NewApi"})
    protected static IMuxer createMuxer(@NonNull Context context, @NonNull DocumentFile file) throws IOException {
        IMuxer result = null;
        if (VideoConfig.sUseMediaMuxer) {
            if (BuildCheck.isOreo()) {
                result = new MediaMuxerWrapper(context.getContentResolver().openFileDescriptor(file.getUri(), "rw").getFileDescriptor(), 0);
            } else {
                String path = UriHelper.getPath(context, file.getUri());
                File f = new File(UriHelper.getPath(context, file.getUri()));
                if (f.canWrite()) {
                    result = new MediaMuxerWrapper(path, 0);
                } else {
                    Log.w((String)TAG, (String)"cant't write to the file, try to use VideoMuxer instead");
                }
            }
        }
        if (result == null) {
            result = new VideoMuxer(context.getContentResolver().openFileDescriptor(file.getUri(), "rw").getFd());
        }
        return result;
    }

    private static final class EosHandler
    extends Handler {
        private static final int MSG_CHECK_FREESPACE = 5;
        private static final int MSG_SEND_EOS = 8;
        private static final int MSG_SEND_QUIT = 9;
        private final EosThread mThread;

        private EosHandler(EosThread thread) {
            this.mThread = thread;
        }

        public static final EosHandler createHandler(Recorder recorder) {
            EosThread thread = new EosThread(recorder);
            thread.start();
            return thread.getHandler();
        }

        public final void setDuration(long duration) {
            this.removeMessages(8);
            if (duration > 0L) {
                this.sendEmptyMessageDelayed(8, duration);
            }
        }

        public final void startCheckFreeSpace() {
            this.removeMessages(5);
            this.sendEmptyMessageDelayed(5, 45000L);
        }

        public final void terminate() {
            this.removeMessages(8);
            this.removeMessages(5);
            this.sendEmptyMessage(9);
        }

        public final void handleMessage(Message msg) {
            Recorder recorder = (Recorder)this.mThread.mWeakRecorder.get();
            if (recorder == null) {
                try {
                    Looper.myLooper().quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            switch (msg.what) {
                case 8: {
                    recorder.stopRecording();
                    break;
                }
                case 5: {
                    if (!this.mThread.check(recorder)) {
                        this.sendEmptyMessageDelayed(5, 45000L);
                        break;
                    }
                    recorder.stopRecording();
                    break;
                }
                case 9: {
                    try {
                        Looper.myLooper().quit();
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        private static final class EosThread
        extends Thread {
            private final Object mSync = new Object();
            private final WeakReference<Recorder> mWeakRecorder;
            private EosHandler mHandler;
            private boolean mIsReady = false;

            public EosThread(Recorder recorder) {
                super("EosThread");
                this.mWeakRecorder = new WeakReference<Recorder>(recorder);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final EosHandler getHandler() {
                Object object = this.mSync;
                synchronized (object) {
                    while (!this.mIsReady) {
                        try {
                            this.mSync.wait(300L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
                return this.mHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                Looper.prepare();
                Object object = this.mSync;
                synchronized (object) {
                    this.mHandler = new EosHandler(this);
                    this.mIsReady = true;
                    this.mSync.notify();
                }
                Looper.loop();
                object = this.mSync;
                synchronized (object) {
                    this.mIsReady = false;
                    this.mHandler = null;
                }
            }

            private boolean check(Recorder recorder) {
                return recorder.check();
            }
        }
    }
}

