/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.math;

import com.serenegiant.math.BaseBounds;
import com.serenegiant.math.CircleBounds;
import com.serenegiant.math.RectangleBounds;
import com.serenegiant.math.SphereBounds;
import com.serenegiant.math.Vector;

public class OverlapTester {
    private static final Vector r1L = new Vector();
    private static final Vector r2L = new Vector();

    public static boolean check(BaseBounds b1, BaseBounds b2) {
        float radiusSum;
        float distance = b1.position.distSquared(b2.position);
        return distance <= (radiusSum = b1.radius + b2.radius) * radiusSum;
    }

    public static boolean check(CircleBounds c1, CircleBounds c2) {
        float radiusSum;
        float distance = c1.position.distSquared(c2.position);
        return distance <= (radiusSum = c1.radius + c2.radius) * radiusSum;
    }

    public static boolean check(RectangleBounds r1, RectangleBounds r2) {
        r1L.set(r1.position).sub(r1.box);
        float r1x = r1.box.x * 2.0f;
        float r1y = r1.box.y * 2.0f;
        float r1z = r1.box.z * 2.0f;
        r2L.set(r2.position).sub(r2.box);
        float r2x = r2.box.x * 2.0f;
        float r2y = r2.box.y * 2.0f;
        float r2z = r2.box.z * 2.0f;
        return OverlapTester.r1L.x < OverlapTester.r2L.x + r2x && OverlapTester.r1L.x + r1x > OverlapTester.r2L.x && OverlapTester.r1L.y < OverlapTester.r2L.y + r2y && OverlapTester.r1L.y + r1y > OverlapTester.r2L.y && OverlapTester.r1L.z < OverlapTester.r2L.z + r2z && OverlapTester.r1L.z + r1z > OverlapTester.r2L.z;
    }

    public static boolean check(CircleBounds c, RectangleBounds r) {
        float cx = c.position.x;
        float cy = c.position.y;
        float cz = c.position.z;
        r1L.set(r.position).sub(r.box);
        float rx = r.box.x * 2.0f;
        float ry = r.box.y * 2.0f;
        float rz = r.box.z * 2.0f;
        if (c.position.x < OverlapTester.r1L.x) {
            cx = OverlapTester.r1L.x;
        } else if (c.position.x > OverlapTester.r1L.x + rx) {
            cx = OverlapTester.r1L.x + rx;
        }
        if (c.position.y < OverlapTester.r1L.y) {
            cy = OverlapTester.r1L.y;
        } else if (c.position.y > OverlapTester.r1L.y + ry) {
            cy = OverlapTester.r1L.y + ry;
        }
        if (c.position.z < OverlapTester.r1L.z) {
            cz = OverlapTester.r1L.z;
        } else if (c.position.z > OverlapTester.r1L.z + rz) {
            cz = OverlapTester.r1L.z + rz;
        }
        return c.position.distSquared(cx, cy, cz) < c.radius * c.radius;
    }

    public static boolean check(CircleBounds c, Vector p) {
        return c.position.distSquared(p) < c.radius * c.radius;
    }

    public static boolean check(CircleBounds c, float x, float y, float z) {
        return c.position.distSquared(x, y, z) < c.radius * c.radius;
    }

    public static boolean check(CircleBounds c, float x, float y) {
        return c.position.distSquared(x, y) < c.radius * c.radius;
    }

    public static boolean check(RectangleBounds r, Vector p) {
        return OverlapTester.check(r, p.x, p.y, p.z);
    }

    public static boolean check(RectangleBounds r, float x, float y) {
        return OverlapTester.check(r, x, y, 0.0f);
    }

    public static boolean check(RectangleBounds r, float x, float y, float z) {
        r1L.set(r.position).sub(r.box);
        return OverlapTester.r1L.x <= x && OverlapTester.r1L.x + r.box.x * 2.0f >= x && OverlapTester.r1L.y <= y && OverlapTester.r1L.y + r.box.y * 2.0f >= y && OverlapTester.r1L.z <= z && OverlapTester.r1L.z + r.box.z * 2.0f >= z;
    }

    public static boolean check(SphereBounds s1, SphereBounds s2) {
        float distance = s1.position.distance(s2.position);
        return distance <= s1.radius + s2.radius;
    }

    public static boolean check(SphereBounds s, Vector pos) {
        return s.position.distSquared(pos) < s.radius * s.radius;
    }

    public static boolean check(SphereBounds s, float x, float y, float z) {
        return s.position.distance(x, y, z) < s.radius * s.radius;
    }
}

