/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Process;
import android.util.Log;
import com.serenegiant.media.AbstractEncoder;
import com.serenegiant.media.AudioSampler;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IAudioEncoder;
import com.serenegiant.media.IAudioSampler;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MediaCodecHelper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=16)
public class AudioEncoder
extends AbstractEncoder
implements IAudioEncoder {
    private static final String TAG = AudioEncoder.class.getSimpleName();
    private AudioThread mAudioThread = null;
    protected final int mAudioSource;
    protected final int mChannelCount;
    protected final int mSampleRate;

    public AudioEncoder(IRecorder recorder, EncoderListener listener, int audio_source, int audio_channels) {
        super("audio/mp4a-latm", recorder, listener);
        this.mAudioSource = audio_source;
        this.mSampleRate = 44100;
        this.mChannelCount = audio_channels;
        if (audio_source < 0 || audio_source > 7) {
            throw new IllegalArgumentException("invalid audio source:" + audio_source);
        }
    }

    @Override
    protected boolean internalPrepare() throws Exception {
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mRecorderStarted = false;
        MediaCodecInfo audioCodecInfo = MediaCodecHelper.selectAudioEncoder(this.MIME_TYPE);
        if (audioCodecInfo == null) {
            return true;
        }
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)this.MIME_TYPE, (int)this.mSampleRate, (int)this.mChannelCount);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", this.mChannelCount == 1 ? 16 : 12);
        audioFormat.setInteger("bitrate", 64000);
        audioFormat.setInteger("channel-count", 1);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)this.MIME_TYPE);
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        return false;
    }

    @Override
    public void start() {
        super.start();
        if (this.mAudioThread == null) {
            this.mAudioThread = new AudioThread();
            this.mAudioThread.start();
        }
    }

    @Override
    public void release() {
        this.mAudioThread = null;
        super.release();
    }

    @Override
    public boolean isAudio() {
        return true;
    }

    @Override
    protected MediaFormat createOutputFormat(byte[] csd, int size, int ix0, int ix1, int ix2) {
        MediaFormat outFormat = MediaFormat.createAudioFormat((String)this.MIME_TYPE, (int)this.mSampleRate, (int)this.mChannelCount);
        ByteBuffer csd0 = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        csd0.put(csd, 0, size);
        csd0.flip();
        outFormat.setByteBuffer("csd-0", csd0);
        return outFormat;
    }

    private final class AudioThread
    extends Thread {
        public AudioThread() {
            super("AudioThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ByteBuffer buf;
            int frame_count;
            block37: {
                Process.setThreadPriority((int)-16);
                int buffer_size = AudioSampler.getAudioBufferSize(AudioEncoder.this.mChannelCount, AudioEncoder.this.mSampleRate, 1024, 25);
                AudioRecord audioRecord = IAudioSampler.createAudioRecord(AudioEncoder.this.mAudioSource, AudioEncoder.this.mSampleRate, AudioEncoder.this.mChannelCount, 2, buffer_size);
                frame_count = 0;
                int err_count = 0;
                buf = ByteBuffer.allocateDirect(buffer_size).order(ByteOrder.nativeOrder());
                if (audioRecord != null) {
                    try {
                        if (!AudioEncoder.this.mIsCapturing) break block37;
                        audioRecord.startRecording();
                        try {
                            int sizeInBytes = 1024 * AudioEncoder.this.mChannelCount;
                            while (AudioEncoder.this.mIsCapturing && !AudioEncoder.this.mRequestStop && !AudioEncoder.this.mIsEOS) {
                                int readBytes;
                                buf.clear();
                                try {
                                    readBytes = audioRecord.read(buf, sizeInBytes);
                                }
                                catch (Exception e) {
                                    break;
                                }
                                if (readBytes > 0) {
                                    err_count = 0;
                                    ++frame_count;
                                    buf.position(readBytes);
                                    buf.flip();
                                    AudioEncoder.this.encode(buf, readBytes, AudioEncoder.this.getInputPTSUs());
                                    AudioEncoder.this.frameAvailableSoon();
                                } else {
                                    if (readBytes == 0) {
                                        err_count = 0;
                                        continue;
                                    }
                                    if (readBytes == -1) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)"Read error ERROR");
                                        }
                                        ++err_count;
                                    } else if (readBytes == -2) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)"Read error ERROR_BAD_VALUE");
                                        }
                                        ++err_count;
                                    } else if (readBytes == -3) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)"Read error ERROR_INVALID_OPERATION");
                                        }
                                        ++err_count;
                                    } else if (readBytes == -6) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)"Read error ERROR_DEAD_OBJECT");
                                        }
                                        ++err_count;
                                    } else if (readBytes < 0) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)("Read returned unknown err " + readBytes));
                                        }
                                        ++err_count;
                                    }
                                }
                                if (err_count <= 10) continue;
                            }
                            if (frame_count > 0) {
                                AudioEncoder.this.frameAvailableSoon();
                            }
                        }
                        finally {
                            audioRecord.stop();
                        }
                    }
                    catch (Exception readBytes) {
                    }
                    finally {
                        audioRecord.release();
                    }
                }
            }
            if (frame_count == 0) {
                for (int i = 0; AudioEncoder.this.mIsCapturing && i < 5; ++i) {
                    buf.position(1024);
                    buf.flip();
                    AudioEncoder.this.encode(buf, 1024, AudioEncoder.this.getInputPTSUs());
                    AudioEncoder.this.frameAvailableSoon();
                    AudioThread audioThread = this;
                    synchronized (audioThread) {
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
        }
    }
}

