/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.graphics;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.serenegiant.utils.BitsHelper;
import com.serenegiant.utils.UriHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BitmapHelper {
    private static final int OPTIONS_SCALE_UP = 1;
    public static final int OPTIONS_RECYCLE_INPUT = 2;

    public static byte[] BitmapToByteArray(@NonNull Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] bytes = null;
        if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream)) {
            bytes = byteArrayOutputStream.toByteArray();
        }
        return bytes;
    }

    public static Bitmap asBitmap(byte[] bytes) {
        Bitmap bitmap = null;
        if (bytes != null) {
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        }
        return bitmap;
    }

    public static Bitmap asBitmap(byte[] bytes, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (bytes != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        }
        return bitmap;
    }

    public static Bitmap asBitmapStrictSize(byte[] bytes, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (bytes != null) {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            int calcedSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            options.inSampleSize = inSampleSize = 1 << BitsHelper.MSB(calcedSampleSize);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            if (inSampleSize != calcedSampleSize || bitmap.getWidth() != requestWidth || bitmap.getHeight() != requestHeight) {
                Bitmap newBitmap = BitmapHelper.scaleBitmap(bitmap, requestWidth, requestHeight);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    public static Bitmap asBitmap(String filePath) {
        Bitmap bitmap = null;
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            bitmap = BitmapFactory.decodeFile((String)filePath);
        }
        return bitmap;
    }

    public static Bitmap asBitmap(String filePath, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        return bitmap;
    }

    public static Bitmap asBitmapStrictSize(String filePath, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            int calcedSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            options.inSampleSize = inSampleSize = 1 << BitsHelper.MSB(calcedSampleSize);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            if (inSampleSize != calcedSampleSize || bitmap.getWidth() != requestWidth || bitmap.getHeight() != requestHeight) {
                Bitmap newBitmap = BitmapHelper.scaleBitmap(bitmap, requestWidth, requestHeight);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    public static Bitmap asBitmap(FileDescriptor fd) {
        Bitmap bitmap = null;
        if (fd != null && fd.valid()) {
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd);
        }
        return bitmap;
    }

    public static Bitmap asBitmap(FileDescriptor fd, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (fd != null && fd.valid()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        }
        return bitmap;
    }

    public static Bitmap asBitmapStrictSize(FileDescriptor fd, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (fd != null && fd.valid()) {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            int calcedSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            options.inSampleSize = inSampleSize = 1 << BitsHelper.MSB(calcedSampleSize);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            if (inSampleSize != calcedSampleSize || bitmap.getWidth() != requestWidth || bitmap.getHeight() != requestHeight) {
                Bitmap newBitmap = BitmapHelper.scaleBitmap(bitmap, requestWidth, requestHeight);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    public static Bitmap asBitmap(ContentResolver cr, Uri uri) throws FileNotFoundException, IOException {
        ParcelFileDescriptor pfd;
        Bitmap bitmap = null;
        if (uri != null && (pfd = cr.openFileDescriptor(uri, "r")) != null) {
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor());
            int orientation = BitmapHelper.getOrientation(cr, uri);
            if (orientation != 0) {
                Bitmap newBitmap = BitmapHelper.rotateBitmap(bitmap, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    public static Bitmap asBitmap(ContentResolver cr, Uri uri, int requestWidth, int requestHeight) throws FileNotFoundException, IOException {
        ParcelFileDescriptor pfd;
        Bitmap bitmap = null;
        if (uri != null && (pfd = cr.openFileDescriptor(uri, "r")) != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)options);
            int orientation = BitmapHelper.getOrientation(cr, uri);
            if (orientation != 0) {
                Bitmap newBitmap = BitmapHelper.rotateBitmap(bitmap, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    public static Bitmap asBitmapStrictSize(ContentResolver cr, Uri uri, int requestWidth, int requestHeight) throws FileNotFoundException, IOException {
        ParcelFileDescriptor pfd;
        Bitmap bitmap = null;
        if (uri != null && (pfd = cr.openFileDescriptor(uri, "r")) != null) {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)options);
            int calcedSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            options.inSampleSize = inSampleSize = 1 << BitsHelper.MSB(calcedSampleSize);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)options);
            int orientation = BitmapHelper.getOrientation(cr, uri);
            if (inSampleSize != calcedSampleSize || orientation != 0 || bitmap.getWidth() != requestWidth || bitmap.getHeight() != requestHeight) {
                Bitmap newBitmap = BitmapHelper.scaleRotateBitmap(bitmap, requestWidth, requestHeight, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    public static Bitmap asBitmap(InputStream in) {
        Bitmap bitmap = null;
        if (in != null) {
            bitmap = BitmapFactory.decodeStream((InputStream)in);
        }
        return bitmap;
    }

    @Deprecated
    public static Bitmap asBitmap(InputStream in, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (in != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            Rect outPadding = new Rect();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)in, (Rect)outPadding, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            bitmap = BitmapFactory.decodeStream((InputStream)in, (Rect)outPadding, (BitmapFactory.Options)options);
        }
        return bitmap;
    }

    @Deprecated
    public static Bitmap asBitmapStrictSize(InputStream in, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (in != null) {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            Rect outPadding = new Rect();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)in, (Rect)outPadding, (BitmapFactory.Options)options);
            int calcedSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            options.inSampleSize = inSampleSize = 1 << BitsHelper.MSB(calcedSampleSize);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeStream((InputStream)in, (Rect)outPadding, (BitmapFactory.Options)options);
            if (inSampleSize != calcedSampleSize || bitmap.getWidth() != requestWidth || bitmap.getHeight() != requestHeight) {
                Bitmap newBitmap = BitmapHelper.scaleBitmap(bitmap, requestWidth, requestHeight);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    public static int getOrientation(ContentResolver cr, Uri uri) {
        int orientation;
        ExifInterface exifInterface;
        try {
            exifInterface = new ExifInterface(UriHelper.getAbsolutePath(cr, uri));
        }
        catch (Exception e) {
            return 0;
        }
        int exifR = exifInterface.getAttributeInt("Orientation", 0);
        switch (exifR) {
            case 6: {
                orientation = 90;
                break;
            }
            case 3: {
                orientation = 180;
                break;
            }
            case 8: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    public static Bitmap scaleBitmap(Bitmap bitmap, int requestWidth, int requestHeight) {
        Bitmap newBitmap = null;
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.postScale((float)width / (float)requestWidth, (float)height / (float)requestHeight);
            newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return newBitmap;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int rotation) {
        Bitmap newBitmap = null;
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotation);
            newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return newBitmap;
    }

    public static Bitmap scaleRotateBitmap(Bitmap bitmap, int requestWidth, int requestHeight, int rotation) {
        Bitmap newBitmap = null;
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.postScale((float)width / (float)requestWidth, (float)height / (float)requestHeight);
            matrix.postRotate((float)rotation);
            newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return newBitmap;
    }

    public static Bitmap extractBitmap(Bitmap source, int width, int height) {
        Bitmap newBitmap = null;
        if (source != null) {
            float scale = source.getWidth() < source.getHeight() ? (float)width / (float)source.getWidth() : (float)height / (float)source.getHeight();
            Matrix matrix = new Matrix();
            matrix.setScale(scale, scale);
            newBitmap = BitmapHelper.transform(matrix, source, width, height, 3);
        }
        return newBitmap;
    }

    private static Bitmap transform(Matrix scaler, Bitmap source, int targetWidth, int targetHeight, int options) {
        int dy1;
        int dx1;
        Bitmap b2;
        float scale;
        float viewAspect;
        float bitmapHeightF;
        boolean scaleUp = (options & 1) != 0;
        boolean recycle = (options & 2) != 0;
        int deltaX = source.getWidth() - targetWidth;
        int deltaY = source.getHeight() - targetHeight;
        if (!(scaleUp || deltaX >= 0 && deltaY >= 0)) {
            Bitmap b22 = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b22);
            int deltaXHalf = Math.max(0, deltaX / 2);
            int deltaYHalf = Math.max(0, deltaY / 2);
            Rect src = new Rect(deltaXHalf, deltaYHalf, deltaXHalf + Math.min(targetWidth, source.getWidth()), deltaYHalf + Math.min(targetHeight, source.getHeight()));
            int dstX = (targetWidth - src.width()) / 2;
            int dstY = (targetHeight - src.height()) / 2;
            Rect dst = new Rect(dstX, dstY, targetWidth - dstX, targetHeight - dstY);
            c.drawBitmap(source, src, dst, null);
            if (recycle) {
                source.recycle();
            }
            c.setBitmap(null);
            return b22;
        }
        float bitmapWidthF = source.getWidth();
        float bitmapAspect = bitmapWidthF / (bitmapHeightF = (float)source.getHeight());
        if (bitmapAspect > (viewAspect = (float)targetWidth / (float)targetHeight)) {
            scale = (float)targetHeight / bitmapHeightF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        } else {
            scale = (float)targetWidth / bitmapWidthF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        }
        Bitmap b1 = scaler != null ? Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)scaler, (boolean)true) : source;
        if (recycle && b1 != source) {
            source.recycle();
        }
        if ((b2 = Bitmap.createBitmap((Bitmap)b1, (int)((dx1 = Math.max(0, b1.getWidth() - targetWidth)) / 2), (int)((dy1 = Math.max(0, b1.getHeight() - targetHeight)) / 2), (int)targetWidth, (int)targetHeight)) != b1 && (recycle || b1 != source)) {
            b1.recycle();
        }
        return b2;
    }

    public static int calcSampleSize(BitmapFactory.Options options, int requestWidth, int requestHeight) {
        int imageWidth = options.outWidth;
        int imageHeight = options.outHeight;
        int inSampleSize = 1;
        if (imageHeight > requestHeight || imageWidth > requestWidth) {
            inSampleSize = imageWidth > imageHeight ? (int)Math.floor((float)imageHeight / (float)requestHeight) : (int)Math.floor((float)imageWidth / (float)requestWidth);
        }
        return inSampleSize;
    }

    public static Bitmap copyBitmap(Bitmap src, Bitmap dest) {
        if (src == null) {
            throw new NullPointerException("src bitmap should not be null.");
        }
        if (dest == null) {
            dest = Bitmap.createBitmap((Bitmap)src);
        } else if (!src.equals(dest)) {
            Canvas canvas = new Canvas(dest);
            canvas.setBitmap(src);
        }
        return dest;
    }

    public static Bitmap makeCheckBitmap() {
        Bitmap bm = Bitmap.createBitmap((int)40, (int)40, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(bm);
        c.drawColor(-1);
        Paint p = new Paint();
        p.setColor(-3355444);
        c.drawRect(0.0f, 0.0f, 20.0f, 20.0f, p);
        c.drawRect(20.0f, 20.0f, 40.0f, 40.0f, p);
        return bm;
    }
}

