/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;

public class ProgressView
extends View {
    private int mRotation = 90;
    private int mMin = 0;
    private int mMax = 100;
    private float mScale = 100.0f;
    private volatile int mProgress = 40;
    private int mColor = -65536;
    private Drawable mDrawable;
    private ClipDrawable mClipDrawable;
    private final Runnable mUpdateProgressTask = new Runnable(){

        @Override
        public void run() {
            if (ProgressView.this.mClipDrawable != null) {
                int level = (int)((float)ProgressView.this.mProgress * ProgressView.this.mScale) + ProgressView.this.mMin;
                if (level < 0) {
                    level = 0;
                }
                if (level > 10000) {
                    level = 10000;
                }
                ProgressView.this.mClipDrawable.setLevel(level);
            }
            ProgressView.this.invalidate();
        }
    };
    protected static final int GRAVITY_TOP = 48;
    protected static final int GRAVITY_BOTTOM = 80;
    protected static final int GRAVITY_LEFT = 3;
    protected static final int GRAVITY_RIGHT = 5;
    protected static final int GRAVITY_CENTER_VERTICAL = 16;
    protected static final int GRAVITY_FILL_VERTICAL = 112;
    protected static final int GRAVITY_CENTER_HORIZONTAL = 1;
    protected static final int GRAVITY_FILL_HORIZONTAL = 7;
    protected static final int GRAVITY_CENTER = 17;
    protected static final int GRAVITY_FILL = 119;
    protected static final int GRAVITY_CLIP_VERTICAL = 128;
    protected static final int GRAVITY_CLIP_HORIZONTAL = 8;
    protected static final int GRAVITY_START = 0x800003;
    protected static final int GRAVITY_END = 0x800005;

    public ProgressView(Context context) {
        super(context);
    }

    public ProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mClipDrawable.draw(canvas);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.resize();
    }

    public void setMinMax(int min, int max) {
        if ((this.mMin != min || this.mMax != max) && min != max) {
            this.mMin = Math.min(min, max);
            this.mMax = Math.max(min, max);
            this.resize();
        }
    }

    public void setProgress(int progress) {
        if (this.mProgress != progress) {
            this.mProgress = progress;
            this.removeCallbacks(this.mUpdateProgressTask);
            this.post(this.mUpdateProgressTask);
        }
    }

    public void setRotation(int rotation) {
        if (this.mRotation != (rotation = rotation / 90 * 90 % 360)) {
            this.mRotation = rotation;
            this.resize();
        }
    }

    public void setColor(int color) {
        if (this.mColor != color) {
            this.mColor = color;
            this.refreshDrawable(null);
        }
    }

    public void setDrawable(Drawable drawable2) {
        if (this.mDrawable != drawable2) {
            this.refreshDrawable(drawable2);
        }
    }

    protected void resize() {
        float progress = (float)this.mProgress * this.mScale + (float)this.mMin;
        this.mScale = 10000.0f / (float)(this.mMax - this.mMin);
        this.mProgress = (int)((progress - (float)this.mMin) / this.mScale);
        this.refreshDrawable(this.mDrawable);
    }

    protected void refreshDrawable(Drawable drawable2) {
        this.mDrawable = drawable2;
        if (this.mDrawable == null) {
            this.mDrawable = new ColorDrawable(this.mColor);
        }
        int gravity = 115;
        int orientation = 1;
        switch (this.mRotation) {
            case 90: {
                gravity = 87;
                orientation = 2;
                break;
            }
            case 180: {
                gravity = 117;
                orientation = 1;
                break;
            }
            case 270: {
                gravity = 55;
                orientation = 2;
            }
        }
        this.mClipDrawable = new ClipDrawable(this.mDrawable, gravity, orientation);
        Rect outRect = new Rect();
        this.getDrawingRect(outRect);
        this.mClipDrawable.setBounds(outRect);
        this.mClipDrawable.setLevel((int)((float)this.mProgress * this.mScale) + this.mMin);
        this.postInvalidate();
    }
}

