/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import com.serenegiant.widget.ItemPicker;

public final class ItemPickerPreferenceV7
extends Preference {
    private static final boolean DEBUG = false;
    private static final String TAG = ItemPickerPreferenceV7.class.getSimpleName();
    private int preferenceValue;
    private int mMinValue = 1;
    private int mMaxValue = 100;
    private ItemPicker mItemPicker;
    private final ItemPicker.OnChangedListener mOnChangeListener = new ItemPicker.OnChangedListener(){

        @Override
        public void onChanged(ItemPicker picker, int oldVal, int newVal) {
            ItemPickerPreferenceV7.this.callChangeListener(newVal);
            ItemPickerPreferenceV7.this.preferenceValue = newVal;
            ItemPickerPreferenceV7.this.persistInt(ItemPickerPreferenceV7.this.preferenceValue);
        }
    };

    public ItemPickerPreferenceV7(Context context) {
        super(context);
    }

    public ItemPickerPreferenceV7(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ItemPickerPreferenceV7(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        RelativeLayout parent = null;
        if (holder.itemView instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)holder.itemView;
            for (int i = group.getChildCount() - 1; i >= 0; --i) {
                View v = group.getChildAt(i);
                if (!(v instanceof RelativeLayout)) continue;
                parent = (RelativeLayout)v;
                break;
            }
        }
        if (parent == null) {
            throw new RuntimeException("unexpected item view type");
        }
        this.mItemPicker = new ItemPicker(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(3, 0x1020010);
        parent.addView((View)this.mItemPicker, (ViewGroup.LayoutParams)params);
        this.mItemPicker.setRange(this.mMinValue, this.mMaxValue);
        this.mItemPicker.setValue(this.preferenceValue);
        this.preferenceValue = this.mItemPicker.getValue();
        this.persistInt(this.preferenceValue);
        this.mItemPicker.setOnChangeListener(this.mOnChangeListener);
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getInt(index, 0);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        int def = this.preferenceValue;
        if (defaultValue instanceof Integer) {
            def = (Integer)defaultValue;
        } else if (defaultValue instanceof String) {
            try {
                def = Integer.parseInt((String)defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (restorePersistedValue) {
            this.preferenceValue = this.getPersistedInt(def);
        } else {
            this.preferenceValue = def;
            this.persistInt(this.preferenceValue);
        }
    }

    public void setRange(int min, int max) {
        if (min > max) {
            int w = min;
            min = max;
            max = w;
        }
        if (this.mMinValue != min || this.mMaxValue != max) {
            this.mMaxValue = max;
            this.mMinValue = min;
            if (this.mItemPicker != null) {
                this.mItemPicker.setRange(this.mMinValue, this.mMaxValue);
                this.mItemPicker.setValue(this.preferenceValue);
                this.preferenceValue = this.mItemPicker.getValue();
                this.persistInt(this.preferenceValue);
            }
        }
    }
}

