/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.content.Context;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class TalkBackHelper {
    public static boolean isEnabled(@NonNull Context context) {
        AccessibilityManager manager = (AccessibilityManager)context.getSystemService("accessibility");
        return manager.isEnabled();
    }

    public static void announceText(@NonNull Context context, @Nullable CharSequence text) throws IllegalStateException {
        AccessibilityEvent event;
        if (TextUtils.isEmpty((CharSequence)text) || context == null) {
            return;
        }
        AccessibilityManager manager = (AccessibilityManager)context.getSystemService("accessibility");
        if (manager != null && manager.isEnabled()) {
            event = AccessibilityEvent.obtain();
            if (event == null) {
                throw new IllegalStateException("failed to obtain AccessibilityEvent");
            }
        } else {
            throw new IllegalStateException("AccessibilityManager is not available/or disabled");
        }
        event.setEventType(16384);
        event.setClassName((CharSequence)TalkBackHelper.class.getName());
        event.setPackageName((CharSequence)context.getPackageName());
        event.getText().add(text);
        manager.sendAccessibilityEvent(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void announceText(@NonNull Context context, @Nullable CharSequence[] text) throws IllegalStateException {
        if (text == null || text.length == 0 || context == null) {
            return;
        }
        AccessibilityManager manager = (AccessibilityManager)context.getSystemService("accessibility");
        if (manager == null || !manager.isEnabled()) throw new IllegalStateException("AccessibilityManager is not available/or disabled");
        AccessibilityEvent event = AccessibilityEvent.obtain();
        if (event == null) throw new IllegalStateException("failed to obtain AccessibilityEvent");
        event.setEventType(16384);
        event.setClassName((CharSequence)TalkBackHelper.class.getName());
        event.setPackageName((CharSequence)context.getPackageName());
        for (CharSequence t : text) {
            event.getText().add(t);
        }
        manager.sendAccessibilityEvent(event);
    }
}

