/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.media.Encoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MediaData;
import com.serenegiant.media.TimeoutException;
import com.serenegiant.utils.BufferHelper;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.Time;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@TargetApi(value=17)
public abstract class AbstractFakeEncoder
implements Encoder {
    private static final String TAG = AbstractFakeEncoder.class.getSimpleName();
    @SuppressLint(value={"InlinedApi"})
    public static final int BUFFER_FLAG_KEY_FRAME = BuildCheck.isLollipop() ? 1 : 1;
    private static final int DEFAULT_MAX_POOL_SZ = 8;
    private static final int DEFAULT_MAX_QUEUE_SZ = 6;
    private static final int DEFAULT_FRAME_SZ = 1024;
    private static final long MAX_WAIT_FRAME_MS = 100L;
    private volatile boolean mIsCapturing;
    private volatile boolean mRequestStop;
    private volatile boolean mRecorderStarted;
    private volatile boolean mWaitingKeyFrame;
    private boolean mIsEOS;
    private int mTrackIndex;
    private IRecorder mRecorder;
    private final Object mSync = new Object();
    private final EncoderListener mListener;
    private final String MIME_TYPE;
    private final int FRAME_SZ;
    private final int MAX_POOL_SZ;
    private final List<MediaData> mPool = new ArrayList<MediaData>();
    private final LinkedBlockingQueue<MediaData> mFrameQueue;
    private final MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    private Thread mDrainThread;
    private int cnt = 0;
    private final Runnable mDrainTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AbstractFakeEncoder.this.mSync;
            synchronized (object) {
                AbstractFakeEncoder.this.mRequestStop = false;
                AbstractFakeEncoder.this.mSync.notify();
            }
            while (AbstractFakeEncoder.this.mIsCapturing) {
                MediaData frame = AbstractFakeEncoder.this.waitFrame(100L);
                if (frame == null) continue;
                try {
                    if (!AbstractFakeEncoder.this.mIsCapturing) continue;
                    AbstractFakeEncoder.this.handleFrame(frame);
                }
                finally {
                    AbstractFakeEncoder.this.recycle(frame);
                }
            }
            object = AbstractFakeEncoder.this.mSync;
            synchronized (object) {
                AbstractFakeEncoder.this.mRequestStop = true;
                AbstractFakeEncoder.this.mIsCapturing = false;
            }
            AbstractFakeEncoder.this.mDrainThread = null;
        }
    };
    private long prevInputPTSUs = -1L;
    private long prevOutputPTSUs = -1L;

    public AbstractFakeEncoder(String mimeType, @NonNull IRecorder recorder, @NonNull EncoderListener listener) {
        this(mimeType, recorder, listener, 1024, 8, 6);
    }

    public AbstractFakeEncoder(String mimeType, @NonNull IRecorder recorder, @NonNull EncoderListener listener, int frameSz) {
        this(mimeType, recorder, listener, frameSz, 8, 6);
    }

    public AbstractFakeEncoder(String mimeType, @NonNull IRecorder recorder, @NonNull EncoderListener listener, int frameSz, int maxPoolSz, int maxQueueSz) {
        this.MIME_TYPE = mimeType;
        this.FRAME_SZ = frameSz;
        this.MAX_POOL_SZ = maxPoolSz;
        this.mRecorder = recorder;
        this.mListener = listener;
        this.mFrameQueue = new LinkedBlockingQueue(maxQueueSz);
        recorder.addEncoder(this);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public IRecorder getRecorder() {
        return this.mRecorder;
    }

    public boolean isRecorderStarted() {
        return this.mRecorderStarted;
    }

    @Override
    public String getOutputPath() {
        return this.mRecorder != null ? this.mRecorder.getOutputPath() : null;
    }

    @Override
    public synchronized void release() {
        try {
            if (this.mDrainThread != null) {
                this.mDrainThread.interrupt();
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
        this.mDrainThread = null;
        if (this.mRecorder != null) {
            this.internalRelease();
        }
    }

    @Override
    public void signalEndOfInputStream() {
        MediaData frame = this.obtain(0);
        frame.set(null, 0, 0, this.getInputPTSUs(), 4);
        this.offer(frame);
    }

    @Override
    public void encode(ByteBuffer buffer) {
        throw new UnsupportedOperationException("can not call encode");
    }

    @Override
    public void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        throw new UnsupportedOperationException("can not call encode");
    }

    public boolean queueFrame(@Nullable ByteBuffer buffer, int offset, int size, long presentationTimeUs, int flags) throws IllegalStateException {
        if (!this.mIsCapturing) {
            throw new IllegalStateException();
        }
        if (this.mRequestStop) {
            return false;
        }
        MediaData frame = this.obtain(size);
        frame.set(buffer, offset, size, presentationTimeUs, flags);
        return this.offer(frame);
    }

    @Override
    public boolean isCapturing() {
        return this.mIsCapturing;
    }

    @Override
    public void prepare() throws Exception {
        this.mTrackIndex = -1;
        this.mRecorderStarted = false;
        this.mWaitingKeyFrame = true;
        this.mIsCapturing = true;
        this.mIsEOS = false;
        this.mRequestStop = false;
        this.callOnStartEncode(null, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mIsCapturing && !this.mRequestStop) {
                this.initPool();
                this.mDrainThread = new Thread(this.mDrainTask, this.getClass().getSimpleName());
                this.mDrainThread.start();
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRequestStop) {
                return;
            }
            this.mRequestStop = true;
            this.signalEndOfInputStream();
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            this.mSync.notifyAll();
        }
    }

    protected void callOnStartEncode(Surface source, int captureFormat, boolean mayFail) {
        try {
            this.mListener.onStartEncode(this, source, captureFormat, mayFail);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    protected void callOnError(Exception e) {
        try {
            this.mListener.onError(e);
        }
        catch (Exception e2) {
            Log.w((String)TAG, (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        this.mFrameQueue.clear();
        List<MediaData> list = this.mPool;
        synchronized (list) {
            this.mPool.clear();
            for (int i = 0; i < this.MAX_POOL_SZ; ++i) {
                this.mPool.add(new MediaData(this.FRAME_SZ));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearFrames() {
        List<MediaData> list = this.mPool;
        synchronized (list) {
            this.mPool.clear();
        }
        this.mFrameQueue.clear();
        this.cnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaData obtain(int newSize) {
        MediaData result;
        List<MediaData> list = this.mPool;
        synchronized (list) {
            if (this.mPool.isEmpty()) {
                ++this.cnt;
                result = new MediaData(this.FRAME_SZ);
            } else {
                result = this.mPool.remove(this.mPool.size() - 1);
                result.resize(newSize);
            }
        }
        return result;
    }

    protected boolean offer(@NonNull MediaData frame) {
        boolean result = this.mFrameQueue.offer(frame);
        if (!result) {
            MediaData head = this.mFrameQueue.poll();
            result = this.mFrameQueue.offer(frame);
            if (head != null) {
                this.recycle(head);
            }
        }
        return result;
    }

    protected MediaData waitFrame(long waitTimeMs) {
        MediaData result = null;
        try {
            result = this.mFrameQueue.poll(waitTimeMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle(@NonNull MediaData frame) {
        List<MediaData> list = this.mPool;
        synchronized (list) {
            if (this.mPool.size() < this.MAX_POOL_SZ) {
                this.mPool.add(frame);
            } else {
                --this.cnt;
            }
        }
    }

    protected void handleFrame(MediaData frame) {
        boolean isKeyFrame;
        IRecorder recorder = this.mRecorder;
        if (recorder == null) {
            Log.w((String)TAG, (String)"muxer is unexpectedly null");
            return;
        }
        this.mBufferInfo.set(0, frame.size, frame.presentationTimeUs, frame.flags);
        boolean bl = isKeyFrame = (this.mBufferInfo.flags & BUFFER_FLAG_KEY_FRAME) == BUFFER_FLAG_KEY_FRAME;
        if (!this.mRecorderStarted && (isKeyFrame || (this.mBufferInfo.flags & 2) != 0)) {
            byte[] tmp = new byte[this.mBufferInfo.size];
            ByteBuffer b = frame.mBuffer.duplicate();
            b.clear();
            b.get(tmp, 0, this.mBufferInfo.size);
            int ix0 = BufferHelper.findAnnexB(tmp, 0);
            int ix1 = BufferHelper.findAnnexB(tmp, ix0 + 2);
            int ix2 = BufferHelper.findAnnexB(tmp, ix1 + 2);
            try {
                MediaFormat outFormat = this.createOutputFormat(this.MIME_TYPE, tmp, this.mBufferInfo.size, ix0, ix1, ix2);
                if (!this.startRecorder(recorder, outFormat)) {
                    Log.w((String)TAG, (String)"handleFrame:failed to start recorder");
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if ((this.mBufferInfo.flags & 2) != 0) {
            this.mBufferInfo.size = 0;
        }
        if (this.mRecorderStarted && this.mBufferInfo.size != 0 && (isKeyFrame || !this.mWaitingKeyFrame)) {
            this.mWaitingKeyFrame = false;
            try {
                this.mBufferInfo.presentationTimeUs = this.getNextOutputPTSUs(this.mBufferInfo.presentationTimeUs);
                recorder.writeSampleData(this.mTrackIndex, frame.mBuffer, this.mBufferInfo);
            }
            catch (TimeoutException e) {
                recorder.stopRecording();
            }
            catch (Exception e) {
                recorder.stopRecording();
            }
        }
        if ((this.mBufferInfo.flags & 4) != 0) {
            this.stopRecorder(recorder);
        }
    }

    protected abstract MediaFormat createOutputFormat(String var1, byte[] var2, int var3, int var4, int var5, int var6);

    protected boolean startRecorder(IRecorder recorder, MediaFormat outFormat) {
        this.mTrackIndex = recorder.addTrack(this, outFormat);
        if (this.mTrackIndex >= 0) {
            this.mRecorderStarted = true;
            if (!recorder.start(this)) {
                Log.e((String)TAG, (String)("failed to start muxer mTrackIndex=" + this.mTrackIndex));
            }
        } else {
            Log.e((String)TAG, (String)("failed to addTrack: mTrackIndex=" + this.mTrackIndex));
            recorder.removeEncoder(this);
        }
        return recorder.isStarted();
    }

    protected void stopRecorder(IRecorder recorder) {
        if (this.mRecorder != null) {
            this.internalRelease();
        }
    }

    private void internalRelease() {
        this.mIsEOS = true;
        if (this.mIsCapturing) {
            this.mIsCapturing = false;
            try {
                this.mListener.onStopEncode(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed onStopped", (Throwable)e);
            }
        }
        if (this.mRecorderStarted) {
            this.mRecorderStarted = false;
            if (this.mRecorder != null) {
                try {
                    this.mRecorder.stop(this);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"failed stopping muxer", (Throwable)e);
                }
            }
        }
        try {
            this.mListener.onDestroy(this);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"destroy:", (Throwable)e);
        }
        this.mRecorder = null;
        this.clearFrames();
    }

    protected long getInputPTSUs() {
        long result = Time.nanoTime() / 1000L;
        if (result <= this.prevInputPTSUs) {
            result = this.prevInputPTSUs + 9643L;
        }
        this.prevInputPTSUs = result;
        return result;
    }

    protected long getNextOutputPTSUs(long presentationTimeUs) {
        if (presentationTimeUs <= this.prevOutputPTSUs) {
            presentationTimeUs = this.prevOutputPTSUs + 9643L;
        }
        this.prevOutputPTSUs = presentationTimeUs;
        return presentationTimeUs;
    }
}

