/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.jiangdg.common.R;
import com.jiangdg.dialog.MessageDialogFragmentV4;
import com.jiangdg.utils.BuildCheck;
import com.jiangdg.utils.HandlerThreadHandler;
import com.jiangdg.utils.PermissionCheck;

public class BaseActivity
extends AppCompatActivity
implements MessageDialogFragmentV4.MessageDialogListener {
    private static boolean DEBUG = false;
    private static final String TAG = BaseActivity.class.getSimpleName();
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private final Thread mUiThread = this.mUIHandler.getLooper().getThread();
    private Handler mWorkerHandler;
    private long mWorkerThreadID = -1L;
    private Toast mToast;
    private ShowToastTask mShowToastTask;
    protected static final int REQUEST_PERMISSION_WRITE_EXTERNAL_STORAGE = 74565;
    protected static final int REQUEST_PERMISSION_AUDIO_RECORDING = 2311527;
    protected static final int REQUEST_PERMISSION_NETWORK = 3430008;
    protected static final int REQUEST_PERMISSION_CAMERA = 5469762;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mWorkerHandler == null) {
            this.mWorkerHandler = HandlerThreadHandler.createHandler((String)TAG);
            this.mWorkerThreadID = this.mWorkerHandler.getLooper().getThread().getId();
        }
    }

    protected void onPause() {
        this.clearToast();
        super.onPause();
    }

    protected synchronized void onDestroy() {
        if (this.mWorkerHandler != null) {
            try {
                this.mWorkerHandler.getLooper().quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mWorkerHandler = null;
        }
        super.onDestroy();
    }

    public final void runOnUiThread(Runnable task, long duration) {
        if (task == null) {
            return;
        }
        this.mUIHandler.removeCallbacks(task);
        if (duration > 0L || Thread.currentThread() != this.mUiThread) {
            this.mUIHandler.postDelayed(task, duration);
        } else {
            try {
                task.run();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public final void removeFromUiThread(Runnable task) {
        if (task == null) {
            return;
        }
        this.mUIHandler.removeCallbacks(task);
    }

    protected final synchronized void queueEvent(Runnable task, long delayMillis) {
        if (task == null || this.mWorkerHandler == null) {
            return;
        }
        try {
            this.mWorkerHandler.removeCallbacks(task);
            if (delayMillis > 0L) {
                this.mWorkerHandler.postDelayed(task, delayMillis);
            } else if (this.mWorkerThreadID == Thread.currentThread().getId()) {
                task.run();
            } else {
                this.mWorkerHandler.post(task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final synchronized void removeEvent(Runnable task) {
        if (task == null) {
            return;
        }
        try {
            this.mWorkerHandler.removeCallbacks(task);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showToast(@StringRes int msg, Object ... args) {
        this.removeFromUiThread(this.mShowToastTask);
        this.mShowToastTask = new ShowToastTask(msg, args);
        this.runOnUiThread(this.mShowToastTask, 0L);
    }

    protected void clearToast() {
        this.removeFromUiThread(this.mShowToastTask);
        this.mShowToastTask = null;
        try {
            if (this.mToast != null) {
                this.mToast.cancel();
                this.mToast = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onMessageDialogResult(MessageDialogFragmentV4 dialog, int requestCode, String[] permissions, boolean result) {
        if (result && BuildCheck.isMarshmallow()) {
            this.requestPermissions(permissions, requestCode);
            return;
        }
        for (String permission2 : permissions) {
            this.checkPermissionResult(requestCode, permission2, PermissionCheck.hasPermission((Context)this, (String)permission2));
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        int n = Math.min(permissions.length, grantResults.length);
        for (int i = 0; i < n; ++i) {
            this.checkPermissionResult(requestCode, permissions[i], grantResults[i] == 0);
        }
    }

    protected void checkPermissionResult(int requestCode, String permission2, boolean result) {
        if (!result && permission2 != null) {
            if ("android.permission.RECORD_AUDIO".equals(permission2)) {
                this.showToast(R.string.permission_audio, new Object[0]);
            }
            if ("android.permission.WRITE_EXTERNAL_STORAGE".equals(permission2)) {
                this.showToast(R.string.permission_ext_storage, new Object[0]);
            }
            if ("android.permission.INTERNET".equals(permission2)) {
                this.showToast(R.string.permission_network, new Object[0]);
            }
        }
    }

    protected boolean checkPermissionWriteExternalStorage() {
        if (!PermissionCheck.hasWriteExternalStorage((Context)this)) {
            MessageDialogFragmentV4.showDialog((FragmentActivity)this, (int)74565, (int)R.string.permission_title, (int)R.string.permission_ext_storage_request, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
            return false;
        }
        return true;
    }

    protected boolean checkPermissionAudio() {
        if (!PermissionCheck.hasAudio((Context)this)) {
            MessageDialogFragmentV4.showDialog((FragmentActivity)this, (int)2311527, (int)R.string.permission_title, (int)R.string.permission_audio_recording_request, (String[])new String[]{"android.permission.RECORD_AUDIO"});
            return false;
        }
        return true;
    }

    protected boolean checkPermissionNetwork() {
        if (!PermissionCheck.hasNetwork((Context)this)) {
            MessageDialogFragmentV4.showDialog((FragmentActivity)this, (int)3430008, (int)R.string.permission_title, (int)R.string.permission_network_request, (String[])new String[]{"android.permission.INTERNET"});
            return false;
        }
        return true;
    }

    protected boolean checkPermissionCamera() {
        if (!PermissionCheck.hasCamera((Context)this)) {
            MessageDialogFragmentV4.showDialog((FragmentActivity)this, (int)5469762, (int)R.string.permission_title, (int)R.string.permission_camera_request, (String[])new String[]{"android.permission.CAMERA"});
            return false;
        }
        return true;
    }

    private final class ShowToastTask
    implements Runnable {
        final int msg;
        final Object args;

        private ShowToastTask(int msg, Object ... args) {
            this.msg = msg;
            this.args = args;
        }

        @Override
        public void run() {
            try {
                if (BaseActivity.this.mToast != null) {
                    BaseActivity.this.mToast.cancel();
                    BaseActivity.this.mToast = null;
                }
                String _msg = this.args != null ? BaseActivity.this.getString(this.msg, new Object[]{this.args}) : BaseActivity.this.getString(this.msg);
                BaseActivity.this.mToast = Toast.makeText((Context)BaseActivity.this, (CharSequence)_msg, (int)0);
                BaseActivity.this.mToast.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

