/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.USBVendorId;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.HandlerThreadHandler;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class USBMonitor {
    private static final boolean DEBUG = false;
    private static final String TAG = "USBMonitor";
    private static final String ACTION_USB_PERMISSION_BASE = "com.serenegiant.USB_PERMISSION.";
    private final String ACTION_USB_PERMISSION = "com.serenegiant.USB_PERMISSION." + this.hashCode();
    public static final String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    private final ConcurrentHashMap<UsbDevice, UsbControlBlock> mCtrlBlocks = new ConcurrentHashMap();
    private final SparseArray<WeakReference<UsbDevice>> mHasPermissions = new SparseArray();
    private final WeakReference<Context> mWeakContext;
    private final UsbManager mUsbManager;
    private final OnDeviceConnectListener mOnDeviceConnectListener;
    private PendingIntent mPermissionIntent = null;
    private List<DeviceFilter> mDeviceFilters = new ArrayList<DeviceFilter>();
    private final Handler mAsyncHandler;
    private volatile boolean destroyed;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            if (USBMonitor.this.destroyed) {
                return;
            }
            String action = intent.getAction();
            if (USBMonitor.this.ACTION_USB_PERMISSION.equals(action)) {
                USBMonitor uSBMonitor = USBMonitor.this;
                synchronized (uSBMonitor) {
                    UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (device2 != null) {
                            USBMonitor.this.processConnect(device2);
                        }
                    } else {
                        USBMonitor.this.processCancel(device2);
                    }
                }
            } else if (USBMonitor.ACTION_USB_DEVICE_ATTACHED.equals(action)) {
                UsbDevice device3 = (UsbDevice)intent.getParcelableExtra("device");
                USBMonitor.this.updatePermission(device3, USBMonitor.this.hasPermission(device3));
                USBMonitor.this.processAttach(device3);
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                UsbControlBlock ctrlBlock = (UsbControlBlock)USBMonitor.this.mCtrlBlocks.remove(device);
                if (ctrlBlock != null) {
                    ctrlBlock.close();
                }
                USBMonitor.this.mDeviceCounts = 0;
                USBMonitor.this.processDettach(device);
            }
        }
    };
    private volatile int mDeviceCounts = 0;
    private final Runnable mDeviceCheckRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int m;
            int hasPermissionCounts;
            if (USBMonitor.this.destroyed) {
                return;
            }
            List<UsbDevice> devices = USBMonitor.this.getDeviceList();
            int n = devices.size();
            SparseArray sparseArray = USBMonitor.this.mHasPermissions;
            synchronized (sparseArray) {
                hasPermissionCounts = USBMonitor.this.mHasPermissions.size();
                USBMonitor.this.mHasPermissions.clear();
                for (UsbDevice device : devices) {
                    USBMonitor.this.hasPermission(device);
                }
                m = USBMonitor.this.mHasPermissions.size();
            }
            if (n > USBMonitor.this.mDeviceCounts || m > hasPermissionCounts) {
                USBMonitor.this.mDeviceCounts = n;
                if (USBMonitor.this.mOnDeviceConnectListener != null) {
                    for (int i = 0; i < n; ++i) {
                        final UsbDevice device = devices.get(i);
                        USBMonitor.this.mAsyncHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                            }
                        });
                    }
                }
            }
            USBMonitor.this.mAsyncHandler.postDelayed((Runnable)this, 2000L);
        }
    };
    private static final int USB_DIR_OUT = 0;
    private static final int USB_DIR_IN = 128;
    private static final int USB_TYPE_MASK = 96;
    private static final int USB_TYPE_STANDARD = 0;
    private static final int USB_TYPE_CLASS = 32;
    private static final int USB_TYPE_VENDOR = 64;
    private static final int USB_TYPE_RESERVED = 96;
    private static final int USB_RECIP_MASK = 31;
    private static final int USB_RECIP_DEVICE = 0;
    private static final int USB_RECIP_INTERFACE = 1;
    private static final int USB_RECIP_ENDPOINT = 2;
    private static final int USB_RECIP_OTHER = 3;
    private static final int USB_RECIP_PORT = 4;
    private static final int USB_RECIP_RPIPE = 5;
    private static final int USB_REQ_GET_STATUS = 0;
    private static final int USB_REQ_CLEAR_FEATURE = 1;
    private static final int USB_REQ_SET_FEATURE = 3;
    private static final int USB_REQ_SET_ADDRESS = 5;
    private static final int USB_REQ_GET_DESCRIPTOR = 6;
    private static final int USB_REQ_SET_DESCRIPTOR = 7;
    private static final int USB_REQ_GET_CONFIGURATION = 8;
    private static final int USB_REQ_SET_CONFIGURATION = 9;
    private static final int USB_REQ_GET_INTERFACE = 10;
    private static final int USB_REQ_SET_INTERFACE = 11;
    private static final int USB_REQ_SYNCH_FRAME = 12;
    private static final int USB_REQ_SET_SEL = 48;
    private static final int USB_REQ_SET_ISOCH_DELAY = 49;
    private static final int USB_REQ_SET_ENCRYPTION = 13;
    private static final int USB_REQ_GET_ENCRYPTION = 14;
    private static final int USB_REQ_RPIPE_ABORT = 14;
    private static final int USB_REQ_SET_HANDSHAKE = 15;
    private static final int USB_REQ_RPIPE_RESET = 15;
    private static final int USB_REQ_GET_HANDSHAKE = 16;
    private static final int USB_REQ_SET_CONNECTION = 17;
    private static final int USB_REQ_SET_SECURITY_DATA = 18;
    private static final int USB_REQ_GET_SECURITY_DATA = 19;
    private static final int USB_REQ_SET_WUSB_DATA = 20;
    private static final int USB_REQ_LOOPBACK_DATA_WRITE = 21;
    private static final int USB_REQ_LOOPBACK_DATA_READ = 22;
    private static final int USB_REQ_SET_INTERFACE_DS = 23;
    private static final int USB_REQ_STANDARD_DEVICE_SET = 0;
    private static final int USB_REQ_STANDARD_DEVICE_GET = 128;
    private static final int USB_REQ_STANDARD_INTERFACE_SET = 1;
    private static final int USB_REQ_STANDARD_INTERFACE_GET = 129;
    private static final int USB_REQ_STANDARD_ENDPOINT_SET = 2;
    private static final int USB_REQ_STANDARD_ENDPOINT_GET = 130;
    private static final int USB_REQ_CS_DEVICE_SET = 32;
    private static final int USB_REQ_CS_DEVICE_GET = 160;
    private static final int USB_REQ_CS_INTERFACE_SET = 33;
    private static final int USB_REQ_CS_INTERFACE_GET = 161;
    private static final int USB_REQ_CS_ENDPOINT_SET = 34;
    private static final int USB_REQ_CS_ENDPOINT_GET = 162;
    private static final int USB_REQ_VENDER_DEVICE_SET = 32;
    private static final int USB_REQ_VENDER_DEVICE_GET = 160;
    private static final int USB_REQ_VENDER_INTERFACE_SET = 33;
    private static final int USB_REQ_VENDER_INTERFACE_GET = 161;
    private static final int USB_REQ_VENDER_ENDPOINT_SET = 34;
    private static final int USB_REQ_VENDER_ENDPOINT_GET = 162;
    private static final int USB_DT_DEVICE = 1;
    private static final int USB_DT_CONFIG = 2;
    private static final int USB_DT_STRING = 3;
    private static final int USB_DT_INTERFACE = 4;
    private static final int USB_DT_ENDPOINT = 5;
    private static final int USB_DT_DEVICE_QUALIFIER = 6;
    private static final int USB_DT_OTHER_SPEED_CONFIG = 7;
    private static final int USB_DT_INTERFACE_POWER = 8;
    private static final int USB_DT_OTG = 9;
    private static final int USB_DT_DEBUG = 10;
    private static final int USB_DT_INTERFACE_ASSOCIATION = 11;
    private static final int USB_DT_SECURITY = 12;
    private static final int USB_DT_KEY = 13;
    private static final int USB_DT_ENCRYPTION_TYPE = 14;
    private static final int USB_DT_BOS = 15;
    private static final int USB_DT_DEVICE_CAPABILITY = 16;
    private static final int USB_DT_WIRELESS_ENDPOINT_COMP = 17;
    private static final int USB_DT_WIRE_ADAPTER = 33;
    private static final int USB_DT_RPIPE = 34;
    private static final int USB_DT_CS_RADIO_CONTROL = 35;
    private static final int USB_DT_PIPE_USAGE = 36;
    private static final int USB_DT_SS_ENDPOINT_COMP = 48;
    private static final int USB_DT_CS_DEVICE = 33;
    private static final int USB_DT_CS_CONFIG = 34;
    private static final int USB_DT_CS_STRING = 35;
    private static final int USB_DT_CS_INTERFACE = 36;
    private static final int USB_DT_CS_ENDPOINT = 37;
    private static final int USB_DT_DEVICE_SIZE = 18;

    public USBMonitor(Context context, OnDeviceConnectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OnDeviceConnectListener should not null.");
        }
        this.mWeakContext = new WeakReference<Context>(context);
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        this.mOnDeviceConnectListener = listener;
        this.mAsyncHandler = HandlerThreadHandler.createHandler((String)TAG);
        this.destroyed = false;
    }

    public void destroy() {
        this.unregister();
        if (!this.destroyed) {
            this.destroyed = true;
            Set keys = this.mCtrlBlocks.keySet();
            if (keys != null) {
                try {
                    for (UsbDevice key : keys) {
                        UsbControlBlock ctrlBlock = this.mCtrlBlocks.remove(key);
                        if (ctrlBlock == null) continue;
                        ctrlBlock.close();
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"destroy:", (Throwable)e);
                }
            }
            this.mCtrlBlocks.clear();
            try {
                this.mAsyncHandler.getLooper().quit();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"destroy:", (Throwable)e);
            }
        }
    }

    public synchronized void register() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        if (this.mPermissionIntent == null) {
            Context context = (Context)this.mWeakContext.get();
            if (context != null) {
                this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
                IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                filter.addAction(ACTION_USB_DEVICE_ATTACHED);
                filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                context.registerReceiver(this.mUsbReceiver, filter);
            }
            this.mDeviceCounts = 0;
            this.mAsyncHandler.postDelayed(this.mDeviceCheckRunnable, 1000L);
        }
    }

    public synchronized void unregister() throws IllegalStateException {
        this.mDeviceCounts = 0;
        if (!this.destroyed) {
            this.mAsyncHandler.removeCallbacks(this.mDeviceCheckRunnable);
        }
        if (this.mPermissionIntent != null) {
            Context context = (Context)this.mWeakContext.get();
            try {
                if (context != null) {
                    context.unregisterReceiver(this.mUsbReceiver);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mPermissionIntent = null;
        }
    }

    public synchronized boolean isRegistered() {
        return !this.destroyed && this.mPermissionIntent != null;
    }

    public void setDeviceFilter(DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.clear();
        this.mDeviceFilters.add(filter);
    }

    public void addDeviceFilter(DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.add(filter);
    }

    public void removeDeviceFilter(DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.remove(filter);
    }

    public void setDeviceFilter(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.clear();
        this.mDeviceFilters.addAll(filters);
    }

    public void addDeviceFilter(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.addAll(filters);
    }

    public void removeDeviceFilter(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.removeAll(filters);
    }

    public int getDeviceCount() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        return this.getDeviceList().size();
    }

    public List<UsbDevice> getDeviceList() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        return this.getDeviceList(this.mDeviceFilters);
    }

    public List<UsbDevice> getDeviceList(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (deviceList != null) {
            if (filters == null || filters.isEmpty()) {
                result.addAll(deviceList.values());
            } else {
                block0: for (UsbDevice device : deviceList.values()) {
                    for (DeviceFilter filter : filters) {
                        if ((filter == null || !filter.matches(device)) && (filter == null || filter.mSubclass != device.getDeviceSubclass())) continue;
                        if (filter.isExclude) continue block0;
                        result.add(device);
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    public List<UsbDevice> getDeviceList(DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (deviceList != null) {
            for (UsbDevice device : deviceList.values()) {
                if (filter != null && (!filter.matches(device) || filter.isExclude)) continue;
                result.add(device);
            }
        }
        return result;
    }

    public Iterator<UsbDevice> getDevices() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        Iterator iterator = null;
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            iterator = list.values().iterator();
        }
        return iterator;
    }

    public final void dumpDevices() {
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            Set keys = list.keySet();
            if (keys != null && keys.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    UsbDevice device = (UsbDevice)list.get(key);
                    int num_interface = device != null ? device.getInterfaceCount() : 0;
                    sb.setLength(0);
                    for (int i = 0; i < num_interface; ++i) {
                        sb.append(String.format(Locale.US, "interface%d:%s", i, device.getInterface(i).toString()));
                    }
                    Log.i((String)TAG, (String)("key=" + key + ":" + device + ":" + sb.toString()));
                }
            } else {
                Log.i((String)TAG, (String)"no device");
            }
        } else {
            Log.i((String)TAG, (String)"no device");
        }
    }

    public final boolean hasPermission(UsbDevice device) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        return this.updatePermission(device, device != null && this.mUsbManager.hasPermission(device));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updatePermission(UsbDevice device, boolean hasPermission) {
        try {
            int deviceKey = USBMonitor.getDeviceKey(device, true);
            SparseArray<WeakReference<UsbDevice>> sparseArray = this.mHasPermissions;
            synchronized (sparseArray) {
                if (hasPermission) {
                    if (this.mHasPermissions.get(deviceKey) == null) {
                        this.mHasPermissions.put(deviceKey, new WeakReference<UsbDevice>(device));
                    }
                } else {
                    this.mHasPermissions.remove(deviceKey);
                }
            }
        }
        catch (SecurityException e) {
            Log.w((String)"jiangdg", (String)e.getLocalizedMessage());
        }
        return hasPermission;
    }

    public synchronized boolean requestPermission(UsbDevice device) {
        boolean result = false;
        if (this.isRegistered()) {
            if (device != null) {
                if (this.mUsbManager.hasPermission(device)) {
                    this.processConnect(device);
                } else {
                    try {
                        this.mUsbManager.requestPermission(device, this.mPermissionIntent);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                        this.processCancel(device);
                        result = true;
                    }
                }
            } else {
                this.processCancel(device);
                result = true;
            }
        } else {
            this.processCancel(device);
            result = true;
        }
        return result;
    }

    public UsbControlBlock openDevice(UsbDevice device) throws SecurityException {
        if (this.hasPermission(device)) {
            UsbControlBlock result = this.mCtrlBlocks.get(device);
            if (result == null) {
                result = new UsbControlBlock(this, device);
                this.mCtrlBlocks.put(device, result);
            }
            return result;
        }
        throw new SecurityException("has no permission");
    }

    private final void processConnect(final UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        this.updatePermission(device, true);
        this.mAsyncHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean createNew;
                UsbControlBlock ctrlBlock = (UsbControlBlock)USBMonitor.this.mCtrlBlocks.get(device);
                if (ctrlBlock == null) {
                    ctrlBlock = new UsbControlBlock(USBMonitor.this, device);
                    USBMonitor.this.mCtrlBlocks.put(device, ctrlBlock);
                    createNew = true;
                } else {
                    createNew = false;
                }
                if (USBMonitor.this.mOnDeviceConnectListener != null) {
                    USBMonitor.this.mOnDeviceConnectListener.onConnect(device, ctrlBlock, createNew);
                }
            }
        });
    }

    private final void processCancel(final UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        this.updatePermission(device, false);
        if (this.mOnDeviceConnectListener != null) {
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onCancel(device);
                }
            });
        }
    }

    private final void processAttach(final UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (this.mOnDeviceConnectListener != null) {
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                }
            });
        }
    }

    private final void processDettach(final UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (this.mOnDeviceConnectListener != null) {
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onDetach(device);
                }
            });
        }
    }

    public static final String getDeviceKeyName(UsbDevice device) {
        return USBMonitor.getDeviceKeyName(device, null, false);
    }

    public static final String getDeviceKeyName(UsbDevice device, boolean useNewAPI) {
        return USBMonitor.getDeviceKeyName(device, null, useNewAPI);
    }

    @SuppressLint(value={"NewApi"})
    public static final String getDeviceKeyName(UsbDevice device, String serial, boolean useNewAPI) {
        if (device == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(device.getVendorId());
        sb.append("#");
        sb.append(device.getProductId());
        sb.append("#");
        sb.append(device.getDeviceClass());
        sb.append("#");
        sb.append(device.getDeviceSubclass());
        sb.append("#");
        sb.append(device.getDeviceProtocol());
        if (!TextUtils.isEmpty((CharSequence)serial)) {
            sb.append("#");
            sb.append(serial);
        }
        if (useNewAPI && BuildCheck.isAndroid5()) {
            sb.append("#");
            if (TextUtils.isEmpty((CharSequence)serial)) {
                try {
                    sb.append(device.getSerialNumber());
                    sb.append("#");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            sb.append(device.getManufacturerName());
            sb.append("#");
            sb.append(device.getConfigurationCount());
            sb.append("#");
            if (BuildCheck.isMarshmallow()) {
                sb.append(device.getVersion());
                sb.append("#");
            }
        }
        return sb.toString();
    }

    public static final int getDeviceKey(UsbDevice device) {
        return device != null ? USBMonitor.getDeviceKeyName(device, null, false).hashCode() : 0;
    }

    public static final int getDeviceKey(UsbDevice device, boolean useNewAPI) {
        return device != null ? USBMonitor.getDeviceKeyName(device, null, useNewAPI).hashCode() : 0;
    }

    public static final int getDeviceKey(UsbDevice device, String serial, boolean useNewAPI) {
        return device != null ? USBMonitor.getDeviceKeyName(device, serial, useNewAPI).hashCode() : 0;
    }

    private static String getString(UsbDeviceConnection connection, int id, int languageCount, byte[] languages) {
        byte[] work = new byte[256];
        String result = null;
        for (int i = 1; i <= languageCount; ++i) {
            int ret = connection.controlTransfer(128, 6, 0x300 | id, (int)languages[i], work, 256, 0);
            if (ret <= 2 || work[0] != ret || work[1] != 3) continue;
            try {
                result = new String(work, 2, ret - 2, "UTF-16LE");
                if (!"\u0409".equals(result)) break;
                result = null;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public UsbDeviceInfo getDeviceInfo(UsbDevice device) {
        return USBMonitor.updateDeviceInfo(this.mUsbManager, device, null);
    }

    public static UsbDeviceInfo getDeviceInfo(Context context, UsbDevice device) {
        return USBMonitor.updateDeviceInfo((UsbManager)context.getSystemService("usb"), device, new UsbDeviceInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=23)
    public static UsbDeviceInfo updateDeviceInfo(UsbManager manager, UsbDevice device, UsbDeviceInfo _info) {
        UsbDeviceInfo info = _info != null ? _info : new UsbDeviceInfo();
        info.clear();
        if (device != null) {
            if (BuildCheck.isLollipop()) {
                info.manufacturer = device.getManufacturerName();
                info.product = device.getProductName();
                info.serial = device.getSerialNumber();
            }
            if (BuildCheck.isMarshmallow()) {
                info.usb_version = device.getVersion();
            }
            if (manager != null && manager.hasPermission(device)) {
                UsbDeviceConnection connection = manager.openDevice(device);
                if (connection == null) {
                    return null;
                }
                byte[] desc = connection.getRawDescriptors();
                if (TextUtils.isEmpty((CharSequence)info.usb_version)) {
                    info.usb_version = String.format("%x.%02x", desc[3] & 0xFF, desc[2] & 0xFF);
                }
                if (TextUtils.isEmpty((CharSequence)info.version)) {
                    info.version = String.format("%x.%02x", desc[13] & 0xFF, desc[12] & 0xFF);
                }
                if (TextUtils.isEmpty((CharSequence)info.serial)) {
                    info.serial = connection.getSerial();
                }
                byte[] languages = new byte[256];
                int languageCount = 0;
                try {
                    int result = connection.controlTransfer(128, 6, 768, 0, languages, 256, 0);
                    if (result > 0) {
                        languageCount = (result - 2) / 2;
                    }
                    if (languageCount > 0) {
                        if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                            info.manufacturer = USBMonitor.getString(connection, desc[14], languageCount, languages);
                        }
                        if (TextUtils.isEmpty((CharSequence)info.product)) {
                            info.product = USBMonitor.getString(connection, desc[15], languageCount, languages);
                        }
                        if (TextUtils.isEmpty((CharSequence)info.serial)) {
                            info.serial = USBMonitor.getString(connection, desc[16], languageCount, languages);
                        }
                    }
                }
                finally {
                    connection.close();
                }
            }
            if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                info.manufacturer = USBVendorId.vendorName(device.getVendorId());
            }
            if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                info.manufacturer = String.format("%04x", device.getVendorId());
            }
            if (TextUtils.isEmpty((CharSequence)info.product)) {
                info.product = String.format("%04x", device.getProductId());
            }
        }
        return info;
    }

    public static final class UsbControlBlock
    implements Cloneable {
        private final WeakReference<USBMonitor> mWeakMonitor;
        private final WeakReference<UsbDevice> mWeakDevice;
        protected UsbDeviceConnection mConnection;
        protected final UsbDeviceInfo mInfo;
        private final int mBusNum;
        private final int mDevNum;
        private final SparseArray<SparseArray<UsbInterface>> mInterfaces = new SparseArray();

        private UsbControlBlock(USBMonitor monitor, UsbDevice device) {
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
            this.mConnection = monitor.mUsbManager.openDevice(device);
            this.mInfo = USBMonitor.updateDeviceInfo(monitor.mUsbManager, device, null);
            String name = device.getDeviceName();
            String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
            int busnum = 0;
            int devnum = 0;
            if (v != null) {
                busnum = Integer.parseInt(v[v.length - 2]);
                devnum = Integer.parseInt(v[v.length - 1]);
            }
            this.mBusNum = busnum;
            this.mDevNum = devnum;
            if (this.mConnection != null) {
                int desc = this.mConnection.getFileDescriptor();
                byte[] rawDesc = this.mConnection.getRawDescriptors();
                Log.i((String)USBMonitor.TAG, (String)(String.format(Locale.US, "name=%s,desc=%d,busnum=%d,devnum=%d,rawDesc=", name, desc, busnum, devnum) + rawDesc));
            } else {
                Log.e((String)USBMonitor.TAG, (String)("could not connect to device " + name));
            }
        }

        private UsbControlBlock(UsbControlBlock src) throws IllegalStateException {
            USBMonitor monitor = src.getUSBMonitor();
            UsbDevice device = src.getDevice();
            if (device == null) {
                throw new IllegalStateException("device may already be removed");
            }
            this.mConnection = monitor.mUsbManager.openDevice(device);
            if (this.mConnection == null) {
                throw new IllegalStateException("device may already be removed or have no permission");
            }
            this.mInfo = USBMonitor.updateDeviceInfo(monitor.mUsbManager, device, null);
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
            this.mBusNum = src.mBusNum;
            this.mDevNum = src.mDevNum;
        }

        public UsbControlBlock clone() throws CloneNotSupportedException {
            UsbControlBlock ctrlblock;
            try {
                ctrlblock = new UsbControlBlock(this);
            }
            catch (IllegalStateException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
            return ctrlblock;
        }

        public USBMonitor getUSBMonitor() {
            return (USBMonitor)this.mWeakMonitor.get();
        }

        public final UsbDevice getDevice() {
            return (UsbDevice)this.mWeakDevice.get();
        }

        public String getDeviceName() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceName() : "";
        }

        public int getDeviceId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceId() : 0;
        }

        public String getDeviceKeyName() {
            return USBMonitor.getDeviceKeyName((UsbDevice)this.mWeakDevice.get());
        }

        public String getDeviceKeyName(boolean useNewAPI) throws IllegalStateException {
            if (useNewAPI) {
                this.checkConnection();
            }
            return USBMonitor.getDeviceKeyName((UsbDevice)this.mWeakDevice.get(), this.mInfo.serial, useNewAPI);
        }

        public int getDeviceKey() throws IllegalStateException {
            this.checkConnection();
            return USBMonitor.getDeviceKey((UsbDevice)this.mWeakDevice.get());
        }

        public int getDeviceKey(boolean useNewAPI) throws IllegalStateException {
            if (useNewAPI) {
                this.checkConnection();
            }
            return USBMonitor.getDeviceKey((UsbDevice)this.mWeakDevice.get(), this.mInfo.serial, useNewAPI);
        }

        public String getDeviceKeyNameWithSerial() {
            return USBMonitor.getDeviceKeyName((UsbDevice)this.mWeakDevice.get(), this.mInfo.serial, false);
        }

        public int getDeviceKeyWithSerial() {
            return this.getDeviceKeyNameWithSerial().hashCode();
        }

        public synchronized UsbDeviceConnection getConnection() {
            return this.mConnection;
        }

        public synchronized int getFileDescriptor() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.getFileDescriptor();
        }

        public synchronized byte[] getRawDescriptors() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.getRawDescriptors();
        }

        public int getVenderId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getVendorId() : 0;
        }

        public int getProductId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getProductId() : 0;
        }

        public String getUsbVersion() {
            return this.mInfo.usb_version;
        }

        public String getManufacture() {
            return this.mInfo.manufacturer;
        }

        public String getProductName() {
            return this.mInfo.product;
        }

        public String getVersion() {
            return this.mInfo.version;
        }

        public String getSerial() {
            return this.mInfo.serial;
        }

        public int getBusNum() {
            return this.mBusNum;
        }

        public int getDevNum() {
            return this.mDevNum;
        }

        public synchronized UsbInterface getInterface(int interface_id) throws IllegalStateException {
            return this.getInterface(interface_id, 0);
        }

        public synchronized UsbInterface getInterface(int interface_id, int altsetting) throws IllegalStateException {
            UsbInterface intf;
            this.checkConnection();
            SparseArray intfs = (SparseArray)this.mInterfaces.get(interface_id);
            if (intfs == null) {
                intfs = new SparseArray();
                this.mInterfaces.put(interface_id, (Object)intfs);
            }
            if ((intf = (UsbInterface)intfs.get(altsetting)) == null) {
                UsbDevice device = (UsbDevice)this.mWeakDevice.get();
                int n = device.getInterfaceCount();
                for (int i = 0; i < n; ++i) {
                    UsbInterface temp = device.getInterface(i);
                    if (temp.getId() != interface_id || temp.getAlternateSetting() != altsetting) continue;
                    intf = temp;
                    break;
                }
                if (intf != null) {
                    intfs.append(altsetting, (Object)intf);
                }
            }
            return intf;
        }

        public synchronized void claimInterface(UsbInterface intf) {
            this.claimInterface(intf, true);
        }

        public synchronized void claimInterface(UsbInterface intf, boolean force) {
            this.checkConnection();
            this.mConnection.claimInterface(intf, force);
        }

        public synchronized void releaseInterface(UsbInterface intf) throws IllegalStateException {
            this.checkConnection();
            SparseArray intfs = (SparseArray)this.mInterfaces.get(intf.getId());
            if (intfs != null) {
                int index = intfs.indexOfValue((Object)intf);
                intfs.removeAt(index);
                if (intfs.size() == 0) {
                    this.mInterfaces.remove(intf.getId());
                }
            }
            this.mConnection.releaseInterface(intf);
        }

        public synchronized void close() {
            if (this.mConnection != null) {
                int n = this.mInterfaces.size();
                for (int i = 0; i < n; ++i) {
                    SparseArray intfs = (SparseArray)this.mInterfaces.valueAt(i);
                    if (intfs == null) continue;
                    int m = intfs.size();
                    for (int j = 0; j < m; ++j) {
                        UsbInterface intf = (UsbInterface)intfs.valueAt(j);
                        this.mConnection.releaseInterface(intf);
                    }
                    intfs.clear();
                }
                this.mInterfaces.clear();
                this.mConnection.close();
                this.mConnection = null;
                USBMonitor monitor = (USBMonitor)this.mWeakMonitor.get();
                if (monitor != null) {
                    if (monitor.mOnDeviceConnectListener != null) {
                        monitor.mOnDeviceConnectListener.onDisconnect((UsbDevice)this.mWeakDevice.get(), this);
                    }
                    monitor.mCtrlBlocks.remove(this.getDevice());
                }
            }
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof UsbControlBlock) {
                UsbDevice device = ((UsbControlBlock)o).getDevice();
                return device == null ? this.mWeakDevice.get() == null : device.equals(this.mWeakDevice.get());
            }
            if (o instanceof UsbDevice) {
                return o.equals(this.mWeakDevice.get());
            }
            return super.equals(o);
        }

        private synchronized void checkConnection() throws IllegalStateException {
            if (this.mConnection == null) {
                throw new IllegalStateException("already closed");
            }
        }
    }

    public static class UsbDeviceInfo {
        public String usb_version;
        public String manufacturer;
        public String product;
        public String version;
        public String serial;

        private void clear() {
            this.serial = null;
            this.version = null;
            this.product = null;
            this.manufacturer = null;
            this.usb_version = null;
        }

        public String toString() {
            return String.format("UsbDevice:usb_version=%s,manufacturer=%s,product=%s,version=%s,serial=%s", this.usb_version != null ? this.usb_version : "", this.manufacturer != null ? this.manufacturer : "", this.product != null ? this.product : "", this.version != null ? this.version : "", this.serial != null ? this.serial : "");
        }
    }

    public static interface OnDeviceConnectListener {
        public void onAttach(UsbDevice var1);

        public void onDetach(UsbDevice var1);

        public void onConnect(UsbDevice var1, UsbControlBlock var2, boolean var3);

        public void onDisconnect(UsbDevice var1, UsbControlBlock var2);

        public void onCancel(UsbDevice var1);
    }
}

