/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.media.Image;
import androidx.core.content.ContextCompat;
import com.jiangdg.ausbc.R;
import com.jiangdg.usb.DeviceFilter;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u00a8\u0006\u0017"}, d2={"Lcom/jiangdg/ausbc/utils/CameraUtils;", "", "()V", "hasAudioPermission", "", "ctx", "Landroid/content/Context;", "hasCameraPermission", "hasStoragePermission", "isCameraContainsMic", "device", "Landroid/hardware/usb/UsbDevice;", "isFilterDevice", "context", "usbDevice", "isUsbCamera", "transferYUV420ToNV21", "", "image", "Landroid/media/Image;", "width", "", "height", "libausbc_release"})
public final class CameraUtils {
    @NotNull
    public static final CameraUtils INSTANCE = new CameraUtils();

    private CameraUtils() {
    }

    @NotNull
    public final byte[] transferYUV420ToNV21(@NotNull Image image, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        byte[] nv21 = new byte[width * height * 3 / 2];
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer yBuffer = planes[0].getBuffer();
        int yLen = width * height;
        yBuffer.get(nv21, 0, yLen);
        ByteBuffer vBuffer = planes[2].getBuffer();
        int vPixelStride = planes[2].getPixelStride();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)vBuffer.remaining())), (int)vPixelStride);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = 0;
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            int i;
            do {
                int index = n4++;
                i = n;
                n += n3;
                int vIndex = yLen + 2 * index;
                if (vIndex >= nv21.length) break;
                nv21[vIndex] = vBuffer.get(i);
            } while (i != n2);
        }
        ByteBuffer uBuffer = planes[1].getBuffer();
        int uPixelStride = planes[1].getPixelStride();
        IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)uBuffer.remaining())), (int)uPixelStride);
        n3 = intProgression2.getFirst();
        n4 = intProgression2.getLast();
        int n5 = intProgression2.getStep();
        int n6 = 0;
        if (n5 > 0 && n3 <= n4 || n5 < 0 && n4 <= n3) {
            int i;
            do {
                int index = n6++;
                i = n3;
                n3 += n5;
                int uIndex = yLen + (2 * index + 1);
                if (uIndex >= nv21.length) break;
                nv21[yLen + (2 * index + 1)] = uBuffer.get(i);
            } while (i != n4);
        }
        return nv21;
    }

    public final boolean isUsbCamera(@Nullable UsbDevice device) {
        int n;
        Integer n2;
        UsbDevice usbDevice = device;
        Integer n3 = n2 = usbDevice == null ? null : Integer.valueOf(usbDevice.getDeviceClass());
        int n4 = 14;
        if (n3 != null && n3 == n4) {
            n = 1;
        } else {
            Integer n5 = n2;
            n4 = 239;
            if (n5 != null && n5 == n4) {
                boolean isVideo = false;
                int n6 = 0;
                int n7 = device.getInterfaceCount();
                if (n6 < n7) {
                    do {
                        int i;
                        int cls;
                        if ((cls = device.getInterface(i = n6++).getInterfaceClass()) != 14) continue;
                        isVideo = true;
                        break;
                    } while (n6 < n7);
                }
                n = n4;
            } else {
                n = 0;
            }
        }
        return n != 0;
    }

    public final boolean isCameraContainsMic(@Nullable UsbDevice device) {
        UsbDevice usbDevice = device;
        if (usbDevice == null) {
            return false;
        }
        boolean hasMic = false;
        int n = 0;
        int n2 = device.getInterfaceCount();
        if (n < n2) {
            do {
                int i;
                int cls;
                if ((cls = device.getInterface(i = n++).getInterfaceClass()) != 1) continue;
                hasMic = true;
                break;
            } while (n < n2);
        }
        return hasMic;
    }

    public final boolean isFilterDevice(@Nullable Context context, @Nullable UsbDevice usbDevice) {
        Object v0;
        boolean bl;
        Iterable iterable;
        block1: {
            iterable = DeviceFilter.getDeviceFilters((Context)context, (int)R.xml.default_device_filter);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getDeviceFilters(context, R.xml.default_device_filter)");
            iterable = iterable;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object e : iterable2) {
                DeviceFilter devFilter = (DeviceFilter)e;
                boolean bl3 = false;
                int n = devFilter.mProductId;
                UsbDevice usbDevice2 = usbDevice;
                if (!((usbDevice2 == null ? false : n == usbDevice2.getProductId()) && devFilter.mVendorId == usbDevice.getVendorId())) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        iterable = v0;
        bl = false;
        boolean bl4 = false;
        DeviceFilter dev = (DeviceFilter)iterable;
        boolean bl5 = false;
        return dev != null;
    }

    public final boolean hasAudioPermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.RECORD_AUDIO");
        return locPermission == 0;
    }

    public final boolean hasStoragePermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        return locPermission == 0;
    }

    public final boolean hasCameraPermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.CAMERA");
        return locPermission == 0;
    }
}

