/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode;

import android.media.MediaCodec;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.encode.muxer.Mp4Muxer;
import com.jiangdg.ausbc.utils.Logger;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 L2\u00020\u0001:\u0001LB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010/\u001a\u000200H\u0004J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0006H$J\b\u00104\u001a\u000205H$J\b\u00106\u001a\u000200H$J\b\u00107\u001a\u000200H$J\u0006\u00108\u001a\u00020\u0004J\b\u00109\u001a\u00020\u0004H\u0004J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020;H$J$\u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020;0>2\u0006\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020;H$J\u000e\u0010B\u001a\u0002002\u0006\u0010<\u001a\u00020,J\b\u0010C\u001a\u000200H\u0002J\u0010\u0010D\u001a\u0002002\b\u0010E\u001a\u0004\u0018\u00010\u0013J\u0016\u0010F\u001a\u0002002\u0006\u0010G\u001a\u00020)2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010H\u001a\u000200J\u0006\u0010I\u001a\u000200J\u000e\u0010J\u001a\u0002002\u0006\u0010K\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006M"}, d2={"Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "", "()V", "isVideo", "", "mBitRate", "", "getMBitRate", "()Ljava/lang/Integer;", "setMBitRate", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "mBufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "getMBufferInfo", "()Landroid/media/MediaCodec$BufferInfo;", "mBufferInfo$delegate", "Lkotlin/Lazy;", "mEncodeDataCb", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack;", "mEncodeHandler", "Landroid/os/Handler;", "mEncodeState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMEncodeState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mEncodeState$delegate", "mEncodeThread", "Landroid/os/HandlerThread;", "mMainHandler", "getMMainHandler", "()Landroid/os/Handler;", "setMMainHandler", "(Landroid/os/Handler;)V", "mMediaCodec", "Landroid/media/MediaCodec;", "getMMediaCodec", "()Landroid/media/MediaCodec;", "setMMediaCodec", "(Landroid/media/MediaCodec;)V", "mMp4Muxer", "Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer;", "mRawDataQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "getMRawDataQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "doEncodeData", "", "getPTSUs", "", "bufferSize", "getThreadName", "", "handleStartEncode", "handleStopEncode", "isEncoding", "isLowerLollipop", "processInputData", "", "data", "processOutputData", "Lkotlin/Pair;", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack$DataType;", "bufferInfo", "encodeData", "putRawData", "queueFrameIfNeed", "setEncodeDataCallBack", "callBack", "setMp4Muxer", "muxer", "startEncode", "stopEncode", "updateBitRate", "bitRate", "Companion", "libausbc_release"})
public abstract class AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HandlerThread mEncodeThread;
    @Nullable
    private Handler mEncodeHandler;
    @Nullable
    private MediaCodec mMediaCodec;
    @Nullable
    private Mp4Muxer mMp4Muxer;
    private boolean isVideo;
    @Nullable
    private IEncodeDataCallBack mEncodeDataCb;
    @NotNull
    private final ConcurrentLinkedQueue<RawData> mRawDataQueue = new ConcurrentLinkedQueue();
    @Nullable
    private Integer mBitRate;
    @NotNull
    private Handler mMainHandler = new Handler(Looper.getMainLooper());
    @NotNull
    private final Lazy mEncodeState$delegate = LazyKt.lazy((Function0)mEncodeState.2.INSTANCE);
    @NotNull
    private final Lazy mBufferInfo$delegate = LazyKt.lazy((Function0)mBufferInfo.2.INSTANCE);
    @NotNull
    private static final String TAG = "AbstractProcessor";
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    private static final long TIMES_OUT_US = 10000L;
    public static final int MAX_QUEUE_SIZE = 5;

    @Nullable
    protected final MediaCodec getMMediaCodec() {
        return this.mMediaCodec;
    }

    protected final void setMMediaCodec(@Nullable MediaCodec mediaCodec) {
        this.mMediaCodec = mediaCodec;
    }

    @NotNull
    protected final ConcurrentLinkedQueue<RawData> getMRawDataQueue() {
        return this.mRawDataQueue;
    }

    @Nullable
    protected final Integer getMBitRate() {
        return this.mBitRate;
    }

    protected final void setMBitRate(@Nullable Integer n) {
        this.mBitRate = n;
    }

    @NotNull
    protected final Handler getMMainHandler() {
        return this.mMainHandler;
    }

    protected final void setMMainHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"<set-?>");
        this.mMainHandler = handler;
    }

    @NotNull
    protected final AtomicBoolean getMEncodeState() {
        Lazy lazy = this.mEncodeState$delegate;
        boolean bl = false;
        return (AtomicBoolean)lazy.getValue();
    }

    private final MediaCodec.BufferInfo getMBufferInfo() {
        Lazy lazy = this.mBufferInfo$delegate;
        boolean bl = false;
        return (MediaCodec.BufferInfo)lazy.getValue();
    }

    public final void startEncode() {
        Message message;
        this.mEncodeThread = new HandlerThread(this.getThreadName());
        HandlerThread handlerThread = this.mEncodeThread;
        if (handlerThread != null) {
            handlerThread.start();
        }
        HandlerThread handlerThread2 = this.mEncodeThread;
        Intrinsics.checkNotNull((Object)handlerThread2);
        this.mEncodeHandler = new Handler(handlerThread2.getLooper(), arg_0 -> AbstractProcessor.startEncode$lambda-0(this, arg_0));
        handlerThread = this.mEncodeHandler;
        if (handlerThread != null && (message = handlerThread.obtainMessage(1)) != null) {
            message.sendToTarget();
        }
    }

    public final void stopEncode() {
        Message message;
        this.getMEncodeState().set(false);
        Handler handler = this.mEncodeHandler;
        if (handler != null && (message = handler.obtainMessage(2)) != null) {
            message.sendToTarget();
        }
        if ((handler = this.mEncodeThread) != null) {
            handler.quitSafely();
        }
        this.mEncodeThread = null;
        this.mEncodeHandler = null;
    }

    public final void updateBitRate(int bitRate) {
        Message message;
        this.mBitRate = bitRate;
        this.getMEncodeState().set(false);
        Handler handler = this.mEncodeHandler;
        if (handler != null && (message = handler.obtainMessage(2)) != null) {
            message.sendToTarget();
        }
        if ((handler = this.mEncodeHandler) != null && (message = handler.obtainMessage(1)) != null) {
            message.sendToTarget();
        }
    }

    public final void setEncodeDataCallBack(@Nullable IEncodeDataCallBack callBack) {
        this.mEncodeDataCb = callBack;
    }

    public final synchronized void setMp4Muxer(@NotNull Mp4Muxer muxer, boolean isVideo) {
        Intrinsics.checkNotNullParameter((Object)muxer, (String)"muxer");
        this.mMp4Muxer = muxer;
        this.isVideo = isVideo;
    }

    public final void putRawData(@NotNull RawData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!this.getMEncodeState().get()) {
            return;
        }
        if (this.mRawDataQueue.size() >= 5) {
            this.mRawDataQueue.poll();
        }
        this.mRawDataQueue.offer(data);
    }

    public final boolean isEncoding() {
        return this.getMEncodeState().get();
    }

    @NotNull
    protected abstract String getThreadName();

    protected abstract void handleStartEncode();

    protected abstract void handleStopEncode();

    protected abstract long getPTSUs(int var1);

    protected final boolean isLowerLollipop() {
        return Build.VERSION.SDK_INT < 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doEncodeData() {
        while (this.getMEncodeState().get()) {
            try {
                this.queueFrameIfNeed();
                int outputIndex = 0;
                do {
                    MediaCodec mediaCodec;
                    if ((mediaCodec = this.mMediaCodec) == null) continue;
                    MediaCodec mediaCodec2 = mediaCodec;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec codec = mediaCodec2;
                    boolean bl3 = false;
                    outputIndex = codec.dequeueOutputBuffer(this.getMBufferInfo(), 10000L);
                    int n = outputIndex;
                    if (n == -2) {
                        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"addTracker is video = ", (Object)this.isVideo));
                        Mp4Muxer mp4Muxer = this.mMp4Muxer;
                        if (mp4Muxer == null) continue;
                        MediaCodec mediaCodec3 = this.getMMediaCodec();
                        mp4Muxer.addTracker(mediaCodec3 == null ? null : mediaCodec3.getOutputFormat(), this.isVideo);
                        continue;
                    }
                    if (outputIndex < 0) continue;
                    try {
                        ByteBuffer outputBuffer;
                        ByteBuffer byteBuffer = outputBuffer = this.isLowerLollipop() ? codec.getOutputBuffers()[outputIndex] : codec.getOutputBuffer(outputIndex);
                        if (outputBuffer == null) continue;
                        outputBuffer.position(this.getMBufferInfo().offset);
                        outputBuffer.limit(this.getMBufferInfo().offset + this.getMBufferInfo().size);
                        byte[] encodeData = new byte[this.getMBufferInfo().size];
                        outputBuffer.get(encodeData);
                        Pair<IEncodeDataCallBack.DataType, byte[]> pair = this.mMp4Muxer;
                        if (pair != null) {
                            pair.pumpStream(outputBuffer, this.getMBufferInfo(), this.isVideo);
                        }
                        pair = this.processOutputData(this.getMBufferInfo(), encodeData);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Pair<IEncodeDataCallBack.DataType, byte[]> $this$doEncodeData_u24lambda_u2d2_u24lambda_u2d1 = pair;
                        boolean bl6 = false;
                        IEncodeDataCallBack iEncodeDataCallBack = this.mEncodeDataCb;
                        if (iEncodeDataCallBack == null) {
                            continue;
                        }
                        iEncodeDataCallBack.onEncodeData((byte[])$this$doEncodeData_u24lambda_u2d2_u24lambda_u2d1.getSecond(), ((byte[])$this$doEncodeData_u24lambda_u2d2_u24lambda_u2d1.getSecond()).length, (IEncodeDataCallBack.DataType)((Object)$this$doEncodeData_u24lambda_u2d2_u24lambda_u2d1.getFirst()), this.getMBufferInfo().presentationTimeUs / (long)1000);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        codec.releaseOutputBuffer(outputIndex, false);
                    }
                } while (outputIndex >= 0);
            }
            catch (Exception e) {
                Logger.INSTANCE.e(TAG, "doEncodeData failed, video = " + this.isVideo + "\uff0c err = " + e.getLocalizedMessage(), e);
            }
        }
    }

    private final void queueFrameIfNeed() {
        MediaCodec mediaCodec = this.mMediaCodec;
        if (mediaCodec != null) {
            int inputIndex;
            RawData rawData;
            byte[] data;
            RawData rawData2;
            MediaCodec mediaCodec2 = mediaCodec;
            boolean bl = false;
            boolean bl2 = false;
            MediaCodec codec = mediaCodec2;
            boolean bl3 = false;
            if (!this.getMRawDataQueue().isEmpty() && (rawData2 = this.getMRawDataQueue().poll()) != null && this.processInputData(data = (rawData = rawData2).getData()) != null && (inputIndex = codec.dequeueInputBuffer(10000L)) >= 0) {
                ByteBuffer inputBuffer = this.isLowerLollipop() ? codec.getInputBuffers()[inputIndex] : codec.getInputBuffer(inputIndex);
                ByteBuffer byteBuffer = inputBuffer;
                if (byteBuffer != null) {
                    byteBuffer.clear();
                }
                byteBuffer = inputBuffer;
                if (byteBuffer != null) {
                    byteBuffer.put(data);
                }
                codec.queueInputBuffer(inputIndex, 0, data.length, this.getPTSUs(data.length), 0);
            }
        }
    }

    @NotNull
    protected abstract Pair<IEncodeDataCallBack.DataType, byte[]> processOutputData(@NotNull MediaCodec.BufferInfo var1, @NotNull byte[] var2);

    @Nullable
    protected abstract byte[] processInputData(@NotNull byte[] var1);

    private static final boolean startEncode$lambda-0(AbstractProcessor this$0, Message msg) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = msg.what;
        switch (n) {
            case 1: {
                this$0.handleStartEncode();
                break;
            }
            case 2: {
                this$0.handleStopEncode();
            }
        }
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jiangdg/ausbc/encode/AbstractProcessor$Companion;", "", "()V", "MAX_QUEUE_SIZE", "", "MSG_START", "MSG_STOP", "TAG", "", "TIMES_OUT_US", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

