/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.camera;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.location.Location;
import android.provider.MediaStore;
import android.view.SurfaceHolder;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraInfo;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.CameraV1Info;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Deprecated(message="Deprecated since version 3.3.0")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\f\b\u0007\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\u001f\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\u0019\u001a\u00020\u00102\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u001bR\u00020\u00070\u000f2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\tH\u0014J\u001c\u0010\u001f\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010#\u001a\u00020\tH\u0002J\b\u0010$\u001a\u00020\tH\u0002J\b\u0010%\u001a\u00020\tH\u0014J\b\u0010&\u001a\u00020\tH\u0014J\u0012\u0010'\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010\u000bH\u0014J\u0018\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u0015H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jiangdg/ausbc/camera/Camera1Strategy;", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "Landroid/hardware/Camera$PreviewCallback;", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCamera", "Landroid/hardware/Camera;", "captureImageInternal", "", "savePath", "", "createCamera", "destroyCamera", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getPreviewDegree", "", "context", "isFrontCamera", "", "getSuitableSize", "sizeList", "Landroid/hardware/Camera$Size;", "maxWidth", "maxHeight", "loadCameraInfo", "onPreviewFrame", "data", "", "camera", "realStartPreview", "setParameters", "startPreviewInternal", "stopPreviewInternal", "switchCameraInternal", "cameraId", "updateResolutionInternal", "width", "height", "Companion", "libausbc_release"})
public final class Camera1Strategy
extends ICameraStrategy
implements Camera.PreviewCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Camera mCamera;
    @NotNull
    private static final String TAG = "CameraV1";

    public Camera1Strategy(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
    }

    @Override
    protected void loadCameraInfo() {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int n = 0;
        int n2 = Camera.getNumberOfCameras();
        if (n < n2) {
            do {
                int n3;
                int cameraId = n++;
                Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
                int n4 = cameraInfo.facing;
                switch (n4) {
                    case 1: {
                        n3 = 0;
                        break;
                    }
                    case 0: {
                        n3 = 1;
                        break;
                    }
                    default: {
                        n3 = 2;
                    }
                }
                n4 = n3;
                boolean bl = false;
                boolean bl2 = false;
                int type = n4;
                boolean bl3 = false;
                Object object = new CameraV1Info(String.valueOf(cameraId));
                boolean bl4 = false;
                boolean bl5 = false;
                CameraV1Info $this$loadCameraInfo_u24lambda_u2d1_u24lambda_u2d0 = object;
                boolean bl6 = false;
                $this$loadCameraInfo_u24lambda_u2d1_u24lambda_u2d0.setCameraType(type);
                $this$loadCameraInfo_u24lambda_u2d1_u24lambda_u2d0.setCameraVid(cameraId + 1);
                $this$loadCameraInfo_u24lambda_u2d1_u24lambda_u2d0.setCameraPid(cameraId + 1);
                CameraV1Info info = object;
                object = this.getMCameraInfoMap();
                Integer n5 = type;
                bl5 = false;
                object.put(n5, info);
            } while (n < n2);
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"loadCameraInfo = ", this.getMCameraInfoMap()));
        }
    }

    @Override
    protected void startPreviewInternal() {
        this.createCamera();
        this.setParameters();
        this.realStartPreview();
    }

    @Override
    protected void stopPreviewInternal() {
        this.destroyCamera();
    }

    @Override
    protected void captureImageInternal(@Nullable String savePath) {
        Camera.PictureCallback jpegDataCb = (arg_0, arg_1) -> Camera1Strategy.captureImageInternal$lambda-5(this, savePath, arg_0, arg_1);
        if (!this.hasCameraPermission() || !this.hasStoragePermission()) {
            this.getMMainHandler().post(() -> Camera1Strategy.captureImageInternal$lambda-6(this));
            Logger.INSTANCE.i(TAG, "takePictureInternal failed, has no storage/camera permission.");
            return;
        }
        if (this.getMIsCapturing().get()) {
            return;
        }
        this.getMIsCapturing().set(true);
        Camera camera = this.mCamera;
        if (camera != null) {
            camera.takePicture(null, null, null, jpegDataCb);
        }
    }

    @Override
    protected void switchCameraInternal(@Nullable String cameraId) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest request = cameraRequest2;
            boolean bl3 = false;
            request.setFrontCamera(!request.isFrontCamera());
            this.stopPreviewInternal();
            this.startPreviewInternal();
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "switchCameraInternal");
            }
        }
    }

    @Override
    protected void updateResolutionInternal(int width, int height) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest request = cameraRequest2;
            boolean bl3 = false;
            request.setPreviewWidth(width);
            request.setPreviewHeight(height);
            this.stopPreviewInternal();
            this.startPreviewInternal();
        }
    }

    @Override
    @Nullable
    public List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            List previewSizeList;
            List list;
            List list2;
            CameraInfo cameraInfo;
            Object object;
            List list3;
            block8: {
                CameraRequest cameraRequest2 = cameraRequest;
                boolean bl = false;
                boolean bl2 = false;
                CameraRequest request = cameraRequest2;
                boolean bl3 = false;
                boolean bl4 = false;
                list3 = new ArrayList();
                Iterable<CameraInfo> iterable = this.getMCameraInfoMap().values();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"mCameraInfoMap.values");
                iterable = iterable;
                boolean bl5 = false;
                object = iterable;
                boolean bl6 = false;
                Iterator<CameraInfo> iterator = object.iterator();
                while (iterator.hasNext()) {
                    CameraInfo cameraInfo2 = iterator.next();
                    CameraInfo it = cameraInfo2;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)request.getCameraId(), (Object)it.getCameraId())) continue;
                    cameraInfo = cameraInfo2;
                    break block8;
                }
                cameraInfo = null;
            }
            CameraInfo cameraInfo3 = cameraInfo;
            object = cameraInfo3;
            List list4 = list2 = object == null ? null : ((CameraInfo)object).getCameraPreviewSizes();
            if (list2 == null) {
                boolean bl = false;
                list = new ArrayList();
            } else {
                list = previewSizeList = list2;
            }
            if (previewSizeList.isEmpty()) {
                List list5;
                Camera.Parameters parameters;
                list2 = this.mCamera;
                if (list2 != null && (parameters = list2.getParameters()) != null && (list5 = parameters.getSupportedPreviewSizes()) != null) {
                    Iterable $this$forEach$iv = list5;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Camera.Size size = (Camera.Size)element$iv;
                        boolean bl = false;
                        list3.add(new PreviewSize(size.width, size.height));
                    }
                }
                previewSizeList.addAll(list3);
            }
            Iterable $this$forEach$iv = previewSizeList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreviewSize size = (PreviewSize)element$iv;
                boolean bl = false;
                int width = size.getWidth();
                int height = size.getHeight();
                double ratio = (double)width / (double)height;
                if (aspectRatio != null && !Intrinsics.areEqual((double)ratio, (Double)aspectRatio)) continue;
                list3.add(size);
            }
            Logger.INSTANCE.i(TAG, "getAllPreviewSizes aspect ratio = " + aspectRatio + ", list= " + list3);
            return list3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void createCamera() {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            Camera camera;
            Camera1Strategy camera1Strategy;
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest request = cameraRequest2;
            boolean bl3 = false;
            if (!this.hasCameraPermission()) {
                Logger.INSTANCE.i(TAG, "openCamera failed, has no camera permission.");
                this.postCameraStatus(new CameraStatus(-1, "no permission"));
                return;
            }
            this.stopPreviewInternal();
            Camera1Strategy camera1Strategy2 = this;
            try {
                Camera camera2;
                camera1Strategy = camera1Strategy2;
                if (request.isFrontCamera()) {
                    String cameraId;
                    CameraInfo cameraInfo = this.getMCameraInfoMap().get(0);
                    Intrinsics.checkNotNull((Object)cameraInfo);
                    String string = cameraId = cameraInfo.getCameraId();
                    boolean bl4 = false;
                    camera2 = Camera.open((int)Integer.parseInt(string));
                } else {
                    camera2 = Camera.open();
                }
                camera = camera2;
            }
            catch (Exception exception) {
                void e;
                camera1Strategy = camera1Strategy2;
                Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"open camera failed, err = ", (Object)e.getLocalizedMessage()), (Throwable)e);
                this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
                camera = null;
            }
            Camera camera3 = camera;
            if (camera3 == null) {
                return;
            }
            camera1Strategy.mCamera = camera3;
            ICameraStrategy.getAllPreviewSizes$default(this, null, 1, null);
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "createCamera id = " + request.getCameraId() + ", front camera = " + request.isFrontCamera());
            }
        }
    }

    private final void setParameters() {
        try {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest != null) {
                Camera.Parameters parameters;
                CameraRequest cameraRequest2 = cameraRequest;
                boolean bl = false;
                boolean bl2 = false;
                CameraRequest request = cameraRequest2;
                boolean bl3 = false;
                Camera camera = this.mCamera;
                if (camera == null) {
                    parameters = null;
                } else {
                    Camera.Parameters parameters2 = camera.getParameters();
                    if (parameters2 == null) {
                        parameters = null;
                    } else {
                        Camera.Parameters parameters3 = parameters2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Camera.Parameters $this$setParameters_u24lambda_u2d16_u24lambda_u2d14 = parameters3;
                        boolean bl6 = false;
                        List list = $this$setParameters_u24lambda_u2d16_u24lambda_u2d14.getSupportedPreviewSizes();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"supportedPreviewSizes");
                        PreviewSize suitablePreviewSize = this.getSuitableSize(list, request.getPreviewWidth(), request.getPreviewHeight());
                        int width = suitablePreviewSize.getWidth();
                        int height = suitablePreviewSize.getHeight();
                        $this$setParameters_u24lambda_u2d16_u24lambda_u2d14.setPreviewFormat(17);
                        $this$setParameters_u24lambda_u2d16_u24lambda_u2d14.setPictureFormat(256);
                        if ($this$setParameters_u24lambda_u2d16_u24lambda_u2d14.getSupportedFocusModes().contains("continuous-picture")) {
                            $this$setParameters_u24lambda_u2d16_u24lambda_u2d14.setFocusMode("continuous-picture");
                        }
                        $this$setParameters_u24lambda_u2d16_u24lambda_u2d14.setPreviewSize(width, height);
                        $this$setParameters_u24lambda_u2d16_u24lambda_u2d14.set("orientation", "portrait");
                        $this$setParameters_u24lambda_u2d16_u24lambda_u2d14.set("rotation", 90);
                        request.setPreviewWidth(width);
                        request.setPreviewHeight(height);
                        parameters = parameters3;
                    }
                }
                camera = parameters;
                boolean bl7 = false;
                boolean bl8 = false;
                Camera it = camera;
                boolean bl9 = false;
                Camera camera2 = this.mCamera;
                if (camera2 != null) {
                    camera2.setParameters((Camera.Parameters)it);
                }
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"open camera failed, err = ", (Object)e.getLocalizedMessage()), e);
            this.getMIsPreviewing().set(false);
            Camera camera = this.mCamera;
            if (camera != null) {
                camera.setPreviewCallbackWithBuffer(null);
            }
            camera = this.mCamera;
            if (camera != null) {
                camera.addCallbackBuffer(null);
            }
            camera = this.mCamera;
            if (camera != null) {
                camera.release();
            }
            this.mCamera = null;
            this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
            return;
        }
    }

    private final void realStartPreview() {
        SurfaceTexture st = this.getSurfaceTexture();
        SurfaceHolder holder = this.getSurfaceHolder();
        if (st == null && holder == null) {
            this.postCameraStatus(new CameraStatus(-1, "surface is null"));
            Logger.INSTANCE.e(TAG, "realStartPreview failed, SurfaceTexture or SurfaceHolder cannot be null.");
            return;
        }
        try {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest != null) {
                CameraRequest cameraRequest2 = cameraRequest;
                boolean bl = false;
                boolean bl2 = false;
                CameraRequest request = cameraRequest2;
                boolean bl3 = false;
                int width = request.getPreviewWidth();
                int height = request.getPreviewHeight();
                Camera camera = this.mCamera;
                if (camera != null) {
                    boolean bl4;
                    CameraRequest cameraRequest3;
                    camera.setDisplayOrientation(this.getPreviewDegree(this.getContext(), (cameraRequest3 = this.getRequest()) == null ? false : (bl4 = cameraRequest3.isFrontCamera())));
                }
                camera = this.mCamera;
                if (camera != null) {
                    camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
                }
                camera = this.mCamera;
                if (camera != null) {
                    camera.addCallbackBuffer(new byte[width * height * 3 / 2]);
                }
                if (st != null) {
                    camera = this.mCamera;
                    if (camera != null) {
                        camera.setPreviewTexture(st);
                    }
                } else {
                    camera = this.mCamera;
                    if (camera != null) {
                        camera.setPreviewDisplay(holder);
                    }
                }
                camera = this.mCamera;
                if (camera != null) {
                    camera.startPreview();
                }
                this.getMIsPreviewing().set(true);
                this.postCameraStatus(new CameraStatus(1, new Pair((Object)width, (Object)height).toString()));
                if (Utils.INSTANCE.getDebugCamera()) {
                    Logger.INSTANCE.i(TAG, "realStartPreview width =" + width + ", height=" + height);
                }
            }
        }
        catch (Exception e) {
            this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
        }
    }

    private final void destroyCamera() {
        if (!this.getMIsPreviewing().get()) {
            return;
        }
        this.getMIsPreviewing().set(false);
        Camera camera = this.mCamera;
        if (camera != null) {
            camera.setPreviewCallbackWithBuffer(null);
        }
        camera = this.mCamera;
        if (camera != null) {
            camera.addCallbackBuffer(null);
        }
        camera = this.mCamera;
        if (camera != null) {
            camera.stopPreview();
        }
        camera = this.mCamera;
        if (camera != null) {
            camera.release();
        }
        this.mCamera = null;
        this.postCameraStatus(new CameraStatus(2, null, 2, null));
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "destroyCamera");
        }
    }

    private final PreviewSize getSuitableSize(List<Camera.Size> sizeList, int maxWidth, int maxHeight) {
        float aspectRatio = (float)maxWidth / (float)maxHeight;
        Iterable $this$forEach$iv = sizeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Camera.Size size = (Camera.Size)element$iv;
            boolean bl = false;
            int w = size.width;
            int h = size.height;
            float ratio = (float)w / (float)h;
            if (!(ratio == aspectRatio) || w > maxWidth || h > maxHeight) continue;
            return new PreviewSize(w, h);
        }
        return sizeList.isEmpty() ? new PreviewSize(maxWidth, maxHeight) : new PreviewSize(sizeList.get((int)0).width, sizeList.get((int)0).height);
    }

    private final int getPreviewDegree(Context context, boolean isFrontCamera) {
        int n;
        int n2;
        if (!(context instanceof Activity)) {
            return 90;
        }
        int n3 = ((Activity)context).getWindowManager().getDefaultDisplay().getRotation();
        switch (n3) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        int degree = n2;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        if (isFrontCamera) {
            Camera.getCameraInfo((int)1, (Camera.CameraInfo)cameraInfo);
            n = (360 - (cameraInfo.orientation - degree) % 360) % 360;
        } else {
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
            n = (cameraInfo.orientation - degree + 360) % 360;
        }
        return n;
    }

    public void onPreviewFrame(@Nullable byte[] data, @Nullable Camera camera) {
        Object object = data;
        if (object == null) {
            return;
        }
        object = this.getRequest();
        if (object == null) {
            return;
        }
        try {
            CameraRequest cameraRequest = this.getRequest();
            Intrinsics.checkNotNull((Object)cameraRequest);
            int n = cameraRequest.getPreviewWidth();
            CameraRequest cameraRequest2 = this.getRequest();
            Intrinsics.checkNotNull((Object)cameraRequest2);
            int frameSize = n * cameraRequest2.getPreviewHeight() * 3 / 2;
            if (data.length != frameSize) {
                return;
            }
            Iterable $this$forEach$iv = this.getMPreviewDataCbList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IPreviewDataCallBack cb = (IPreviewDataCallBack)element$iv;
                boolean bl = false;
                CameraRequest cameraRequest3 = this.getRequest();
                Intrinsics.checkNotNull((Object)cameraRequest3);
                int n2 = cameraRequest3.getPreviewWidth();
                CameraRequest cameraRequest4 = this.getRequest();
                Intrinsics.checkNotNull((Object)cameraRequest4);
                cb.onPreviewData(data, n2, cameraRequest4.getPreviewHeight(), IPreviewDataCallBack.DataFormat.NV21);
            }
            Camera camera2 = this.mCamera;
            if (camera2 != null) {
                camera2.addCallbackBuffer(data);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private static final void captureImageInternal$lambda-5$lambda-4$lambda-2(Camera1Strategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onBegin();
        }
    }

    private static final void captureImageInternal$lambda-5$lambda-4$lambda-3(Camera1Strategy this$0, String $path) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onComplete($path);
        }
    }

    private static final void captureImageInternal$lambda-5$lambda-4(Camera1Strategy this$0, String $savePath, byte[] $data) {
        ContentResolver contentResolver;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getMMainHandler().post(() -> Camera1Strategy.captureImageInternal$lambda-5$lambda-4$lambda-2(this$0));
        String date = this$0.getMDateFormat().format(System.currentTimeMillis());
        String string = $savePath;
        String title = string == null ? Intrinsics.stringPlus((String)"IMG_JJCamera_", (Object)date) : string;
        String string2 = $savePath;
        String displayName = string2 == null ? Intrinsics.stringPlus((String)title, (Object)".jpg") : string2;
        String string3 = $savePath;
        String path = string3 == null ? this$0.getMCameraDir() + '/' + displayName : string3;
        CameraRequest cameraRequest = this$0.getRequest();
        Integer width = cameraRequest == null ? null : Integer.valueOf(cameraRequest.getPreviewWidth());
        CameraRequest cameraRequest2 = this$0.getRequest();
        Integer height = cameraRequest2 == null ? null : Integer.valueOf(cameraRequest2.getPreviewHeight());
        int orientation = 0;
        Location location = Utils.INSTANCE.getGpsLocation(this$0.getContext());
        File file = new File(path);
        Intrinsics.checkNotNullExpressionValue((Object)$data, (String)"data");
        FilesKt.writeBytes((File)file, (byte[])$data);
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        values.put("_data", path);
        values.put("datetaken", date);
        values.put("width", width);
        values.put("height", height);
        values.put("orientation", Integer.valueOf(orientation));
        Location location2 = location;
        values.put("longitude", location2 == null ? null : Double.valueOf(location2.getLongitude()));
        location2 = location;
        values.put("latitude", location2 == null ? null : Double.valueOf(location2.getLatitude()));
        location2 = this$0.getContext();
        if (location2 != null && (contentResolver = location2.getContentResolver()) != null) {
            contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        this$0.getMMainHandler().post(() -> Camera1Strategy.captureImageInternal$lambda-5$lambda-4$lambda-3(this$0, path));
        this$0.stopPreviewInternal();
        this$0.startPreviewInternal();
        this$0.realStartPreview();
        this$0.getMIsCapturing().set(false);
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"takePictureInternal save path = ", (Object)path));
        }
    }

    private static final void captureImageInternal$lambda-5(Camera1Strategy this$0, String $savePath, byte[] data, Camera camera) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getMSaveImageExecutor().submit(() -> Camera1Strategy.captureImageInternal$lambda-5$lambda-4(this$0, $savePath, data));
    }

    private static final void captureImageInternal$lambda-6(Camera1Strategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError("Have no storage or camera permission.");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jiangdg/ausbc/camera/Camera1Strategy$Companion;", "", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

