/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J$\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jiangdg/ausbc/utils/GLBitmapUtils;", "", "()V", "readPixelToBitmap", "Landroid/graphics/Bitmap;", "width", "", "height", "readPixelToBitmapWithBuffer", "byteBuffer", "Ljava/nio/ByteBuffer;", "readPixelToByteBuffer", "", "frameBufferId", "transFrameBufferToBitmap", "libausbc_release"})
public final class GLBitmapUtils {
    @NotNull
    public static final GLBitmapUtils INSTANCE = new GLBitmapUtils();

    private GLBitmapUtils() {
    }

    @NotNull
    public final Bitmap transFrameBufferToBitmap(int frameBufferId, int width, int height) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"byteBuffer");
        return this.transFrameBufferToBitmap(frameBufferId, width, height, byteBuffer);
    }

    private final Bitmap transFrameBufferToBitmap(int frameBufferId, int width, int height, ByteBuffer byteBuffer) {
        Bitmap bitmap;
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        Bitmap bitmap2 = bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2 != null) {
            bitmap2.copyPixelsFromBuffer((Buffer)byteBuffer);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    public final void readPixelToByteBuffer(int frameBufferId, int width, int height, @Nullable ByteBuffer byteBuffer) {
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    @Nullable
    public final Bitmap readPixelToBitmap(int width, int height) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return this.readPixelToBitmapWithBuffer(width, height, byteBuffer);
    }

    private final Bitmap readPixelToBitmapWithBuffer(int width, int height, ByteBuffer byteBuffer) {
        Bitmap bitmap;
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        Bitmap bitmap2 = bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2 != null) {
            bitmap2.copyPixelsFromBuffer((Buffer)byteBuffer);
        }
        return bitmap;
    }
}

