/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jiangdg.ausbc.R;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 F2\u00020\u0001:\u0002FGB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010-\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0002J\u0006\u00100\u001a\u00020\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tH\u0002J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0002J\u0010\u00105\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0018\u00106\u001a\u00020%2\u0006\u00102\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0014J(\u00107\u001a\u00020%2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\tH\u0014J\u0010\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>H\u0017J\u000e\u0010?\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\tJ\u000e\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020\tJ\u0010\u0010B\u001a\u00020%2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010C\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\tJ\u000e\u0010D\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010E\u001a\u00020%2\u0006\u0010#\u001a\u00020\tR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/jiangdg/ausbc/widget/CircleProgressView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "circleX", "", "circleY", "insideCircleBgColor", "insideCircleTouchedBgColor", "insideRectangleBgColor", "isDisabled", "", "isOddNumber", "isRecordVideo", "isShowTextTip", "isTouched", "listener", "Lcom/jiangdg/ausbc/widget/CircleProgressView$OnViewClickListener;", "mHeight", "mPaint", "Landroid/graphics/Paint;", "mSweepAngle", "mWidth", "outsideCircleBgColor", "progress", "progressArcBgColor", "radius", "state", "tipTextColor", "tipTextSize", "", "totalSize", "drawInternalCircle", "", "canvas", "Landroid/graphics/Canvas;", "colorType", "drawInternelRectangle", "drawOutSideCircle", "drawProgressArc", "drawRecordVideoCircle", "drawTextTip", "tipText", "", "getConnectState", "measureHeight", "widthMeasureSpec", "measureWidth", "heightMeasureSpec", "onDraw", "onMeasure", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "setConnectState", "setMode", "model", "setOnViewClickListener", "setProgressVaule", "setShowTextTipFlag", "setTotalSize", "Companion", "OnViewClickListener", "libausbc_release"})
public final class CircleProgressView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isRecordVideo;
    @Nullable
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int circleX;
    private int circleY;
    private int radius;
    private int state;
    private int mSweepAngle;
    private boolean isOddNumber;
    private int outsideCircleBgColor;
    private int progressArcBgColor;
    private int insideCircleBgColor;
    private int insideCircleTouchedBgColor;
    private int insideRectangleBgColor;
    private float tipTextSize;
    private int tipTextColor;
    private int progress;
    private int totalSize;
    private boolean isShowTextTip;
    private boolean isTouched;
    @Nullable
    private OnViewClickListener listener;
    private boolean isDisabled;
    private static final int STATE_DOING = 0;
    private static final int STATE_DONE = 1;
    private static final int STATE_UNDONE = 2;
    private static final int NONE = -1;
    private static final int MODEL_PICTURE = 0;
    private static final int MODEL_VIDEO = 1;

    public CircleProgressView(@Nullable Context context) {
        super(context);
        this.mSweepAngle = 1;
        this.isOddNumber = true;
    }

    public final void setOnViewClickListener(@Nullable OnViewClickListener listener2) {
        this.listener = listener2;
    }

    public CircleProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mSweepAngle = 1;
        this.isOddNumber = true;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView)");
        TypedArray ta = typedArray;
        this.outsideCircleBgColor = ta.getColor(R.styleable.CircleProgressView_outsideCircleBgColor, this.getResources().getColor(R.color.colorWhite));
        this.progressArcBgColor = ta.getColor(R.styleable.CircleProgressView_progressArcBgColor, this.getResources().getColor(R.color.colorGray));
        this.insideCircleBgColor = ta.getColor(R.styleable.CircleProgressView_insideCircleBgColor, this.getResources().getColor(R.color.colorRed));
        this.insideCircleTouchedBgColor = ta.getColor(R.styleable.CircleProgressView_insideCircleTouchedBgColor, this.getResources().getColor(R.color.colorDeepRed));
        this.insideRectangleBgColor = ta.getColor(R.styleable.CircleProgressView_insideRectangleBgColor, this.getResources().getColor(R.color.colorRed));
        this.tipTextColor = ta.getColor(R.styleable.CircleProgressView_tipTextColor, this.getResources().getColor(R.color.colorWhite));
        this.tipTextSize = ta.getDimension(R.styleable.CircleProgressView_tipTextSize, 34.0f);
        ta.recycle();
        this.mPaint = new Paint();
    }

    public final void setConnectState(int state) {
        this.state = state;
        this.invalidate();
    }

    public final int getConnectState() {
        return this.state;
    }

    public final void setProgressVaule(int progress) {
        this.progress = progress;
        this.invalidate();
    }

    public final void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public final void setShowTextTipFlag(boolean isShowTextTip) {
        this.isShowTextTip = isShowTextTip;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.listener == null || this.isDisabled()) {
            return super.onTouchEvent(event);
        }
        int n = event.getAction();
        switch (n) {
            case 0: {
                this.isTouched = true;
                break;
            }
            case 1: {
                this.isTouched = false;
                OnViewClickListener onViewClickListener = this.listener;
                Intrinsics.checkNotNull((Object)onViewClickListener);
                onViewClickListener.onViewClick();
            }
        }
        this.invalidate();
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private final int measureHeight(int widthMeasureSpec) {
        int width = 0;
        int specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (specMode == 0x40000000) {
            width = specSize;
        } else {
            width = 200;
            if (specMode == Integer.MIN_VALUE) {
                width = RangesKt.coerceAtMost((int)width, (int)specSize);
            }
        }
        return width;
    }

    private final int measureWidth(int heightMeasureSpec) {
        int height = 0;
        int specMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (specMode == 0x40000000) {
            height = specSize;
        } else {
            height = 200;
            if (specMode == Integer.MIN_VALUE) {
                height = RangesKt.coerceAtMost((int)height, (int)specSize);
            }
        }
        return height;
    }

    private final boolean isDisabled() {
        return this.isDisabled;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.circleX = this.mWidth / 2;
        this.circleY = this.mWidth / 2;
        this.radius = this.mWidth / 2;
        this.state = 2;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawOutSideCircle(canvas);
        if (1 == this.state) {
            this.drawInternelRectangle(canvas);
        } else {
            if (this.isTouched) {
                this.drawInternalCircle(canvas, this.insideCircleTouchedBgColor);
            } else {
                this.drawInternalCircle(canvas, this.insideCircleBgColor);
            }
            if (this.state == 0) {
                this.drawProgressArc(canvas);
            }
        }
        if (this.isRecordVideo) {
            this.drawRecordVideoCircle(canvas);
        }
    }

    private final void drawRecordVideoCircle(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.0f);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setStyle(Paint.Style.FILL);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setColor(this.getResources().getColor(R.color.colorRed));
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setAntiAlias(true);
        }
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = (float)((double)this.radius - (double)this.radius * 0.75);
        Paint paint2 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawCircle(f, f2, f3, paint2);
    }

    private final void drawOutSideCircle(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.5f);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setColor(this.outsideCircleBgColor);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setStyle(Paint.Style.STROKE);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setAntiAlias(true);
        }
        canvas.drawColor(0);
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = (float)this.radius - 5.0f;
        Paint paint2 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawCircle(f, f2, f3, paint2);
    }

    private final void drawInternalCircle(Canvas canvas, int colorType) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.0f);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setStyle(Paint.Style.FILL);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setColor(colorType);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setAntiAlias(true);
        }
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = (float)((double)this.radius - (double)this.radius * 0.35);
        Paint paint2 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawCircle(f, f2, f3, paint2);
    }

    private final void drawInternelRectangle(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.0f);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setColor(this.insideRectangleBgColor);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setAntiAlias(true);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setStyle(Paint.Style.FILL);
        }
        float f = (float)((double)this.mWidth * 0.3);
        float f2 = (float)((double)this.mWidth * 0.3);
        float f3 = (float)((double)this.mWidth - (double)this.mWidth * 0.3);
        float f4 = (float)((double)this.mWidth - (double)this.mWidth * 0.3);
        Paint paint2 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawRect(f, f2, f3, f4, paint2);
    }

    private final void drawProgressArc(Canvas canvas) {
        Object object = this.mPaint;
        if (object != null) {
            object.setStrokeWidth((float)((int)((double)this.radius * 0.15)));
        }
        object = this.mPaint;
        if (object != null) {
            object.setStyle(Paint.Style.STROKE);
        }
        object = this.mPaint;
        if (object != null) {
            object.setAntiAlias(true);
        }
        object = this.mPaint;
        if (object != null) {
            object.setColor(this.progressArcBgColor);
        }
        if (this.progress >= 0) {
            if (this.totalSize == 0) {
                return;
            }
            RectF rectF = new RectF((float)((double)this.radius * 0.08), (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08));
            object = new DecimalFormat("0.00").format(Float.valueOf((float)this.progress / (float)this.totalSize));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DecimalFormat(\"0.00\")\n                    .format(progress.toFloat() / totalSize)");
            boolean bl = false;
            float f = (int)(Float.parseFloat((String)object) * (float)360);
            Paint paint = this.mPaint;
            Intrinsics.checkNotNull((Object)paint);
            canvas.drawArc(rectF, 180.0f, f, false, paint);
            if (this.isShowTextTip) {
                StringBuilder stringBuilder = new StringBuilder();
                object = new DecimalFormat("0.00").format(Float.valueOf((float)this.progress / (float)this.totalSize));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DecimalFormat(\"0.00\")\n                        .format(progress.toFloat() / totalSize)");
                bl = false;
                this.drawTextTip(canvas, stringBuilder.append(Float.parseFloat((String)object) * (float)100).append(" %").toString());
            }
        } else if (this.progress == -1) {
            if (this.isOddNumber) {
                RectF rectF = new RectF((float)((double)this.radius * 0.08), (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08));
                float f = this.mSweepAngle;
                Paint paint = this.mPaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawArc(rectF, 180.0f, f, false, paint);
                object = this;
                int n = object.mSweepAngle;
                object.mSweepAngle = n + 1;
                if (this.mSweepAngle >= 360) {
                    this.isOddNumber = false;
                }
            } else {
                RectF rectF = new RectF((float)((double)this.radius * 0.08), (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08));
                float f = -this.mSweepAngle;
                Paint paint = this.mPaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawArc(rectF, 180.0f, f, false, paint);
                object = this;
                int n = object.mSweepAngle;
                object.mSweepAngle = n + -1;
                if (this.mSweepAngle == 0) {
                    this.isOddNumber = true;
                }
            }
            this.postInvalidateDelayed(5L);
        }
    }

    private final void drawTextTip(Canvas canvas, String tipText) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.0f);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setStyle(Paint.Style.FILL);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setAntiAlias(true);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setTextSize(this.tipTextSize);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setColor(this.tipTextColor);
        }
        paint = this.mPaint;
        if (paint != null) {
            paint.setTextAlign(Paint.Align.CENTER);
        }
        int xCenter = this.getMeasuredHeight() / 2;
        float f = this.getMeasuredHeight();
        Paint paint2 = this.mPaint;
        Paint.FontMetrics fontMetrics = paint2 == null ? null : paint2.getFontMetrics();
        Intrinsics.checkNotNull((Object)fontMetrics);
        float f2 = f - fontMetrics.bottom;
        paint2 = this.mPaint;
        Paint.FontMetrics fontMetrics2 = paint2 == null ? null : paint2.getFontMetrics();
        Intrinsics.checkNotNull((Object)fontMetrics2);
        float f3 = (f2 + fontMetrics2.top) / (float)2;
        paint2 = this.mPaint;
        Paint.FontMetrics fontMetrics3 = paint2 == null ? null : paint2.getFontMetrics();
        Intrinsics.checkNotNull((Object)fontMetrics3);
        float yBaseLine = f3 - fontMetrics3.top;
        float f4 = xCenter;
        Paint paint3 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint3);
        canvas.drawText(tipText, f4, yBaseLine, paint3);
    }

    public final void setMode(int model) {
        this.isRecordVideo = model == 1;
        this.invalidate();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/jiangdg/ausbc/widget/CircleProgressView$OnViewClickListener;", "", "onViewClick", "", "libausbc_release"})
    public static interface OnViewClickListener {
        public void onViewClick();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jiangdg/ausbc/widget/CircleProgressView$Companion;", "", "()V", "MODEL_PICTURE", "", "MODEL_VIDEO", "NONE", "STATE_DOING", "STATE_DONE", "STATE_UNDONE", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

