/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.widget.IAspectRatio;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0014J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jiangdg/ausbc/widget/AspectRatioTextureView;", "Landroid/view/TextureView;", "Lcom/jiangdg/ausbc/widget/IAspectRatio;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mAspectRatio", "", "getSurface", "Landroid/view/Surface;", "getSurfaceHeight", "getSurfaceWidth", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "postUITask", "task", "Lkotlin/Function0;", "setAspectRatio", "aspectRatio", "width", "height", "Companion", "libausbc_release"})
public final class AspectRatioTextureView
extends TextureView
implements IAspectRatio {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double mAspectRatio;
    @NotNull
    private static final String TAG = "AspectRatioTextureView";

    public AspectRatioTextureView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public AspectRatioTextureView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0);
    }

    public AspectRatioTextureView(@NotNull Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, defStyleAttr);
        this.mAspectRatio = -1.0;
    }

    @Override
    public void setAspectRatio(int width, int height) {
        int orientation = this.getContext().getResources().getConfiguration().orientation;
        if (orientation == 1) {
            this.setAspectRatio((double)height / (double)width);
            return;
        }
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public int getSurfaceWidth() {
        return this.getWidth();
    }

    @Override
    public int getSurfaceHeight() {
        return this.getHeight();
    }

    @Override
    @NotNull
    public Surface getSurface() {
        return new Surface(this.getSurfaceTexture());
    }

    @Override
    public void postUITask(@NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        this.post(() -> AspectRatioTextureView.postUITask$lambda-0(task));
    }

    private final void setAspectRatio(double aspectRatio) {
        if (aspectRatio < 0.0 || this.mAspectRatio == aspectRatio) {
            return;
        }
        this.mAspectRatio = aspectRatio;
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"AspectRatio = ", (Object)this.mAspectRatio));
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int horizontalPadding = this.getPaddingLeft() - this.getPaddingRight();
        int verticalPadding = this.getPaddingTop() - this.getPaddingBottom();
        double viewAspectRatio = (double)(initialWidth -= horizontalPadding) / (double)(initialHeight -= verticalPadding);
        double diff = this.mAspectRatio / viewAspectRatio - 1.0;
        int wMeasureSpec = widthMeasureSpec;
        int hMeasureSpec = heightMeasureSpec;
        if (this.mAspectRatio > 0.0) {
            boolean bl = false;
            if (Math.abs(diff) > 0.01) {
                if (diff > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.mAspectRatio);
                } else {
                    initialWidth = (int)((double)initialHeight * this.mAspectRatio);
                }
                wMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizontalPadding), (int)0x40000000);
                hMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += verticalPadding), (int)0x40000000);
            }
        }
        super.onMeasure(wMeasureSpec, hMeasureSpec);
    }

    private static final void postUITask$lambda-0(Function0 $task) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        $task.invoke();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jiangdg/ausbc/widget/AspectRatioTextureView$Companion;", "", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

