/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u000f\u0010\t\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ \u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0015\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jiangdg/ausbc/utils/SettableFuture;", "V", "Ljava/util/concurrent/Future;", "()V", "sync", "Lcom/jiangdg/ausbc/utils/SettableFuture$Sync;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isCancelled", "isDone", "set", "value", "(Ljava/lang/Object;)Z", "Sync", "libausbc_release"})
public class SettableFuture<V>
implements Future<V> {
    @NotNull
    private final Sync<V> sync = new Sync();

    public final boolean set(@Nullable V value) {
        return this.sync.set(value);
    }

    @Override
    public boolean isDone() {
        return this.sync.isDone();
    }

    @Override
    @Nullable
    public V get() {
        return this.sync.get();
    }

    @Override
    @Nullable
    public V get(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.sync.get(unit.toNanos(timeout));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.sync.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.sync.isCancelled();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\r\b\u0002\u0018\u0000 %*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J)\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00018\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\r\u0010\u0016\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u000f\u0010\u001b\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u001c\u001a\u00020\tJ\u0006\u0010\u001d\u001a\u00020\tJ\u0015\u0010\u001e\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0014J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0006\u0010$\u001a\u00020\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006&"}, d2={"Lcom/jiangdg/ausbc/utils/SettableFuture$Sync;", "V", "Ljava/util/concurrent/locks/AbstractQueuedSynchronizer;", "()V", "exception", "", "value", "Ljava/lang/Object;", "cancel", "", "interrupt", "cancellationExceptionWithCause", "Ljava/util/concurrent/CancellationException;", "message", "", "cause", "complete", "v", "t", "finalState", "", "(Ljava/lang/Object;Ljava/lang/Throwable;I)Z", "get", "()Ljava/lang/Object;", "nanos", "", "(J)Ljava/lang/Object;", "getValue", "isCancelled", "isDone", "set", "(Ljava/lang/Object;)Z", "setException", "tryAcquireShared", "ignored", "tryReleaseShared", "wasInterrupted", "Companion", "libausbc_release"})
    private static final class Sync<V>
    extends AbstractQueuedSynchronizer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private V value;
        @Nullable
        private Throwable exception;
        private static final int RUNNING = 0;
        private static final int COMPLETING = 1;
        private static final int COMPLETED = 2;
        private static final int CANCELLED = 4;
        private static final int INTERRUPTED = 8;

        public final boolean isDone() {
            return (this.getState() & 0xE) != 0;
        }

        public final boolean isCancelled() {
            return (this.getState() & 0xC) != 0;
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.isDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int finalState) {
            this.setState(finalState);
            return true;
        }

        @Nullable
        public final V get(long nanos) {
            if (!this.tryAcquireSharedNanos(-1, nanos)) {
                throw new TimeoutException("Timeout waiting for task.");
            }
            return this.getValue();
        }

        @Nullable
        public final V get() {
            this.acquireSharedInterruptibly(-1);
            return this.getValue();
        }

        private final V getValue() {
            int n = this.getState();
            switch (n) {
                case 2: {
                    if (this.exception != null) {
                        throw new ExecutionException(this.exception);
                    }
                    return this.value;
                }
                case 4: 
                case 8: {
                    throw this.cancellationExceptionWithCause("Task was cancelled.", this.exception);
                }
            }
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Error, synchronizer in invalid state: ", (Object)this.getState()));
        }

        private final CancellationException cancellationExceptionWithCause(String message, Throwable cause) {
            CancellationException exception = new CancellationException(message);
            exception.initCause(cause);
            return exception;
        }

        public final boolean wasInterrupted() {
            return this.getState() == 8;
        }

        public final boolean set(@Nullable V v) {
            return this.complete(v, null, 2);
        }

        public final boolean setException(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return this.complete(null, t, 2);
        }

        public final boolean cancel(boolean interrupt) {
            return this.complete(null, null, interrupt ? 8 : 4);
        }

        private final boolean complete(V v, Throwable t, int finalState) {
            boolean doCompletion = this.compareAndSetState(0, 1);
            if (doCompletion) {
                this.value = v;
                this.exception = (finalState & 0xC) != 0 ? (Throwable)new CancellationException("Future.cancel() was called.") : t;
                this.releaseShared(finalState);
            } else if (this.getState() == 1) {
                this.acquireShared(-1);
            }
            return doCompletion;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jiangdg/ausbc/utils/SettableFuture$Sync$Companion;", "", "()V", "CANCELLED", "", "COMPLETED", "COMPLETING", "INTERRUPTED", "RUNNING", "libausbc_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

