/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode;

import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Process;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPlayCallBack;
import com.jiangdg.ausbc.encode.AACEncodeProcessor;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.MediaUtils;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.natives.LameMp3;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 =2\u00020\u0001:\u0001=B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u0016H\u0014J\b\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u00020-H\u0014J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002J\b\u00101\u001a\u00020-H\u0002J\u0010\u00102\u001a\u00020-2\b\u00103\u001a\u0004\u0018\u000104J\u0006\u00105\u001a\u00020-J\u0018\u00106\u001a\u00020-2\b\u00107\u001a\u0004\u0018\u00010+2\u0006\u00103\u001a\u000208J\u0006\u00109\u001a\u00020-J\b\u0010:\u001a\u00020-H\u0002J\b\u0010;\u001a\u00020-H\u0002J\b\u0010<\u001a\u00020-H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\f\u0010\u0006R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\b\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\b\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\b\u001a\u0004\b#\u0010\u001eR\u001b\u0010%\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\b\u001a\u0004\b&\u0010\u0006\u00a8\u0006>"}, d2={"Lcom/jiangdg/ausbc/encode/AACEncodeProcessor;", "Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "()V", "mAudioPlayState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMAudioPlayState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mAudioPlayState$delegate", "Lkotlin/Lazy;", "mAudioRecord", "Landroid/media/AudioRecord;", "mAudioRecordState", "getMAudioRecordState", "mAudioRecordState$delegate", "mAudioThreadPool", "Ljava/util/concurrent/ExecutorService;", "getMAudioThreadPool", "()Ljava/util/concurrent/ExecutorService;", "mAudioThreadPool$delegate", "mAudioTrack", "Landroid/media/AudioTrack;", "mBufferSize", "", "getMBufferSize", "()I", "mBufferSize$delegate", "mPlayQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "getMPlayQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "mPlayQueue$delegate", "mPresentationTimeUs", "", "mRecordMp3Queue", "getMRecordMp3Queue", "mRecordMp3Queue$delegate", "mRecordMp3State", "getMRecordMp3State", "mRecordMp3State$delegate", "getPTSUs", "bufferSize", "getThreadName", "", "handleStartEncode", "", "handleStopEncode", "initAudioRecord", "initAudioRecordInternal", "initAudioTrack", "playAudioStart", "callBack", "Lcom/jiangdg/ausbc/callback/IPlayCallBack;", "playAudioStop", "recordMp3Start", "audioPath", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "recordMp3Stop", "releaseAudioRecord", "releaseAudioRecordInternal", "releaseAudioTrack", "Companion", "libausbc_release"})
public final class AACEncodeProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AudioTrack mAudioTrack;
    @Nullable
    private AudioRecord mAudioRecord;
    private long mPresentationTimeUs;
    @NotNull
    private final Lazy mPlayQueue$delegate = LazyKt.lazy((Function0)mPlayQueue.2.INSTANCE);
    @NotNull
    private final Lazy mRecordMp3Queue$delegate = LazyKt.lazy((Function0)mRecordMp3Queue.2.INSTANCE);
    @NotNull
    private final Lazy mAudioThreadPool$delegate = LazyKt.lazy((Function0)mAudioThreadPool.2.INSTANCE);
    @NotNull
    private final Lazy mAudioRecordState$delegate = LazyKt.lazy((Function0)mAudioRecordState.2.INSTANCE);
    @NotNull
    private final Lazy mAudioPlayState$delegate = LazyKt.lazy((Function0)mAudioPlayState.2.INSTANCE);
    @NotNull
    private final Lazy mRecordMp3State$delegate = LazyKt.lazy((Function0)mRecordMp3State.2.INSTANCE);
    @NotNull
    private final Lazy mBufferSize$delegate = LazyKt.lazy((Function0)mBufferSize.2.INSTANCE);
    @NotNull
    private static final String TAG = "AACEncodeProcessor";
    @NotNull
    private static final String MIME_TYPE = "audio/mp4a-latm";
    private static final int SAMPLE_RATE = 8000;
    private static final int BIT_RATE = 16000;
    private static final int MAX_INPUT_SIZE = 8192;
    private static final int CHANNEL_COUNT = 1;
    private static final int CHANNEL_IN_CONFIG = 16;
    private static final int CHANNEL_OUT_CONFIG = 4;
    private static final int AUDIO_FORMAT_16BIT = 2;
    private static final int AUDIO_TRACK_MODE = 1;
    private static final int AUDIO_RECORD_SOURCE = 1;
    private static final int CODEC_AAC_PROFILE = 2;
    private static final int AUDIO_FORMAT_BITS = 16;
    private static final int DEGREE_RECORD_MP3 = 7;

    private final ConcurrentLinkedQueue<RawData> getMPlayQueue() {
        Lazy lazy = this.mPlayQueue$delegate;
        boolean bl = false;
        return (ConcurrentLinkedQueue)lazy.getValue();
    }

    private final ConcurrentLinkedQueue<RawData> getMRecordMp3Queue() {
        Lazy lazy = this.mRecordMp3Queue$delegate;
        boolean bl = false;
        return (ConcurrentLinkedQueue)lazy.getValue();
    }

    private final ExecutorService getMAudioThreadPool() {
        Lazy lazy = this.mAudioThreadPool$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-mAudioThreadPool>(...)");
        return (ExecutorService)object;
    }

    private final AtomicBoolean getMAudioRecordState() {
        Lazy lazy = this.mAudioRecordState$delegate;
        boolean bl = false;
        return (AtomicBoolean)lazy.getValue();
    }

    private final AtomicBoolean getMAudioPlayState() {
        Lazy lazy = this.mAudioPlayState$delegate;
        boolean bl = false;
        return (AtomicBoolean)lazy.getValue();
    }

    private final AtomicBoolean getMRecordMp3State() {
        Lazy lazy = this.mRecordMp3State$delegate;
        boolean bl = false;
        return (AtomicBoolean)lazy.getValue();
    }

    private final int getMBufferSize() {
        Lazy lazy = this.mBufferSize$delegate;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    @NotNull
    protected String getThreadName() {
        return TAG;
    }

    @Override
    protected void handleStartEncode() {
        this.initAudioRecord();
        try {
            MediaFormat mediaFormat = new MediaFormat();
            boolean bl = false;
            boolean bl2 = false;
            MediaFormat $this$handleStartEncode_u24lambda_u2d0 = mediaFormat;
            boolean bl3 = false;
            $this$handleStartEncode_u24lambda_u2d0.setString("mime", MIME_TYPE);
            $this$handleStartEncode_u24lambda_u2d0.setInteger("bitrate", 16000);
            $this$handleStartEncode_u24lambda_u2d0.setInteger("channel-count", 1);
            $this$handleStartEncode_u24lambda_u2d0.setInteger("sample-rate", 8000);
            $this$handleStartEncode_u24lambda_u2d0.setInteger("aac-profile", 2);
            $this$handleStartEncode_u24lambda_u2d0.setInteger("max-input-size", 8192);
            bl = false;
            bl2 = false;
            MediaFormat format = mediaFormat;
            boolean bl4 = false;
            this.setMMediaCodec(MediaCodec.createEncoderByType((String)MIME_TYPE));
            MediaCodec mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.configure(format, null, null, 1);
            }
            mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.start();
            }
            this.getMEncodeState().set(true);
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "init aac media codec success.");
            }
            this.doEncodeData();
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"init aac media codec failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleStopEncode() {
        try {
            this.getMEncodeState().set(false);
            MediaCodec mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.stop();
            }
            mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.release();
            }
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "release aac media codec success.");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"release aac media codec failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
        finally {
            this.releaseAudioRecord();
            this.getMRawDataQueue().clear();
            this.setMMediaCodec(null);
        }
    }

    @Override
    protected long getPTSUs(int bufferSize) {
        AACEncodeProcessor aACEncodeProcessor = this;
        aACEncodeProcessor.mPresentationTimeUs += (long)(1.0 * (double)bufferSize / (double)16000 * 1000000.0);
        return this.mPresentationTimeUs;
    }

    public final void playAudioStart(@Nullable IPlayCallBack callBack) {
        this.getMAudioThreadPool().submit(() -> AACEncodeProcessor.playAudioStart$lambda-6(this, callBack));
    }

    public final void playAudioStop() {
        this.getMAudioPlayState().set(false);
    }

    public final void recordMp3Start(@Nullable String audioPath, @NotNull ICaptureCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        this.getMAudioThreadPool().submit(() -> AACEncodeProcessor.recordMp3Start$lambda-13(audioPath, this, callBack));
    }

    public final void recordMp3Stop() {
        this.getMRecordMp3State().set(false);
    }

    private final void initAudioRecord() {
        if (this.getMAudioRecordState().get()) {
            return;
        }
        this.getMAudioThreadPool().submit(() -> AACEncodeProcessor.initAudioRecord$lambda-14(this));
    }

    private final void releaseAudioRecord() {
        if (this.getMEncodeState().get() || this.getMAudioPlayState().get() || this.getMRecordMp3State().get()) {
            return;
        }
        this.getMAudioRecordState().set(false);
    }

    private final void initAudioRecordInternal() {
        try {
            Process.setThreadPriority((int)-16);
            AudioRecord audioRecord = this.mAudioRecord = new AudioRecord(1, 8000, 16, 2, this.getMBufferSize());
            if (audioRecord != null) {
                audioRecord.startRecording();
            }
            this.getMAudioRecordState().set(true);
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "initAudioRecordInternal success");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"initAudioRecordInternal failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    private final void releaseAudioRecordInternal() {
        try {
            AudioRecord audioRecord = this.mAudioRecord;
            if (audioRecord != null) {
                audioRecord.stop();
            }
            audioRecord = this.mAudioRecord;
            if (audioRecord != null) {
                audioRecord.release();
            }
            this.mAudioRecord = null;
            this.getMRawDataQueue().clear();
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "releaseAudioRecordInternal success.");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"releaseAudioRecordInternal failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    private final void initAudioTrack() {
        if (this.getMAudioPlayState().get()) {
            Logger.INSTANCE.w(TAG, "initAudioTracker has ready execute!");
            return;
        }
        Process.setThreadPriority((int)-19);
        int minBufferSize = AudioTrack.getMinBufferSize((int)8000, (int)4, (int)2);
        this.mAudioTrack = new AudioTrack(3, 8000, 4, 2, minBufferSize, 1);
        this.getMAudioPlayState().set(true);
    }

    private final void releaseAudioTrack() {
        try {
            AudioTrack audioTrack = this.mAudioTrack;
            if (audioTrack != null) {
                audioTrack.release();
            }
            this.mAudioTrack = null;
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"releaseAudioTracker failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    private static final void playAudioStart$lambda-6$lambda-2(IPlayCallBack $callBack) {
        IPlayCallBack iPlayCallBack = $callBack;
        if (iPlayCallBack != null) {
            iPlayCallBack.onBegin();
        }
    }

    private static final void playAudioStart$lambda-6$lambda-4(IPlayCallBack $callBack) {
        IPlayCallBack iPlayCallBack = $callBack;
        if (iPlayCallBack != null) {
            iPlayCallBack.onComplete();
        }
    }

    private static final void playAudioStart$lambda-6$lambda-5(IPlayCallBack $callBack, Exception $e) {
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        IPlayCallBack iPlayCallBack = $callBack;
        if (iPlayCallBack != null) {
            String string = $e.getLocalizedMessage();
            iPlayCallBack.onError(string == null ? "unknown exception" : string);
        }
    }

    private static final void playAudioStart$lambda-6(AACEncodeProcessor this$0, IPlayCallBack $callBack) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.initAudioRecord();
            this$0.initAudioTrack();
            this$0.getMMainHandler().post(() -> AACEncodeProcessor.playAudioStart$lambda-6$lambda-2($callBack));
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "start play mic success.");
            }
            while (this$0.getMAudioPlayState().get()) {
                Integer state;
                Object object = this$0.mAudioTrack;
                Integer n = state = object == null ? null : Integer.valueOf(object.getState());
                int n2 = 1;
                if (n == null || n != n2) break;
                object = this$0.getMPlayQueue().poll();
                if (object == null) continue;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$playAudioStart_u24lambda_u2d6_u24lambda_u2d3 = object2;
                boolean bl3 = false;
                AudioTrack audioTrack = this$0.mAudioTrack;
                if (audioTrack != null) {
                    audioTrack.play();
                }
                audioTrack = this$0.mAudioTrack;
                if (audioTrack == null) continue;
                audioTrack.write(((RawData)$this$playAudioStart_u24lambda_u2d6_u24lambda_u2d3).getData(), 0, ((RawData)$this$playAudioStart_u24lambda_u2d6_u24lambda_u2d3).getSize());
            }
            this$0.releaseAudioTrack();
            this$0.releaseAudioRecord();
            this$0.getMMainHandler().post(() -> AACEncodeProcessor.playAudioStart$lambda-6$lambda-4($callBack));
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "stop play mic success.");
            }
        }
        catch (Exception e) {
            this$0.getMMainHandler().post(() -> AACEncodeProcessor.playAudioStart$lambda-6$lambda-5($callBack, e));
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"start/stop play mic failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    private static final void recordMp3Start$lambda-13$lambda-7(ICaptureCallBack $callBack, String $audioPath) {
        Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
        $callBack.onError("save path(" + $audioPath + ") invalid");
    }

    private static final void recordMp3Start$lambda-13$lambda-8(ICaptureCallBack $callBack) {
        Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
        $callBack.onBegin();
    }

    private static final void recordMp3Start$lambda-13$lambda-10(ICaptureCallBack $callBack, Exception $e) {
        Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        String string = $e.getLocalizedMessage();
        $callBack.onError(string == null ? "unknown exception" : string);
    }

    private static final void recordMp3Start$lambda-13$lambda-11(ICaptureCallBack $callBack, String $audioPath) {
        Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
        $callBack.onComplete($audioPath);
    }

    private static final void recordMp3Start$lambda-13$lambda-12(ICaptureCallBack $callBack, Exception $e) {
        Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        String string = $e.getLocalizedMessage();
        $callBack.onError(string == null ? "unknown exception" : string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void recordMp3Start$lambda-13(String $audioPath, AACEncodeProcessor this$0, ICaptureCallBack $callBack) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
        fos = null;
        try {
            block20: {
                var4_4 = $audioPath;
                var5_11 = false;
                var6_15 = false;
                if (!(var4_4 == null || var4_4.length() == 0)) break block20;
                this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-7(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
                ** try [egrp 1[TRYBLOCK] [0 : 68->125)] { 
lbl14:
                // 1 sources

                ** GOTO lbl-1000
            }
            this$0.initAudioRecord();
            file = new File($audioPath);
            if (file.exists()) {
                file.delete();
            }
            fos = new FileOutputStream((File)file);
            mp3Buf = new byte[1024];
            LameMp3.INSTANCE.lameInit(8000, 1, 8000, 16000, 7);
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-8(com.jiangdg.ausbc.callback.ICaptureCallBack ), ()V)((ICaptureCallBack)$callBack));
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i("AACEncodeProcessor", Intrinsics.stringPlus((String)"start record mp3 success, path = ", (Object)$audioPath));
            }
            this$0.getMRecordMp3State().set(true);
            while (this$0.getMRecordMp3State().get()) {
                var6_16 = this$0.getMRecordMp3Queue().poll();
                if (var6_16 == null) continue;
                var7_18 = var6_16;
                var8_19 = false;
                var9_20 = false;
                $this$recordMp3Start_u24lambda_u2d13_u24lambda_u2d9 = var7_18;
                $i$a$-apply-AACEncodeProcessor$recordMp3Start$1$3 = false;
                tmpData = MediaUtils.INSTANCE.transferByte2Short($this$recordMp3Start_u24lambda_u2d13_u24lambda_u2d9.getData(), $this$recordMp3Start_u24lambda_u2d13_u24lambda_u2d9.getSize());
                encodeSize = LameMp3.INSTANCE.lameEncode(tmpData, null, tmpData.length, mp3Buf);
                if (encodeSize <= 0) continue;
                var14_25 = fos;
                var14_25.write(mp3Buf, 0, encodeSize);
            }
            flushSize = LameMp3.INSTANCE.lameFlush(mp3Buf);
            if (flushSize > 0) {
                fos.write(mp3Buf, 0, flushSize);
            }
            ** try [egrp 3[TRYBLOCK] [1 : 404->463)] { 
lbl48:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (Exception e) {
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-10(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
            Logger.INSTANCE.e("AACEncodeProcessor", Intrinsics.stringPlus((String)"start/stop record mp3 failed, err = ", (Object)e.getLocalizedMessage()), e);
            return;
        }
lbl-1000:
        // 1 sources

        {
            var4_4 = fos;
            fos = null;
            LameMp3.INSTANCE.lameClose();
            this$0.releaseAudioRecord();
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-11(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
            if (Utils.INSTANCE.getDebugCamera$libausbc_release() == false) return;
            Logger.INSTANCE.i("AACEncodeProcessor", "stop record mp3 success.");
            return;
        }
lbl66:
        // 1 sources

        catch (Exception e) {
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-12(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
            Logger.INSTANCE.e("AACEncodeProcessor", Intrinsics.stringPlus((String)"stop record mp3 failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
        return;
lbl-1000:
        // 1 sources

        {
            file = fos;
            file.close();
            fos = null;
            LameMp3.INSTANCE.lameClose();
            this$0.releaseAudioRecord();
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-11(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
            if (Utils.INSTANCE.getDebugCamera$libausbc_release() == false) return;
            Logger.INSTANCE.i("AACEncodeProcessor", "stop record mp3 success.");
            return;
        }
lbl81:
        // 1 sources

        catch (Exception e) {
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-12(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
            Logger.INSTANCE.e("AACEncodeProcessor", Intrinsics.stringPlus((String)"stop record mp3 failed, err = ", (Object)e.getLocalizedMessage()), e);
            return;
        }
        finally {
            try {
                e = fos;
                if (e != null) {
                    e.close();
                }
                fos = null;
                LameMp3.INSTANCE.lameClose();
                this$0.releaseAudioRecord();
                this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-11(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
                if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                    Logger.INSTANCE.i("AACEncodeProcessor", "stop record mp3 success.");
                }
            }
            catch (Exception e) {
                this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda-13$lambda-12(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
                Logger.INSTANCE.e("AACEncodeProcessor", Intrinsics.stringPlus((String)"stop record mp3 failed, err = ", (Object)e.getLocalizedMessage()), e);
            }
        }
    }

    private static final void initAudioRecord$lambda-14(AACEncodeProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.initAudioRecordInternal();
        while (this$0.getMAudioRecordState().get()) {
            int n;
            Integer recordingState;
            AudioRecord audioRecord = this$0.mAudioRecord;
            Integer n2 = recordingState = audioRecord == null ? null : Integer.valueOf(audioRecord.getRecordingState());
            int n3 = 3;
            if (n2 == null || n2 != n3) {
                Logger.e$default(Logger.INSTANCE, TAG, Intrinsics.stringPlus((String)"initAudioRecord failed, state = ", (Object)recordingState), null, 4, null);
                break;
            }
            byte[] data = new byte[this$0.getMBufferSize()];
            AudioRecord audioRecord2 = this$0.mAudioRecord;
            int readBytes = audioRecord2 == null ? 0 : (n = audioRecord2.read(data, 0, this$0.getMBufferSize()));
            if (readBytes <= 0) continue;
            if (this$0.getMRawDataQueue().size() >= 10) {
                this$0.getMRawDataQueue().poll();
            }
            this$0.getMRawDataQueue().offer(new RawData(data, readBytes));
            if (this$0.getMPlayQueue().size() >= 10) {
                this$0.getMPlayQueue().poll();
            }
            this$0.getMPlayQueue().offer(new RawData(data, readBytes));
            if (this$0.getMRecordMp3Queue().size() >= 10) {
                this$0.getMRecordMp3Queue().poll();
            }
            this$0.getMRecordMp3Queue().offer(new RawData(data, readBytes));
        }
        this$0.releaseAudioRecordInternal();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jiangdg/ausbc/encode/AACEncodeProcessor$Companion;", "", "()V", "AUDIO_FORMAT_16BIT", "", "AUDIO_FORMAT_BITS", "AUDIO_RECORD_SOURCE", "AUDIO_TRACK_MODE", "BIT_RATE", "CHANNEL_COUNT", "CHANNEL_IN_CONFIG", "CHANNEL_OUT_CONFIG", "CODEC_AAC_PROFILE", "DEGREE_RECORD_MP3", "MAX_INPUT_SIZE", "MIME_TYPE", "", "SAMPLE_RATE", "TAG", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

