/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.encoder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.serenegiant.usb.encoder.MediaAudioEncoder;
import com.serenegiant.usb.encoder.MediaEncoder;
import com.serenegiant.usb.encoder.MediaSurfaceEncoder;
import com.serenegiant.usb.encoder.MediaVideoBufferEncoder;
import com.serenegiant.usb.encoder.MediaVideoEncoder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

public class MediaMuxerWrapper {
    private static final boolean DEBUG = true;
    private static final String TAG = "MediaMuxerWrapper";
    private static final String DIR_NAME = "USBCameraTest";
    private static final SimpleDateFormat mDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);
    private String mOutputPath;
    private final MediaMuxer mMediaMuxer;
    private int mEncoderCount;
    private int mStatredCount;
    private boolean mIsStarted;
    private MediaEncoder mVideoEncoder;
    private MediaEncoder mAudioEncoder;

    @TargetApi(value=18)
    public MediaMuxerWrapper(String path) throws IOException {
        try {
            if (TextUtils.isEmpty((CharSequence)path)) {
                this.mOutputPath = MediaMuxerWrapper.getCaptureFile(Environment.DIRECTORY_MOVIES, ".mp4").toString();
            }
            this.mOutputPath = path;
        }
        catch (NullPointerException e) {
            throw new RuntimeException("This app has no permission of writing external storage");
        }
        this.mMediaMuxer = new MediaMuxer(this.mOutputPath, 0);
        this.mStatredCount = 0;
        this.mEncoderCount = 0;
        this.mIsStarted = false;
    }

    public String getOutputPath() {
        return this.mOutputPath;
    }

    public void prepare() throws IOException {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.prepare();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.prepare();
        }
    }

    public void startRecording() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.startRecording();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.startRecording();
        }
    }

    public void stopRecording() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.stopRecording();
        }
        this.mVideoEncoder = null;
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.stopRecording();
        }
        this.mAudioEncoder = null;
    }

    public synchronized boolean isStarted() {
        return this.mIsStarted;
    }

    void addEncoder(MediaEncoder encoder) {
        if (encoder instanceof MediaVideoEncoder) {
            if (this.mVideoEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mVideoEncoder = encoder;
        } else if (encoder instanceof MediaSurfaceEncoder) {
            if (this.mVideoEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mVideoEncoder = encoder;
        } else if (encoder instanceof MediaVideoBufferEncoder) {
            if (this.mVideoEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mVideoEncoder = encoder;
        } else if (encoder instanceof MediaAudioEncoder) {
            if (this.mAudioEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mAudioEncoder = encoder;
        } else {
            throw new IllegalArgumentException("unsupported encoder");
        }
        this.mEncoderCount = (this.mVideoEncoder != null ? 1 : 0) + (this.mAudioEncoder != null ? 1 : 0);
    }

    synchronized boolean start() {
        Log.v((String)TAG, (String)"start:");
        ++this.mStatredCount;
        if (this.mEncoderCount > 0 && this.mStatredCount == this.mEncoderCount) {
            this.mMediaMuxer.start();
            this.mIsStarted = true;
            this.notifyAll();
            Log.v((String)TAG, (String)"MediaMuxer started:");
        }
        return this.mIsStarted;
    }

    synchronized void stop() {
        Log.v((String)TAG, (String)("stop:mStatredCount=" + this.mStatredCount));
        --this.mStatredCount;
        if (this.mEncoderCount > 0 && this.mStatredCount <= 0) {
            try {
                this.mMediaMuxer.stop();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mIsStarted = false;
            Log.v((String)TAG, (String)"MediaMuxer stopped:");
        }
    }

    synchronized int addTrack(MediaFormat format) {
        if (this.mIsStarted) {
            throw new IllegalStateException("muxer already started");
        }
        int trackIx = this.mMediaMuxer.addTrack(format);
        Log.i((String)TAG, (String)("addTrack:trackNum=" + this.mEncoderCount + ",trackIx=" + trackIx + ",format=" + format));
        return trackIx;
    }

    synchronized void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (this.mStatredCount > 0) {
            this.mMediaMuxer.writeSampleData(trackIndex, byteBuf, bufferInfo);
        }
    }

    public static final File getCaptureFile(String type, String ext) {
        File dir = new File(Environment.getExternalStoragePublicDirectory((String)type), DIR_NAME);
        Log.d((String)TAG, (String)("path=" + dir.toString()));
        dir.mkdirs();
        if (dir.canWrite()) {
            return new File(dir, MediaMuxerWrapper.getDateTimeString() + ext);
        }
        return null;
    }

    private static final String getDateTimeString() {
        GregorianCalendar now = new GregorianCalendar();
        return mDateTimeFormat.format(now.getTime());
    }
}

