/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.encoder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.glutils.EGLBase;
import com.serenegiant.glutils.RenderHandler;
import com.serenegiant.usb.encoder.IVideoEncoder;
import com.serenegiant.usb.encoder.MediaEncoder;
import com.serenegiant.usb.encoder.MediaMuxerWrapper;
import java.io.IOException;

public class MediaVideoEncoder
extends MediaEncoder
implements IVideoEncoder {
    private static final boolean DEBUG = true;
    private static final String TAG = "MediaVideoEncoder";
    private static final String MIME_TYPE = "video/avc";
    private final int mWidth;
    private final int mHeight;
    private static final int FRAME_RATE = 15;
    private static final float BPP = 0.5f;
    private RenderHandler mRenderHandler;
    private Surface mSurface;
    protected static int[] recognizedFormats = new int[]{2130708361};

    public MediaVideoEncoder(MediaMuxerWrapper muxer, int width, int height, MediaEncoder.MediaEncoderListener listener) {
        super(muxer, listener);
        Log.i((String)TAG, (String)"MediaVideoEncoder: ");
        this.mRenderHandler = RenderHandler.createHandler((String)TAG);
        this.mWidth = width;
        this.mHeight = height;
    }

    public boolean frameAvailableSoon(float[] tex_matrix) {
        boolean result = super.frameAvailableSoon();
        if (result) {
            this.mRenderHandler.draw(tex_matrix);
        }
        return result;
    }

    @Override
    public boolean frameAvailableSoon() {
        boolean result = super.frameAvailableSoon();
        if (result) {
            this.mRenderHandler.draw(null);
        }
        return result;
    }

    @Override
    @TargetApi(value=18)
    protected void prepare() throws IOException {
        Log.i((String)TAG, (String)"prepare: ");
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mMuxerStarted = false;
        MediaCodecInfo videoCodecInfo = MediaVideoEncoder.selectVideoCodec(MIME_TYPE);
        if (videoCodecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return;
        }
        Log.i((String)TAG, (String)("selected codec: " + videoCodecInfo.getName()));
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.calcBitRate());
        format.setInteger("frame-rate", 15);
        format.setInteger("i-frame-interval", 1);
        Log.i((String)TAG, (String)("format: " + format));
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mMediaCodec.configure(format, null, null, 1);
        this.mSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
        Log.i((String)TAG, (String)"prepare finishing");
        if (this.mListener != null) {
            try {
                this.mListener.onPrepared(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"prepare:", (Throwable)e);
            }
        }
    }

    public void setEglContext(EGLBase.IContext sharedContext, int tex_id) {
        this.mRenderHandler.setEglContext(sharedContext, tex_id, (Object)this.mSurface, true);
    }

    @Override
    protected void release() {
        Log.i((String)TAG, (String)"release:");
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        if (this.mRenderHandler != null) {
            this.mRenderHandler.release();
            this.mRenderHandler = null;
        }
        super.release();
    }

    private int calcBitRate() {
        int bitrate = (int)(7.5f * (float)this.mWidth * (float)this.mHeight);
        Log.i((String)TAG, (String)String.format("bitrate=%5.2f[Mbps]", Float.valueOf((float)bitrate / 1024.0f / 1024.0f)));
        return bitrate;
    }

    protected static final MediaCodecInfo selectVideoCodec(String mimeType) {
        Log.v((String)TAG, (String)"selectVideoCodec:");
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                Log.i((String)TAG, (String)("codec:" + codecInfo.getName() + ",MIME=" + types[j]));
                int format = MediaVideoEncoder.selectColorFormat(codecInfo, mimeType);
                if (format <= 0) continue;
                return codecInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities caps;
        Log.i((String)TAG, (String)"selectColorFormat: ");
        int result = 0;
        try {
            Thread.currentThread().setPriority(10);
            caps = codecInfo.getCapabilitiesForType(mimeType);
        }
        finally {
            Thread.currentThread().setPriority(5);
        }
        for (int i = 0; i < caps.colorFormats.length; ++i) {
            int colorFormat = caps.colorFormats[i];
            if (!MediaVideoEncoder.isRecognizedVideoFormat(colorFormat)) continue;
            if (result != 0) break;
            result = colorFormat;
            break;
        }
        if (result == 0) {
            Log.e((String)TAG, (String)("couldn't find a good color format for " + codecInfo.getName() + " / " + mimeType));
        }
        return result;
    }

    private static final boolean isRecognizedVideoFormat(int colorFormat) {
        Log.i((String)TAG, (String)("isRecognizedVideoFormat:colorFormat=" + colorFormat));
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }
}

