/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.encoder;

import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Process;
import android.util.Log;
import com.serenegiant.usb.encoder.IAudioEncoder;
import com.serenegiant.usb.encoder.MediaEncoder;
import com.serenegiant.usb.encoder.MediaMuxerWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MediaAudioEncoder
extends MediaEncoder
implements IAudioEncoder {
    private static final boolean DEBUG = true;
    private static final String TAG = "MediaAudioEncoder";
    private static final String MIME_TYPE = "audio/mp4a-latm";
    public static final int SAMPLE_RATE = 44100;
    private static final int BIT_RATE = 64000;
    public static final int SAMPLES_PER_FRAME = 1024;
    public static final int FRAMES_PER_BUFFER = 25;
    private AudioThread mAudioThread = null;
    private static final int[] AUDIO_SOURCES = new int[]{0, 1, 5};

    public MediaAudioEncoder(MediaMuxerWrapper muxer, MediaEncoder.MediaEncoderListener listener) {
        super(muxer, listener);
    }

    @Override
    protected void prepare() throws IOException {
        Log.v((String)TAG, (String)"prepare:");
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mMuxerStarted = false;
        MediaCodecInfo audioCodecInfo = MediaAudioEncoder.selectAudioCodec(MIME_TYPE);
        if (audioCodecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for audio/mp4a-latm");
            return;
        }
        Log.i((String)TAG, (String)("selected codec: " + audioCodecInfo.getName()));
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)MIME_TYPE, (int)44100, (int)1);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", 16);
        audioFormat.setInteger("bitrate", 64000);
        audioFormat.setInteger("channel-count", 1);
        Log.i((String)TAG, (String)("format: " + audioFormat));
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        Log.i((String)TAG, (String)"prepare finishing");
        if (this.mListener != null) {
            try {
                this.mListener.onPrepared(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"prepare:", (Throwable)e);
            }
        }
    }

    @Override
    protected void startRecording() {
        super.startRecording();
        if (this.mAudioThread == null) {
            this.mAudioThread = new AudioThread();
            this.mAudioThread.start();
        }
    }

    @Override
    protected void release() {
        this.mAudioThread = null;
        super.release();
    }

    private static final MediaCodecInfo selectAudioCodec(String mimeType) {
        Log.v((String)TAG, (String)"selectAudioCodec:");
        MediaCodecInfo result = null;
        int numCodecs = MediaCodecList.getCodecCount();
        block0: for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                Log.i((String)TAG, (String)("supportedType:" + codecInfo.getName() + ",MIME=" + types[j]));
                if (!types[j].equalsIgnoreCase(mimeType) || result != null) continue;
                result = codecInfo;
                break block0;
            }
        }
        return result;
    }

    private class AudioThread
    extends Thread {
        private AudioThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buf;
            int cnt;
            block27: {
                Process.setThreadPriority((int)-16);
                cnt = 0;
                int min_buffer_size = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
                int buffer_size = 25600;
                if (buffer_size < min_buffer_size) {
                    buffer_size = (min_buffer_size / 1024 + 1) * 1024 * 2;
                }
                buf = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
                AudioRecord audioRecord = null;
                for (int src : AUDIO_SOURCES) {
                    try {
                        audioRecord = new AudioRecord(src, 44100, 16, 2, buffer_size);
                        if (audioRecord != null && audioRecord.getState() != 1) {
                            audioRecord.release();
                            audioRecord = null;
                        }
                    }
                    catch (Exception e) {
                        audioRecord = null;
                    }
                    if (audioRecord != null) break;
                }
                if (audioRecord != null) {
                    try {
                        if (!MediaAudioEncoder.this.mIsCapturing) break block27;
                        Log.v((String)MediaAudioEncoder.TAG, (String)"AudioThread:start audio recording");
                        audioRecord.startRecording();
                        try {
                            while (MediaAudioEncoder.this.mIsCapturing && !MediaAudioEncoder.this.mRequestStop && !MediaAudioEncoder.this.mIsEOS) {
                                int readBytes;
                                buf.clear();
                                try {
                                    readBytes = audioRecord.read(buf, 1024);
                                }
                                catch (Exception e) {
                                    break;
                                }
                                if (readBytes <= 0) continue;
                                buf.position(readBytes);
                                buf.flip();
                                MediaAudioEncoder.this.encode(buf, readBytes, MediaAudioEncoder.this.getPTSUs());
                                MediaAudioEncoder.this.frameAvailableSoon();
                                ++cnt;
                            }
                            if (cnt > 0) {
                                MediaAudioEncoder.this.frameAvailableSoon();
                            }
                        }
                        finally {
                            audioRecord.stop();
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)MediaAudioEncoder.TAG, (String)"AudioThread#run", (Throwable)e);
                    }
                    finally {
                        audioRecord.release();
                    }
                }
            }
            if (cnt == 0) {
                for (int i = 0; MediaAudioEncoder.this.mIsCapturing && i < 5; ++i) {
                    buf.position(1024);
                    buf.flip();
                    try {
                        MediaAudioEncoder.this.encode(buf, 1024, MediaAudioEncoder.this.getPTSUs());
                        MediaAudioEncoder.this.frameAvailableSoon();
                    }
                    catch (Exception e) {
                        break;
                    }
                    AudioThread audioThread = this;
                    synchronized (audioThread) {
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
            Log.v((String)MediaAudioEncoder.TAG, (String)"AudioThread:finished");
        }
    }
}

