/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnyx2012.horizontalpicker;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.github.jhonnyx2012.horizontalpicker.Day;
import com.github.jhonnyx2012.horizontalpicker.OnItemClickedListener;
import com.github.jhonnyx2012.horizontalpicker.R;
import java.util.ArrayList;
import org.joda.time.DateTime;

public class HorizontalPickerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final long DAY_MILLIS = 86400000L;
    private int itemWidth;
    private final OnItemClickedListener listener;
    private final int primaryTextColor;
    private ArrayList<Day> items = new ArrayList();

    public HorizontalPickerAdapter(int itemWidth, OnItemClickedListener listener, Context context, int daysToCreate, int offset) {
        this.itemWidth = itemWidth;
        this.listener = listener;
        this.primaryTextColor = context.getResources().getColor(R.color.primaryTextColor);
        this.generateDays(daysToCreate, new DateTime().minusDays(offset).getMillis(), false);
    }

    public void generateDays(int n, long initialDate, boolean cleanArray) {
        if (cleanArray) {
            this.items.clear();
        }
        int i = 0;
        while (i < n) {
            DateTime actualDate = new DateTime(initialDate + 86400000L * (long)i++);
            this.items.add(new Day(actualDate));
        }
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_day, parent, false));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        Day item = this.getItem(position);
        holder.tvDay.setText((CharSequence)item.getDay());
        holder.tvWeekDay.setText((CharSequence)item.getWeekDay());
        if (item.isSelected()) {
            holder.tvDay.setBackgroundResource(R.drawable.background_day_selected);
            holder.tvDay.setTextColor(-1);
        } else if (item.isToday()) {
            holder.tvDay.setBackgroundResource(R.drawable.background_day_today);
            holder.tvDay.setTextColor(this.primaryTextColor);
        } else {
            holder.tvDay.setBackgroundColor(0);
            holder.tvDay.setTextColor(this.primaryTextColor);
        }
    }

    public Day getItem(int position) {
        return this.items.get(position);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        TextView tvDay;
        TextView tvWeekDay;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvDay = (TextView)itemView.findViewById(R.id.tvDay);
            this.tvDay.setWidth(HorizontalPickerAdapter.this.itemWidth);
            this.tvWeekDay = (TextView)itemView.findViewById(R.id.tvWeekDay);
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            HorizontalPickerAdapter.this.listener.onClickView(v, this.getAdapterPosition());
        }
    }
}

