/*
 * Decompiled with CFR 0.152.
 */
package dev.jeziellago.compose.markdowntext;

import android.content.Context;
import android.text.Layout;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/jeziellago/compose/markdowntext/CustomTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isTextSelectable", "", "getClickableSpans", "", "Landroid/text/style/ClickableSpan;", "event", "Landroid/view/MotionEvent;", "(Landroid/view/MotionEvent;)[Landroid/text/style/ClickableSpan;", "onTouchEvent", "performClick", "setTextIsSelectable", "", "selectable", "markdowntext_release"})
@StabilityInferred(parameters=0)
public final class CustomTextView
extends AppCompatTextView {
    private boolean isTextSelectable;
    public static final int $stable = 8;

    public CustomTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        ClickableSpan[] link2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.performClick();
        if (this.isTextSelectable) {
            return super.onTouchEvent(event);
        }
        if ((event.getAction() == 1 || event.getAction() == 0) && !((link2 = this.getClickableSpans(event)).length == 0)) {
            if (event.getAction() == 1) {
                link2[0].onClick((View)this);
            }
            return true;
        }
        return false;
    }

    private final ClickableSpan[] getClickableSpans(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= this.getTotalPaddingLeft();
        y -= this.getTotalPaddingTop();
        Layout layout = this.getLayout();
        int line = layout.getLineForVertical(y += this.getScrollY());
        int off = layout.getOffsetForHorizontal(line, (float)(x += this.getScrollX()));
        CharSequence charSequence = this.getText();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spannable");
        Spannable spannable = (Spannable)charSequence;
        Object[] objectArray = spannable.getSpans(off, off, ClickableSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(...)");
        return (ClickableSpan[])objectArray;
    }

    public boolean performClick() {
        return super.performClick();
    }

    public void setTextIsSelectable(boolean selectable) {
        super.setTextIsSelectable(selectable);
        this.isTextSelectable = selectable;
    }
}

