/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan.util;

import android.graphics.Point;
import com.king.logx.LogX;

public final class PointUtils {
    private PointUtils() {
        throw new AssertionError();
    }

    public static Point transform(Point point, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        return PointUtils.transform(point, srcWidth, srcHeight, destWidth, destHeight, false);
    }

    public static Point transform(Point point, int srcWidth, int srcHeight, int destWidth, int destHeight, boolean isFit) {
        return PointUtils.transform(point.x, point.y, srcWidth, srcHeight, destWidth, destHeight, isFit);
    }

    public static Point transform(int x, int y, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        return PointUtils.transform(x, y, srcWidth, srcHeight, destWidth, destHeight, false);
    }

    public static Point transform(int x, int y, int srcWidth, int srcHeight, int destWidth, int destHeight, boolean isFit) {
        LogX.d((String)"transform: %d,%d | %d,%d", (Object[])new Object[]{srcWidth, srcHeight, destWidth, destHeight});
        float widthRatio = (float)destWidth * 1.0f / (float)srcWidth;
        float heightRatio = (float)destHeight * 1.0f / (float)srcHeight;
        Point point = new Point();
        if (isFit) {
            float ratio = Math.min(widthRatio, heightRatio);
            float left = Math.abs((float)srcWidth * ratio - (float)destWidth) / 2.0f;
            float top = Math.abs((float)srcHeight * ratio - (float)destHeight) / 2.0f;
            point.x = (int)((float)x * ratio + left);
            point.y = (int)((float)y * ratio + top);
        } else {
            float ratio = Math.max(widthRatio, heightRatio);
            float left = Math.abs((float)srcWidth * ratio - (float)destWidth) / 2.0f;
            float top = Math.abs((float)srcHeight * ratio - (float)destHeight) / 2.0f;
            point.x = (int)((float)x * ratio - left);
            point.y = (int)((float)y * ratio - top);
        }
        return point;
    }
}

