/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan.util;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.ExifInterface;
import android.media.Image;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProxy;
import com.king.camera.scan.FrameMetadata;
import com.king.logx.LogX;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class BitmapUtils {
    private BitmapUtils() {
        throw new AssertionError();
    }

    @Nullable
    public static Bitmap getBitmap(byte[] nv21Data, FrameMetadata frameMetadata) {
        return BitmapUtils.getBitmap(ByteBuffer.wrap(nv21Data), frameMetadata.getWidth(), frameMetadata.getHeight(), frameMetadata.getRotation());
    }

    @Nullable
    public static Bitmap getBitmap(ByteBuffer data, int width, int height, int rotationDegrees) {
        data.rewind();
        byte[] imageInBuffer = new byte[data.limit()];
        data.get(imageInBuffer, 0, imageInBuffer.length);
        try {
            YuvImage image = new YuvImage(imageInBuffer, 17, width, height, null);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            image.compressToJpeg(new Rect(0, 0, width, height), 80, (OutputStream)stream);
            Bitmap bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
            stream.close();
            return BitmapUtils.rotateBitmap(bmp, rotationDegrees, false, false);
        }
        catch (Exception e) {
            LogX.e((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Bitmap getBitmap(ImageProxy image) {
        byte[] nv21Data = BitmapUtils.yuv420ThreePlanesToNV21(image.getImage().getPlanes(), image.getWidth(), image.getHeight());
        return BitmapUtils.getBitmap(ByteBuffer.wrap(nv21Data), image.getWidth(), image.getHeight(), image.getImageInfo().getRotationDegrees());
    }

    private static Bitmap rotateBitmap(Bitmap bitmap, int rotationDegrees, boolean flipX, boolean flipY) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotationDegrees);
        matrix.postScale(flipX ? -1.0f : 1.0f, flipY ? -1.0f : 1.0f);
        Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (rotatedBitmap != bitmap) {
            bitmap.recycle();
        }
        return rotatedBitmap;
    }

    @RequiresApi(api=24)
    @Nullable
    public static Bitmap getBitmapFromContentUri(ContentResolver contentResolver, Uri imageUri) throws IOException {
        Bitmap decodedBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)contentResolver, (Uri)imageUri);
        if (decodedBitmap == null) {
            return null;
        }
        int orientation = BitmapUtils.getExifOrientationTag(contentResolver, imageUri);
        int rotationDegrees = 0;
        boolean flipX = false;
        boolean flipY = false;
        switch (orientation) {
            case 2: {
                flipX = true;
                break;
            }
            case 6: {
                rotationDegrees = 90;
                break;
            }
            case 5: {
                rotationDegrees = 90;
                flipX = true;
                break;
            }
            case 3: {
                rotationDegrees = 180;
                break;
            }
            case 4: {
                flipY = true;
                break;
            }
            case 8: {
                rotationDegrees = -90;
                break;
            }
            case 7: {
                rotationDegrees = -90;
                flipX = true;
                break;
            }
        }
        return BitmapUtils.rotateBitmap(decodedBitmap, rotationDegrees, flipX, flipY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresApi(api=24)
    private static int getExifOrientationTag(ContentResolver resolver, Uri imageUri) {
        if (!"content".equals(imageUri.getScheme()) && !"file".equals(imageUri.getScheme())) {
            return 0;
        }
        try (InputStream inputStream = resolver.openInputStream(imageUri);){
            if (inputStream == null) {
                int n = 0;
                return n;
            }
            ExifInterface exif = new ExifInterface(inputStream);
            return exif.getAttributeInt("Orientation", 1);
        }
        catch (IOException e) {
            LogX.e((Throwable)e, (String)("failed to open file to read rotation meta data: " + imageUri), (Object[])new Object[0]);
            return 0;
        }
    }

    public static byte[] yuv420ThreePlanesToNV21(Image.Plane[] yuv420888planes, int width, int height) {
        int imageSize = width * height;
        byte[] out = new byte[imageSize + 2 * (imageSize / 4)];
        if (BitmapUtils.areUVPlanesNV21(yuv420888planes, width, height)) {
            yuv420888planes[0].getBuffer().get(out, 0, imageSize);
            ByteBuffer uBuffer = yuv420888planes[1].getBuffer();
            ByteBuffer vBuffer = yuv420888planes[2].getBuffer();
            vBuffer.get(out, imageSize, 1);
            uBuffer.get(out, imageSize + 1, 2 * imageSize / 4 - 1);
        } else {
            BitmapUtils.unpackPlane(yuv420888planes[0], width, height, out, 0, 1);
            BitmapUtils.unpackPlane(yuv420888planes[1], width, height, out, imageSize + 1, 2);
            BitmapUtils.unpackPlane(yuv420888planes[2], width, height, out, imageSize, 2);
        }
        return out;
    }

    private static boolean areUVPlanesNV21(Image.Plane[] planes, int width, int height) {
        int imageSize = width * height;
        ByteBuffer uBuffer = planes[1].getBuffer();
        ByteBuffer vBuffer = planes[2].getBuffer();
        int vBufferPosition = vBuffer.position();
        int uBufferLimit = uBuffer.limit();
        vBuffer.position(vBufferPosition + 1);
        uBuffer.limit(uBufferLimit - 1);
        boolean areNV21 = vBuffer.remaining() == 2 * imageSize / 4 - 2 && vBuffer.compareTo(uBuffer) == 0;
        vBuffer.position(vBufferPosition);
        uBuffer.limit(uBufferLimit);
        return areNV21;
    }

    private static void unpackPlane(Image.Plane plane, int width, int height, byte[] out, int offset, int pixelStride) {
        ByteBuffer buffer = plane.getBuffer();
        buffer.rewind();
        int numRow = (buffer.limit() + plane.getRowStride() - 1) / plane.getRowStride();
        if (numRow == 0) {
            return;
        }
        int scaleFactor = height / numRow;
        int numCol = width / scaleFactor;
        int outputPos = offset;
        int rowStart = 0;
        for (int row = 0; row < numRow; ++row) {
            int inputPos = rowStart;
            for (int col = 0; col < numCol; ++col) {
                out[outputPos] = buffer.get(inputPos);
                outputPos += pixelStride;
                inputPos += plane.getPixelStride();
            }
            rowStart += plane.getRowStride();
        }
    }
}

