/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.app.ComponentActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;
import com.king.camera.scan.AnalyzeResult;
import com.king.camera.scan.CameraScan;
import com.king.camera.scan.analyze.Analyzer;
import com.king.camera.scan.config.CameraConfig;
import com.king.camera.scan.config.CameraConfigFactory;
import com.king.camera.scan.manager.AmbientLightManager;
import com.king.camera.scan.manager.BeepManager;
import com.king.camera.scan.util.LogUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class BaseCameraScan<T>
extends CameraScan<T> {
    private static final int HOVER_TAP_TIMEOUT = 150;
    private static final int HOVER_TAP_SLOP = 20;
    private static final float ZOOM_STEP_SIZE = 0.1f;
    private final Context mContext;
    private final LifecycleOwner mLifecycleOwner;
    private final PreviewView mPreviewView;
    private ListenableFuture<ProcessCameraProvider> mCameraProviderFuture;
    private Camera mCamera;
    private CameraConfig mCameraConfig;
    private Analyzer<T> mAnalyzer;
    private volatile boolean isAnalyze = true;
    private volatile boolean isAutoStopAnalyze = true;
    private volatile boolean isAnalyzeResult;
    private View flashlightView;
    private MutableLiveData<AnalyzeResult<T>> mResultLiveData;
    private CameraScan.OnScanResultCallback<T> mOnScanResultCallback;
    private Analyzer.OnAnalyzeListener<T> mOnAnalyzeListener;
    private BeepManager mBeepManager;
    private AmbientLightManager mAmbientLightManager;
    private long mLastHoveTapTime;
    private boolean isClickTap;
    private float mDownX;
    private float mDownY;
    private final ScaleGestureDetector.OnScaleGestureListener mOnScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            ZoomState zoomState = BaseCameraScan.this.getZoomState();
            if (zoomState != null) {
                float ratio = zoomState.getZoomRatio();
                BaseCameraScan.this.zoomTo(ratio * scale);
                return true;
            }
            return false;
        }
    };

    public BaseCameraScan(@NonNull ComponentActivity activity, @NonNull PreviewView previewView) {
        this((Context)activity, (LifecycleOwner)activity, previewView);
    }

    public BaseCameraScan(@NonNull Fragment fragment, @NonNull PreviewView previewView) {
        this(fragment.getContext(), fragment.getViewLifecycleOwner(), previewView);
    }

    public BaseCameraScan(@NonNull Context context, @NonNull LifecycleOwner lifecycleOwner, @NonNull PreviewView previewView) {
        this.mContext = context;
        this.mLifecycleOwner = lifecycleOwner;
        this.mPreviewView = previewView;
        this.initData();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initData() {
        this.mResultLiveData = new MutableLiveData();
        this.mResultLiveData.observe(this.mLifecycleOwner, result -> {
            if (result != null) {
                this.handleAnalyzeResult((AnalyzeResult<T>)result);
            } else if (this.mOnScanResultCallback != null) {
                this.mOnScanResultCallback.onScanResultFailure();
            }
        });
        this.mOnAnalyzeListener = new Analyzer.OnAnalyzeListener<T>(){

            @Override
            public void onSuccess(@NonNull AnalyzeResult<T> result) {
                BaseCameraScan.this.mResultLiveData.postValue(result);
            }

            @Override
            public void onFailure(@Nullable Exception e) {
                BaseCameraScan.this.mResultLiveData.postValue(null);
            }
        };
        ScaleGestureDetector scaleGestureDetector = new ScaleGestureDetector(this.mContext, this.mOnScaleGestureListener);
        this.mPreviewView.setOnTouchListener((v, event) -> {
            this.handlePreviewViewClickTap(event);
            if (this.isNeedTouchZoom()) {
                return scaleGestureDetector.onTouchEvent(event);
            }
            return false;
        });
        this.mBeepManager = new BeepManager(this.mContext.getApplicationContext());
        this.mAmbientLightManager = new AmbientLightManager(this.mContext.getApplicationContext());
        this.mAmbientLightManager.register();
        this.mAmbientLightManager.setOnLightSensorEventListener((dark, lightLux) -> {
            if (this.flashlightView != null) {
                if (dark) {
                    if (this.flashlightView.getVisibility() != 0) {
                        this.flashlightView.setVisibility(0);
                        this.flashlightView.setSelected(this.isTorchEnabled());
                    }
                } else if (this.flashlightView.getVisibility() == 0 && !this.isTorchEnabled()) {
                    this.flashlightView.setVisibility(4);
                    this.flashlightView.setSelected(false);
                }
            }
        });
    }

    private void handlePreviewViewClickTap(MotionEvent event) {
        if (event.getPointerCount() == 1) {
            switch (event.getAction()) {
                case 0: {
                    this.isClickTap = true;
                    this.mDownX = event.getX();
                    this.mDownY = event.getY();
                    this.mLastHoveTapTime = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    this.isClickTap = this.distance(this.mDownX, this.mDownY, event.getX(), event.getY()) < 20.0f;
                    break;
                }
                case 1: {
                    if (!this.isClickTap || this.mLastHoveTapTime + 150L <= System.currentTimeMillis()) break;
                    this.startFocusAndMetering(event.getX(), event.getY());
                }
            }
        }
    }

    private float distance(float aX, float aY, float bX, float bY) {
        float xDiff = aX - bX;
        float yDiff = aY - bY;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    private void startFocusAndMetering(float x, float y) {
        if (this.mCamera != null) {
            MeteringPoint point = this.mPreviewView.getMeteringPointFactory().createPoint(x, y);
            FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point).build();
            if (this.mCamera.getCameraInfo().isFocusMeteringSupported(focusMeteringAction)) {
                this.mCamera.getCameraControl().startFocusAndMetering(focusMeteringAction);
                LogUtils.d("startFocusAndMetering: " + x + "," + y);
            }
        }
    }

    @Override
    public CameraScan<T> setCameraConfig(CameraConfig cameraConfig) {
        if (cameraConfig != null) {
            this.mCameraConfig = cameraConfig;
        }
        return this;
    }

    @Override
    public void startCamera() {
        if (this.mCameraConfig == null) {
            this.mCameraConfig = CameraConfigFactory.createDefaultCameraConfig(this.mContext, -1);
        }
        this.mCameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.mContext);
        this.mCameraProviderFuture.addListener(() -> {
            try {
                CameraSelector cameraSelector = this.mCameraConfig.options(new CameraSelector.Builder());
                Preview preview = this.mCameraConfig.options(new Preview.Builder());
                preview.setSurfaceProvider(this.mPreviewView.getSurfaceProvider());
                ImageAnalysis imageAnalysis = this.mCameraConfig.options(new ImageAnalysis.Builder().setOutputImageFormat(1).setBackpressureStrategy(0));
                imageAnalysis.setAnalyzer((Executor)Executors.newSingleThreadExecutor(), image -> {
                    if (this.isAnalyze && !this.isAnalyzeResult && this.mAnalyzer != null) {
                        this.mAnalyzer.analyze(image, this.mOnAnalyzeListener);
                    }
                    image.close();
                });
                if (this.mCamera != null) {
                    ((ProcessCameraProvider)this.mCameraProviderFuture.get()).unbindAll();
                }
                this.mCamera = ((ProcessCameraProvider)this.mCameraProviderFuture.get()).bindToLifecycle(this.mLifecycleOwner, cameraSelector, new UseCase[]{preview, imageAnalysis});
                LogUtils.d("Preview resolution: " + preview.getResolutionInfo().getResolution());
                LogUtils.d("ImageAnalysis resolution: " + imageAnalysis.getResolutionInfo().getResolution());
            }
            catch (Exception e) {
                LogUtils.e(e);
            }
        }, ContextCompat.getMainExecutor((Context)this.mContext));
    }

    private synchronized void handleAnalyzeResult(AnalyzeResult<T> result) {
        if (this.isAnalyzeResult || !this.isAnalyze) {
            return;
        }
        this.isAnalyzeResult = true;
        if (this.isAutoStopAnalyze) {
            this.isAnalyze = false;
        }
        if (this.mBeepManager != null) {
            this.mBeepManager.playBeepSoundAndVibrate();
        }
        if (this.mOnScanResultCallback != null) {
            this.mOnScanResultCallback.onScanResultCallback(result);
        }
        this.isAnalyzeResult = false;
    }

    @Override
    public void stopCamera() {
        if (this.mCameraProviderFuture != null) {
            try {
                ((ProcessCameraProvider)this.mCameraProviderFuture.get()).unbindAll();
            }
            catch (Exception e) {
                LogUtils.e(e);
            }
        }
    }

    @Override
    public CameraScan<T> setAnalyzeImage(boolean analyze) {
        this.isAnalyze = analyze;
        return this;
    }

    @Override
    public CameraScan<T> setAutoStopAnalyze(boolean autoStopAnalyze) {
        this.isAutoStopAnalyze = autoStopAnalyze;
        return this;
    }

    @Override
    public CameraScan<T> setAnalyzer(Analyzer<T> analyzer) {
        this.mAnalyzer = analyzer;
        return this;
    }

    @Override
    public void zoomIn() {
        float maxRatio;
        float ratio;
        ZoomState zoomState = this.getZoomState();
        if (zoomState != null && (ratio = zoomState.getZoomRatio() + 0.1f) <= (maxRatio = zoomState.getMaxZoomRatio())) {
            this.mCamera.getCameraControl().setZoomRatio(ratio);
        }
    }

    @Override
    public void zoomOut() {
        float minRatio;
        float ratio;
        ZoomState zoomState = this.getZoomState();
        if (zoomState != null && (ratio = zoomState.getZoomRatio() - 0.1f) >= (minRatio = zoomState.getMinZoomRatio())) {
            this.mCamera.getCameraControl().setZoomRatio(ratio);
        }
    }

    @Override
    public void zoomTo(float ratio) {
        ZoomState zoomState = this.getZoomState();
        if (zoomState != null) {
            float maxRatio = zoomState.getMaxZoomRatio();
            float minRatio = zoomState.getMinZoomRatio();
            float zoom = Math.max(Math.min(ratio, maxRatio), minRatio);
            this.mCamera.getCameraControl().setZoomRatio(zoom);
        }
    }

    @Override
    public void lineZoomIn() {
        float zoom;
        ZoomState zoomState = this.getZoomState();
        if (zoomState != null && (zoom = zoomState.getLinearZoom() + 0.1f) <= 1.0f) {
            this.mCamera.getCameraControl().setLinearZoom(zoom);
        }
    }

    @Override
    public void lineZoomOut() {
        float zoom;
        ZoomState zoomState = this.getZoomState();
        if (zoomState != null && (zoom = zoomState.getLinearZoom() - 0.1f) >= 0.0f) {
            this.mCamera.getCameraControl().setLinearZoom(zoom);
        }
    }

    @Override
    public void lineZoomTo(@FloatRange(from=0.0, to=1.0) float linearZoom) {
        if (this.mCamera != null) {
            this.mCamera.getCameraControl().setLinearZoom(linearZoom);
        }
    }

    @Override
    public void enableTorch(boolean torch) {
        if (this.mCamera != null && this.hasFlashUnit()) {
            this.mCamera.getCameraControl().enableTorch(torch);
        }
    }

    @Override
    public boolean isTorchEnabled() {
        if (this.mCamera != null) {
            Integer torchState = (Integer)this.mCamera.getCameraInfo().getTorchState().getValue();
            return torchState != null && torchState == 1;
        }
        return false;
    }

    @Override
    public boolean hasFlashUnit() {
        if (this.mCamera != null) {
            return this.mCamera.getCameraInfo().hasFlashUnit();
        }
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    @Override
    public CameraScan<T> setVibrate(boolean vibrate) {
        if (this.mBeepManager != null) {
            this.mBeepManager.setVibrate(vibrate);
        }
        return this;
    }

    @Override
    public CameraScan<T> setPlayBeep(boolean playBeep) {
        if (this.mBeepManager != null) {
            this.mBeepManager.setPlayBeep(playBeep);
        }
        return this;
    }

    @Override
    public CameraScan<T> setOnScanResultCallback(CameraScan.OnScanResultCallback<T> callback) {
        this.mOnScanResultCallback = callback;
        return this;
    }

    @Override
    @Nullable
    public Camera getCamera() {
        return this.mCamera;
    }

    @Nullable
    private ZoomState getZoomState() {
        if (this.mCamera != null) {
            return (ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue();
        }
        return null;
    }

    @Override
    public void release() {
        this.isAnalyze = false;
        this.flashlightView = null;
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.unregister();
        }
        if (this.mBeepManager != null) {
            this.mBeepManager.close();
        }
        this.stopCamera();
    }

    @Override
    public CameraScan<T> bindFlashlightView(@Nullable View flashlightView) {
        this.flashlightView = flashlightView;
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.setLightSensorEnabled(flashlightView != null);
        }
        return this;
    }

    @Override
    public CameraScan<T> setDarkLightLux(float lightLux) {
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.setDarkLightLux(lightLux);
        }
        return this;
    }

    @Override
    public CameraScan<T> setBrightLightLux(float lightLux) {
        if (this.mAmbientLightManager != null) {
            this.mAmbientLightManager.setBrightLightLux(lightLux);
        }
        return this;
    }
}

