/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan.config;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import com.king.camera.scan.config.AspectRatioCameraConfig;
import com.king.camera.scan.config.CameraConfig;
import com.king.camera.scan.config.ResolutionCameraConfig;

public final class CameraConfigFactory {
    private CameraConfigFactory() {
        throw new AssertionError();
    }

    public static CameraConfig createDefaultCameraConfig(Context context, final int lensFacing) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int size = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
        if (size > 720) {
            int imageQuality = 720;
            if (size > 1080) {
                imageQuality = 1080;
            }
            return new ResolutionCameraConfig(context, imageQuality){

                @Override
                @NonNull
                public CameraSelector options(@NonNull CameraSelector.Builder builder) {
                    if (lensFacing >= 0) {
                        builder.requireLensFacing(lensFacing);
                    }
                    return super.options(builder);
                }
            };
        }
        return new AspectRatioCameraConfig(context){

            @Override
            @NonNull
            public CameraSelector options(@NonNull CameraSelector.Builder builder) {
                if (lensFacing >= 0) {
                    builder.requireLensFacing(lensFacing);
                }
                return super.options(builder);
            }
        };
    }
}

