/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.ProjectHelper;
import shadow.org.apache.tools.ant.Task;

public class BindTargets
extends Task {
    private String extensionPoint;
    private final List<String> targets = new ArrayList<String>();
    private ProjectHelper.OnMissingExtensionPoint onMissingExtensionPoint;

    public void setExtensionPoint(String extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    public void setOnMissingExtensionPoint(String onMissingExtensionPoint) {
        try {
            this.onMissingExtensionPoint = ProjectHelper.OnMissingExtensionPoint.valueOf(onMissingExtensionPoint);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Invalid onMissingExtensionPoint: " + onMissingExtensionPoint);
        }
    }

    public void setOnMissingExtensionPoint(ProjectHelper.OnMissingExtensionPoint onMissingExtensionPoint) {
        this.onMissingExtensionPoint = onMissingExtensionPoint;
    }

    public void setTargets(String target) {
        String[] inputs = target.split(",");
        for (int i = 0; i < inputs.length; ++i) {
            String input = inputs[i].trim();
            if (input.length() <= 0) continue;
            this.targets.add(input);
        }
    }

    public void execute() throws BuildException {
        if (this.extensionPoint == null) {
            throw new BuildException("extensionPoint required", this.getLocation());
        }
        if (this.getOwningTarget() == null || !"".equals(this.getOwningTarget().getName())) {
            throw new BuildException("bindtargets only allowed as a top-level task");
        }
        if (this.onMissingExtensionPoint == null) {
            this.onMissingExtensionPoint = ProjectHelper.OnMissingExtensionPoint.FAIL;
        }
        ProjectHelper helper = (ProjectHelper)this.getProject().getReference("ant.projectHelper");
        Iterator<String> itTarget = this.targets.iterator();
        while (itTarget.hasNext()) {
            helper.getExtensionStack().add(new String[]{this.extensionPoint, itTarget.next(), this.onMissingExtensionPoint.name()});
        }
    }
}

