/*
 * Decompiled with CFR 0.152.
 */
package com.like;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.like.CircleView;
import com.like.DotsView;
import com.like.Icon;
import com.like.IconType;
import com.like.OnLikeListener;
import com.like.Utils;
import com.like.view.R;
import java.util.List;

public class LikeButton
extends FrameLayout
implements View.OnClickListener {
    private static final DecelerateInterpolator DECCELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final AccelerateDecelerateInterpolator ACCELERATE_DECELERATE_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private static final OvershootInterpolator OVERSHOOT_INTERPOLATOR = new OvershootInterpolator(4.0f);
    private ImageView icon;
    private DotsView dotsView;
    private CircleView circleView;
    private Icon currentIcon;
    private OnLikeListener likeListener;
    private int dotPrimaryColor;
    private int dotSecondaryColor;
    private int circleStartColor;
    private int circleEndColor;
    private int iconSize;
    private float animationScaleFactor;
    private boolean isChecked;
    private boolean isEnabled;
    private AnimatorSet animatorSet;
    private Drawable likeDrawable;
    private Drawable unLikeDrawable;

    public LikeButton(Context context) {
        this(context, null);
    }

    public LikeButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LikeButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.likeview, (ViewGroup)this, true);
        this.icon = (ImageView)this.findViewById(R.id.icon);
        this.dotsView = (DotsView)this.findViewById(R.id.dots);
        this.circleView = (CircleView)this.findViewById(R.id.circle);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.LikeButton, defStyle, 0);
        this.iconSize = array.getDimensionPixelSize(R.styleable.LikeButton_icon_size, -1);
        if (this.iconSize == -1) {
            this.iconSize = 40;
        }
        String iconType = array.getString(R.styleable.LikeButton_icon_type);
        this.likeDrawable = array.getDrawable(R.styleable.LikeButton_like_drawable);
        if (this.likeDrawable != null) {
            this.setLikeDrawable(this.likeDrawable);
        }
        this.unLikeDrawable = array.getDrawable(R.styleable.LikeButton_unlike_drawable);
        if (this.unLikeDrawable != null) {
            this.setUnlikeDrawable(this.unLikeDrawable);
        }
        if (iconType != null && !iconType.isEmpty()) {
            this.currentIcon = this.parseIconType(iconType);
        }
        this.circleStartColor = array.getColor(R.styleable.LikeButton_circle_start_color, 0);
        if (this.circleStartColor != 0) {
            this.circleView.setStartColor(this.circleStartColor);
        }
        this.circleEndColor = array.getColor(R.styleable.LikeButton_circle_end_color, 0);
        if (this.circleEndColor != 0) {
            this.circleView.setEndColor(this.circleEndColor);
        }
        this.dotPrimaryColor = array.getColor(R.styleable.LikeButton_dots_primary_color, 0);
        this.dotSecondaryColor = array.getColor(R.styleable.LikeButton_dots_secondary_color, 0);
        if (this.dotPrimaryColor != 0 && this.dotSecondaryColor != 0) {
            this.dotsView.setColors(this.dotPrimaryColor, this.dotSecondaryColor);
        }
        if (this.likeDrawable == null && this.unLikeDrawable == null) {
            if (this.currentIcon != null) {
                this.setLikeDrawableRes(this.currentIcon.getOnIconResourceId());
                this.setUnlikeDrawableRes(this.currentIcon.getOffIconResourceId());
            } else {
                this.currentIcon = this.parseIconType(IconType.Heart);
                this.setLikeDrawableRes(this.currentIcon.getOnIconResourceId());
                this.setUnlikeDrawableRes(this.currentIcon.getOffIconResourceId());
            }
        }
        this.setEnabled(array.getBoolean(R.styleable.LikeButton_enabled, true));
        Boolean status = array.getBoolean(R.styleable.LikeButton_liked, false);
        this.setAnimationScaleFactor(array.getFloat(R.styleable.LikeButton_anim_scale_factor, 3.0f));
        this.setLiked(status);
        this.setOnClickListener(this);
        array.recycle();
    }

    public void onClick(View v) {
        if (!this.isEnabled) {
            return;
        }
        this.isChecked = !this.isChecked;
        this.icon.setImageDrawable(this.isChecked ? this.likeDrawable : this.unLikeDrawable);
        if (this.likeListener != null) {
            if (this.isChecked) {
                this.likeListener.liked(this);
            } else {
                this.likeListener.unLiked(this);
            }
        }
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        if (this.isChecked) {
            this.icon.animate().cancel();
            this.icon.setScaleX(0.0f);
            this.icon.setScaleY(0.0f);
            this.circleView.setInnerCircleRadiusProgress(0.0f);
            this.circleView.setOuterCircleRadiusProgress(0.0f);
            this.dotsView.setCurrentProgress(0.0f);
            this.animatorSet = new AnimatorSet();
            ObjectAnimator outerCircleAnimator = ObjectAnimator.ofFloat((Object)((Object)this.circleView), CircleView.OUTER_CIRCLE_RADIUS_PROGRESS, (float[])new float[]{0.1f, 1.0f});
            outerCircleAnimator.setDuration(250L);
            outerCircleAnimator.setInterpolator((TimeInterpolator)DECCELERATE_INTERPOLATOR);
            ObjectAnimator innerCircleAnimator = ObjectAnimator.ofFloat((Object)((Object)this.circleView), CircleView.INNER_CIRCLE_RADIUS_PROGRESS, (float[])new float[]{0.1f, 1.0f});
            innerCircleAnimator.setDuration(200L);
            innerCircleAnimator.setStartDelay(200L);
            innerCircleAnimator.setInterpolator((TimeInterpolator)DECCELERATE_INTERPOLATOR);
            ObjectAnimator starScaleYAnimator = ObjectAnimator.ofFloat((Object)this.icon, (Property)ImageView.SCALE_Y, (float[])new float[]{0.2f, 1.0f});
            starScaleYAnimator.setDuration(350L);
            starScaleYAnimator.setStartDelay(250L);
            starScaleYAnimator.setInterpolator((TimeInterpolator)OVERSHOOT_INTERPOLATOR);
            ObjectAnimator starScaleXAnimator = ObjectAnimator.ofFloat((Object)this.icon, (Property)ImageView.SCALE_X, (float[])new float[]{0.2f, 1.0f});
            starScaleXAnimator.setDuration(350L);
            starScaleXAnimator.setStartDelay(250L);
            starScaleXAnimator.setInterpolator((TimeInterpolator)OVERSHOOT_INTERPOLATOR);
            ObjectAnimator dotsAnimator = ObjectAnimator.ofFloat((Object)((Object)this.dotsView), DotsView.DOTS_PROGRESS, (float[])new float[]{0.0f, 1.0f});
            dotsAnimator.setDuration(900L);
            dotsAnimator.setStartDelay(50L);
            dotsAnimator.setInterpolator((TimeInterpolator)ACCELERATE_DECELERATE_INTERPOLATOR);
            this.animatorSet.playTogether(new Animator[]{outerCircleAnimator, innerCircleAnimator, starScaleYAnimator, starScaleXAnimator, dotsAnimator});
            this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    LikeButton.this.circleView.setInnerCircleRadiusProgress(0.0f);
                    LikeButton.this.circleView.setOuterCircleRadiusProgress(0.0f);
                    LikeButton.this.dotsView.setCurrentProgress(0.0f);
                    LikeButton.this.icon.setScaleX(1.0f);
                    LikeButton.this.icon.setScaleY(1.0f);
                }
            });
            this.animatorSet.start();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.icon.animate().scaleX(0.7f).scaleY(0.7f).setDuration(150L).setInterpolator((TimeInterpolator)DECCELERATE_INTERPOLATOR);
                this.setPressed(true);
                break;
            }
            case 2: {
                boolean isInside;
                float x = event.getX();
                float y = event.getY();
                boolean bl = isInside = x > 0.0f && x < (float)this.getWidth() && y > 0.0f && y < (float)this.getHeight();
                if (this.isPressed() == isInside) break;
                this.setPressed(isInside);
                break;
            }
            case 1: {
                this.icon.animate().scaleX(1.0f).scaleY(1.0f).setInterpolator((TimeInterpolator)DECCELERATE_INTERPOLATOR);
                if (!this.isPressed()) break;
                this.performClick();
                this.setPressed(false);
            }
        }
        return true;
    }

    public void setLikeDrawableRes(@DrawableRes int resId) {
        this.likeDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)resId);
        if (this.iconSize != 0) {
            this.likeDrawable = Utils.resizeDrawable(this.getContext(), this.likeDrawable, this.iconSize, this.iconSize);
        }
    }

    public void setLikeDrawable(Drawable likeDrawable) {
        this.likeDrawable = likeDrawable;
        if (this.iconSize != 0) {
            this.likeDrawable = Utils.resizeDrawable(this.getContext(), likeDrawable, this.iconSize, this.iconSize);
        }
    }

    public void setUnlikeDrawableRes(@DrawableRes int resId) {
        this.unLikeDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)resId);
        if (this.iconSize != 0) {
            this.unLikeDrawable = Utils.resizeDrawable(this.getContext(), this.unLikeDrawable, this.iconSize, this.iconSize);
        }
        this.icon.setImageDrawable(this.unLikeDrawable);
    }

    public void setUnlikeDrawable(Drawable unLikeDrawable) {
        this.unLikeDrawable = unLikeDrawable;
        if (this.iconSize != 0) {
            this.unLikeDrawable = Utils.resizeDrawable(this.getContext(), unLikeDrawable, this.iconSize, this.iconSize);
        }
        this.icon.setImageDrawable(unLikeDrawable);
    }

    public void setIcon(IconType currentIconType) {
        this.currentIcon = this.parseIconType(currentIconType);
        this.setLikeDrawableRes(this.currentIcon.getOnIconResourceId());
        this.setUnlikeDrawableRes(this.currentIcon.getOffIconResourceId());
    }

    public void setIconSizeDp(int iconSize) {
        this.setIconSizePx((int)Utils.dipToPixels(this.getContext(), iconSize));
    }

    public void setIconSizePx(int iconSize) {
        this.iconSize = iconSize;
        this.setEffectsViewSize();
        this.unLikeDrawable = Utils.resizeDrawable(this.getContext(), this.unLikeDrawable, iconSize, iconSize);
        this.likeDrawable = Utils.resizeDrawable(this.getContext(), this.likeDrawable, iconSize, iconSize);
    }

    private Icon parseIconType(String iconType) {
        List<Icon> icons = Utils.getIcons();
        for (Icon icon : icons) {
            if (!icon.getIconType().name().toLowerCase().equals(iconType.toLowerCase())) continue;
            return icon;
        }
        throw new IllegalArgumentException("Correct icon type not specified.");
    }

    private Icon parseIconType(IconType iconType) {
        List<Icon> icons = Utils.getIcons();
        for (Icon icon : icons) {
            if (!icon.getIconType().equals((Object)iconType)) continue;
            return icon;
        }
        throw new IllegalArgumentException("Correct icon type not specified.");
    }

    public void setOnLikeListener(OnLikeListener likeListener) {
        this.likeListener = likeListener;
    }

    public void setExplodingDotColorsRes(@ColorRes int primaryColor, @ColorRes int secondaryColor) {
        this.dotsView.setColors(ContextCompat.getColor((Context)this.getContext(), (int)primaryColor), ContextCompat.getColor((Context)this.getContext(), (int)secondaryColor));
    }

    public void setCircleStartColorRes(@ColorRes int circleStartColor) {
        this.circleStartColor = circleStartColor;
        this.circleView.setStartColor(ContextCompat.getColor((Context)this.getContext(), (int)circleStartColor));
    }

    public void setCircleEndColorRes(@ColorRes int circleEndColor) {
        this.circleEndColor = circleEndColor;
        this.circleView.setEndColor(ContextCompat.getColor((Context)this.getContext(), (int)circleEndColor));
    }

    private void setEffectsViewSize() {
        if (this.iconSize != 0) {
            this.dotsView.setSize((int)((float)this.iconSize * this.animationScaleFactor), (int)((float)this.iconSize * this.animationScaleFactor));
            this.circleView.setSize(this.iconSize, this.iconSize);
        }
    }

    public void setLiked(Boolean status) {
        if (status.booleanValue()) {
            this.isChecked = true;
            this.icon.setImageDrawable(this.likeDrawable);
        } else {
            this.isChecked = false;
            this.icon.setImageDrawable(this.unLikeDrawable);
        }
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void setAnimationScaleFactor(float animationScaleFactor) {
        this.animationScaleFactor = animationScaleFactor;
        this.setEffectsViewSize();
    }
}

