/*
 * Decompiled with CFR 0.152.
 */
package com.like;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.like.Icon;
import com.like.IconType;
import com.like.view.R;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static double mapValueFromRangeToRange(double value, double fromLow, double fromHigh, double toLow, double toHigh) {
        return toLow + (value - fromLow) / (fromHigh - fromLow) * (toHigh - toLow);
    }

    public static double clamp(double value, double low, double high) {
        return Math.min(Math.max(value, low), high);
    }

    public static List<Icon> getIcons() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        icons.add(new Icon(R.drawable.heart_on, R.drawable.heart_off, IconType.Heart));
        icons.add(new Icon(R.drawable.star_on, R.drawable.star_off, IconType.Star));
        icons.add(new Icon(R.drawable.thumb_on, R.drawable.thumb_off, IconType.Thumb));
        return icons;
    }

    public static Drawable resizeDrawable(Context context, Drawable drawable2, int width, int height) {
        Bitmap bitmap = Utils.getBitmap(drawable2, width, height);
        return new BitmapDrawable(context.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true));
    }

    public static Bitmap getBitmap(Drawable drawable2, int width, int height) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        if (drawable2 instanceof VectorDrawableCompat) {
            return Utils.getBitmap((VectorDrawableCompat)drawable2, width, height);
        }
        if (drawable2 instanceof VectorDrawable) {
            return Utils.getBitmap((VectorDrawable)drawable2, width, height);
        }
        throw new IllegalArgumentException("Unsupported drawable type");
    }

    @TargetApi(value=21)
    private static Bitmap getBitmap(VectorDrawable vectorDrawable, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    private static Bitmap getBitmap(VectorDrawableCompat vectorDrawable, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    public static float dipToPixels(Context context, float dipValue) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)dipValue, (DisplayMetrics)metrics);
    }
}

