/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$processor$.meta.$OkJsonMirrors;

public class $OkNamedMirror
implements $OkJsonMirrors.OkNamed {
    public static final String QUALIFIED_NAME = "com.squareup.moshi.Json";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.meta.OkJsonMirrors.$OkNamed";
    private final AnnotationMirror annotationMirror;
    private final String name;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Json";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$OkNamedMirror> find(Element element) {
        return $OkNamedMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$OkNamedMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $OkNamedMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$OkNamedMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $OkNamedMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $OkNamedMirror from(TypeElement element) {
        return new $OkNamedMirror(element);
    }

    public static $Optional<$OkNamedMirror> from(AnnotationMirror mirror) {
        return $OkNamedMirror.find(Collections.singleton(mirror));
    }

    private $OkNamedMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        String name = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"name".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Json");
            }
            NameExtractor nameExtractor$ = new NameExtractor();
            annotationValue$.accept(nameExtractor$, null);
            name = nameExtractor$.get();
        }
        this.name = $Preconditions.checkNotNull(name, "default attribute 'name'");
    }

    private $OkNamedMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String name = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"name".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'name' attribute of @Json");
            }
            NameExtractor nameExtractor$ = new NameExtractor();
            annotationValue$.accept(nameExtractor$, null);
            name = nameExtractor$.get();
        }
        this.name = $Preconditions.checkNotNull(name, "value for 'name'");
    }

    @Override
    public String name() {
        return this.name;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return $OkJsonMirrors.OkNamed.class;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        return h2 += 127 * "name".hashCode() ^ this.name.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $OkNamedMirror) {
            $OkNamedMirror otherMirror = ($OkNamedMirror)other;
            return this.name.equals(otherMirror.name);
        }
        return false;
    }

    @Override
    public String toString() {
        return "OkNamedMirror:" + this.annotationMirror;
    }

    private static class NameExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NameExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'name' in @com.squareup.moshi.Json");
        }
    }
}

