/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.immutables.value.internal.$generator$.$Naming;
import org.immutables.value.internal.$guava$.base.$CaseFormat;
import org.immutables.value.internal.$guava$.base.$Joiner;
import org.immutables.value.internal.$guava$.base.$Splitter;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Maps;

interface $Depluralizer {
    public static final $Depluralizer NONE = new $Depluralizer(){

        @Override
        public String depluralize(String name) {
            return name;
        }
    };

    public String depluralize(String var1);

    public static class DictionaryAidedDepluralizer
    implements $Depluralizer {
        private final $ImmutableMap<String, String> dictionary;
        private static final $Naming NAMING_IES_PLURAL = $Naming.from("*ies");
        private static final $Naming NAMING_S_PLURAL = $Naming.from("*s");
        private static final $Splitter SPLITTER_UNDERSCORE = $Splitter.on('_').omitEmptyStrings().trimResults();
        private static final $Joiner JOINER_UNDERSCORE = $Joiner.on('_');

        DictionaryAidedDepluralizer(String[] exceptions) {
            HashMap<String, String> map = $Maps.newHashMapWithExpectedSize(exceptions.length);
            $Splitter splitter = $Splitter.on(':');
            for (String s2 : exceptions) {
                List<String> parts = splitter.splitToList(s2.toLowerCase());
                if (parts.size() == 1) {
                    map.put(parts.get(0), parts.get(0));
                    continue;
                }
                if (parts.size() != 2) continue;
                map.put(parts.get(1), parts.get(0));
            }
            this.dictionary = $ImmutableMap.copyOf(map);
        }

        @Override
        public String depluralize(String name) {
            LinkedList<String> parts = $Lists.newLinkedList(DictionaryAidedDepluralizer.splitCamelCase(name));
            String plural = parts.removeLast();
            String singular = this.dictionary.get(plural);
            if (singular != null) {
                parts.addLast(singular);
                return DictionaryAidedDepluralizer.joinCamelCase(parts);
            }
            String detected = NAMING_IES_PLURAL.detect(name);
            if (!detected.isEmpty()) {
                return detected + "y";
            }
            detected = NAMING_S_PLURAL.detect(name);
            if (!detected.isEmpty()) {
                return detected;
            }
            return name;
        }

        private static String joinCamelCase(Iterable<String> parts) {
            return $CaseFormat.LOWER_UNDERSCORE.to($CaseFormat.LOWER_CAMEL, JOINER_UNDERSCORE.join(parts));
        }

        private static Iterable<String> splitCamelCase(String name) {
            return SPLITTER_UNDERSCORE.split($CaseFormat.LOWER_CAMEL.to($CaseFormat.LOWER_UNDERSCORE, name));
        }
    }
}

