/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;

public class $CriteriaRepositoryMirror
implements .processor..CriteriaMirrors.CriteriaRepository {
    public static final String QUALIFIED_NAME = "org.immutables.criteria.Criteria.Repository";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.meta.CriteriaMirrors.$CriteriaRepository";
    private final AnnotationMirror annotationMirror;
    private final TypeMirror[] facets;
    private final String[] facetsName;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Repository";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$CriteriaRepositoryMirror> find(Element element) {
        return $CriteriaRepositoryMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$CriteriaRepositoryMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $CriteriaRepositoryMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$CriteriaRepositoryMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $CriteriaRepositoryMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $CriteriaRepositoryMirror from(TypeElement element) {
        return new $CriteriaRepositoryMirror(element);
    }

    public static $Optional<$CriteriaRepositoryMirror> from(AnnotationMirror mirror) {
        return $CriteriaRepositoryMirror.find(Collections.singleton(mirror));
    }

    private $CriteriaRepositoryMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        TypeMirror[] facets = null;
        String[] facetsName = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"facets".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Repository");
            }
            FacetsExtractor facetsExtractor$ = new FacetsExtractor();
            annotationValue$.accept(facetsExtractor$, null);
            facets = facetsExtractor$.get();
            facetsName = facetsExtractor$.name();
        }
        this.facets = $Preconditions.checkNotNull(facets, "default attribute 'facets'");
        this.facetsName = $Preconditions.checkNotNull(facetsName, "default attribute 'facets'");
    }

    private $CriteriaRepositoryMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        TypeMirror[] facets = null;
        String[] facetsName = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"facets".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'facets' attribute of @Repository");
            }
            FacetsExtractor facetsExtractor$ = new FacetsExtractor();
            annotationValue$.accept(facetsExtractor$, null);
            facets = facetsExtractor$.get();
            facetsName = facetsExtractor$.name();
        }
        this.facets = $Preconditions.checkNotNull(facets, "value for 'facets'");
        this.facetsName = $Preconditions.checkNotNull(facetsName, "Value for 'facets'");
    }

    public String[] facetsName() {
        return (String[])this.facetsName.clone();
    }

    public TypeMirror[] facetsMirror() {
        return (TypeMirror[])this.facets.clone();
    }

    @Override
    @Deprecated
    public Class<?>[] facets() {
        throw new UnsupportedOperationException("Use 'facetsMirror()' or 'facetsName()'");
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return .processor..CriteriaMirrors.CriteriaRepository.class;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        return h2 += 127 * "facets".hashCode() ^ Arrays.hashCode(this.facetsName);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $CriteriaRepositoryMirror) {
            $CriteriaRepositoryMirror otherMirror = ($CriteriaRepositoryMirror)other;
            return Arrays.equals(this.facetsName, otherMirror.facetsName);
        }
        return false;
    }

    @Override
    public String toString() {
        return "CriteriaRepositoryMirror:" + this.annotationMirror;
    }

    private static class FacetsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private FacetsExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'facets' in @org.immutables.criteria.Criteria.Repository");
        }
    }
}

