/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.primitives.Ints;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.TransformationExampleInput", generator="Immutables")
@Immutable
public final class ImmutableTransformationExampleInput
implements Plugin.TransformationExampleInput {
    @Nullable
    private final String config;
    private final ImmutableList<Integer> inputEmphasizeLines;
    @Nullable
    private final String inputJson;
    private final ImmutableList<Integer> outputEmphasizeLines;
    @Nullable
    private final String outputJson;
    private final Plugin.TransformationExample example;

    private ImmutableTransformationExampleInput(@Nullable String config, ImmutableList<Integer> inputEmphasizeLines, @Nullable String inputJson, ImmutableList<Integer> outputEmphasizeLines, @Nullable String outputJson, Plugin.TransformationExample example) {
        this.config = config;
        this.inputEmphasizeLines = inputEmphasizeLines;
        this.inputJson = inputJson;
        this.outputEmphasizeLines = outputEmphasizeLines;
        this.outputJson = outputJson;
        this.example = example;
    }

    @Override
    @Nullable
    public String getConfig() {
        return this.config;
    }

    public ImmutableList<Integer> getInputEmphasizeLines() {
        return this.inputEmphasizeLines;
    }

    @Override
    @Nullable
    public String getInputJson() {
        return this.inputJson;
    }

    public ImmutableList<Integer> getOutputEmphasizeLines() {
        return this.outputEmphasizeLines;
    }

    @Override
    @Nullable
    public String getOutputJson() {
        return this.outputJson;
    }

    @Override
    public Plugin.TransformationExample getExample() {
        return this.example;
    }

    public final ImmutableTransformationExampleInput withConfig(@Nullable String value) {
        if (Objects.equals(this.config, value)) {
            return this;
        }
        return new ImmutableTransformationExampleInput(value, this.inputEmphasizeLines, this.inputJson, this.outputEmphasizeLines, this.outputJson, this.example);
    }

    public final ImmutableTransformationExampleInput withInputEmphasizeLines(int ... elements) {
        ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
        return new ImmutableTransformationExampleInput(this.config, newValue, this.inputJson, this.outputEmphasizeLines, this.outputJson, this.example);
    }

    public final ImmutableTransformationExampleInput withInputEmphasizeLines(Iterable<Integer> elements) {
        if (this.inputEmphasizeLines == elements) {
            return this;
        }
        ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransformationExampleInput(this.config, newValue, this.inputJson, this.outputEmphasizeLines, this.outputJson, this.example);
    }

    public final ImmutableTransformationExampleInput withInputJson(@Nullable String value) {
        if (Objects.equals(this.inputJson, value)) {
            return this;
        }
        return new ImmutableTransformationExampleInput(this.config, this.inputEmphasizeLines, value, this.outputEmphasizeLines, this.outputJson, this.example);
    }

    public final ImmutableTransformationExampleInput withOutputEmphasizeLines(int ... elements) {
        ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
        return new ImmutableTransformationExampleInput(this.config, this.inputEmphasizeLines, this.inputJson, newValue, this.outputJson, this.example);
    }

    public final ImmutableTransformationExampleInput withOutputEmphasizeLines(Iterable<Integer> elements) {
        if (this.outputEmphasizeLines == elements) {
            return this;
        }
        ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransformationExampleInput(this.config, this.inputEmphasizeLines, this.inputJson, newValue, this.outputJson, this.example);
    }

    public final ImmutableTransformationExampleInput withOutputJson(@Nullable String value) {
        if (Objects.equals(this.outputJson, value)) {
            return this;
        }
        return new ImmutableTransformationExampleInput(this.config, this.inputEmphasizeLines, this.inputJson, this.outputEmphasizeLines, value, this.example);
    }

    public final ImmutableTransformationExampleInput withExample(Plugin.TransformationExample value) {
        if (this.example == value) {
            return this;
        }
        Plugin.TransformationExample newValue = Objects.requireNonNull(value, "example");
        return new ImmutableTransformationExampleInput(this.config, this.inputEmphasizeLines, this.inputJson, this.outputEmphasizeLines, this.outputJson, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransformationExampleInput && this.equalTo((ImmutableTransformationExampleInput)another);
    }

    private boolean equalTo(ImmutableTransformationExampleInput another) {
        return Objects.equals(this.config, another.config) && this.inputEmphasizeLines.equals(another.inputEmphasizeLines) && Objects.equals(this.inputJson, another.inputJson) && this.outputEmphasizeLines.equals(another.outputEmphasizeLines) && Objects.equals(this.outputJson, another.outputJson) && this.example.equals(another.example);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.config);
        h2 += (h2 << 5) + this.inputEmphasizeLines.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.inputJson);
        h2 += (h2 << 5) + this.outputEmphasizeLines.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.outputJson);
        h2 += (h2 << 5) + this.example.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransformationExampleInput").omitNullValues().add("config", this.config).add("inputEmphasizeLines", this.inputEmphasizeLines).add("inputJson", this.inputJson).add("outputEmphasizeLines", this.outputEmphasizeLines).add("outputJson", this.outputJson).add("example", this.example).toString();
    }

    public static ImmutableTransformationExampleInput copyOf(Plugin.TransformationExampleInput instance) {
        if (instance instanceof ImmutableTransformationExampleInput) {
            return (ImmutableTransformationExampleInput)instance;
        }
        return ImmutableTransformationExampleInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.TransformationExampleInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXAMPLE = 1L;
        private long initBits = 1L;
        @Nullable
        private String config;
        private ImmutableList.Builder<Integer> inputEmphasizeLines = ImmutableList.builder();
        @Nullable
        private String inputJson;
        private ImmutableList.Builder<Integer> outputEmphasizeLines = ImmutableList.builder();
        @Nullable
        private String outputJson;
        @Nullable
        private Plugin.TransformationExample example;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.TransformationExampleInput instance) {
            Objects.requireNonNull(instance, "instance");
            String configValue = instance.getConfig();
            if (configValue != null) {
                this.config(configValue);
            }
            this.addAllInputEmphasizeLines(instance.getInputEmphasizeLines());
            String inputJsonValue = instance.getInputJson();
            if (inputJsonValue != null) {
                this.inputJson(inputJsonValue);
            }
            this.addAllOutputEmphasizeLines(instance.getOutputEmphasizeLines());
            String outputJsonValue = instance.getOutputJson();
            if (outputJsonValue != null) {
                this.outputJson(outputJsonValue);
            }
            this.example(instance.getExample());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(@Nullable String config) {
            this.config = config;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInputEmphasizeLines(int element) {
            this.inputEmphasizeLines.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInputEmphasizeLines(int ... elements) {
            this.inputEmphasizeLines.addAll(Ints.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inputEmphasizeLines(Iterable<Integer> elements) {
            this.inputEmphasizeLines = ImmutableList.builder();
            return this.addAllInputEmphasizeLines(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInputEmphasizeLines(Iterable<Integer> elements) {
            this.inputEmphasizeLines.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inputJson(@Nullable String inputJson) {
            this.inputJson = inputJson;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOutputEmphasizeLines(int element) {
            this.outputEmphasizeLines.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOutputEmphasizeLines(int ... elements) {
            this.outputEmphasizeLines.addAll(Ints.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputEmphasizeLines(Iterable<Integer> elements) {
            this.outputEmphasizeLines = ImmutableList.builder();
            return this.addAllOutputEmphasizeLines(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOutputEmphasizeLines(Iterable<Integer> elements) {
            this.outputEmphasizeLines.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputJson(@Nullable String outputJson) {
            this.outputJson = outputJson;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder example(Plugin.TransformationExample example) {
            this.example = Objects.requireNonNull(example, "example");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTransformationExampleInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransformationExampleInput(this.config, (ImmutableList)this.inputEmphasizeLines.build(), this.inputJson, (ImmutableList)this.outputEmphasizeLines.build(), this.outputJson, this.example);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("example");
            }
            return "Cannot build TransformationExampleInput, some of required attributes are not set " + attributes;
        }
    }
}

