/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.collect.ImmutableList;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.Group", generator="Immutables")
@Immutable
public final class ImmutableGroup
implements Plugin.Group {
    private final String name;
    private final ImmutableList<Plugin.Item> items;

    private ImmutableGroup(String name, ImmutableList<Plugin.Item> items) {
        this.name = name;
        this.items = items;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<Plugin.Item> getItems() {
        return this.items;
    }

    public final ImmutableGroup withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableGroup(newValue, this.items);
    }

    public final ImmutableGroup withItems(Plugin.Item ... elements) {
        ImmutableList<Plugin.Item> newValue = ImmutableList.copyOf(elements);
        return new ImmutableGroup(this.name, newValue);
    }

    public final ImmutableGroup withItems(Iterable<? extends Plugin.Item> elements) {
        if (this.items == elements) {
            return this;
        }
        ImmutableList<Plugin.Item> newValue = ImmutableList.copyOf(elements);
        return new ImmutableGroup(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroup && this.equalTo((ImmutableGroup)another);
    }

    private boolean equalTo(ImmutableGroup another) {
        return this.name.equals(another.name) && this.items.equals(another.items);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.items.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Group").omitNullValues().add("name", this.name).add("items", this.items).toString();
    }

    public static ImmutableGroup copyOf(Plugin.Group instance) {
        if (instance instanceof ImmutableGroup) {
            return (ImmutableGroup)instance;
        }
        return ImmutableGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.Group", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableList.Builder<Plugin.Item> items = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Group instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllItems(instance.getItems());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(Plugin.Item element) {
            this.items.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(Plugin.Item ... elements) {
            this.items.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder items(Iterable<? extends Plugin.Item> elements) {
            this.items = ImmutableList.builder();
            return this.addAllItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllItems(Iterable<? extends Plugin.Item> elements) {
            this.items.addAll(elements);
            return this;
        }

        public ImmutableGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroup(this.name, (ImmutableList)this.items.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Group, some of required attributes are not set " + attributes;
        }
    }
}

