/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.template;

import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.WrappingTemplateModel;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;

class ConnectTemplateHashModel
extends WrappingTemplateModel
implements TemplateHashModel {
    final ConnectRecord connectRecord;
    final Struct struct;

    ConnectTemplateHashModel(ConnectRecord connectRecord, Struct struct) {
        this.connectRecord = connectRecord;
        this.struct = struct;
    }

    @Override
    public TemplateModel get(String s2) throws TemplateModelException {
        Object value = null;
        if ("topic".equals(s2)) {
            value = this.connectRecord.topic();
        } else if ("partition".equals(s2)) {
            value = this.connectRecord.kafkaPartition();
        } else if (null != this.struct.schema().field(s2)) {
            value = this.struct.get(s2);
        }
        if (null == value) {
            return TemplateModel.NOTHING;
        }
        return this.wrap(value);
    }

    @Override
    public boolean isEmpty() throws TemplateModelException {
        return false;
    }
}

