/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Time;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.core.JsonParser;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.DeserializationContext;
import shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import shaded.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.module.SimpleModule;

public class TimeSerializationModule
extends SimpleModule {
    public TimeSerializationModule() {
        this.addSerializer(Time.class, new Serializer());
        this.addDeserializer(Time.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<Time> {
        Deserializer() {
        }

        @Override
        public Time deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            final Storage storage = jsonParser.readValueAs(Storage.class);
            return new Time(){

                public void waitObject(Object o, Supplier<Boolean> supplier, long l) throws InterruptedException {
                }

                public long milliseconds() {
                    return storage.milliseconds;
                }

                public long hiResClockMs() {
                    return storage.hiResClockMs;
                }

                public long nanoseconds() {
                    return storage.nanoseconds;
                }

                public void sleep(long l) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
        }
    }

    static class Serializer
    extends JsonSerializer<Time> {
        Serializer() {
        }

        @Override
        public void serialize(Time time, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            Storage storage = new Storage(time);
            jsonGenerator.writeObject(storage);
        }
    }

    public static class Storage {
        public long milliseconds;
        public long nanoseconds;
        public long hiResClockMs;

        public Storage() {
        }

        public Storage(Time time) {
            this.milliseconds = time.milliseconds();
            this.nanoseconds = time.nanoseconds();
            this.hiResClockMs = time.hiResClockMs();
        }
    }
}

