/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.github.jcustenborder.kafka.connect.utils.jackson.ValueHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.SinkRecord;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.core.JsonParser;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.DeserializationContext;
import shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import shaded.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.module.SimpleModule;

public class SinkRecordSerializationModule
extends SimpleModule {
    public SinkRecordSerializationModule() {
        this.addSerializer(SinkRecord.class, new Serializer());
        this.addDeserializer(SinkRecord.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<SinkRecord> {
        Deserializer() {
        }

        @Override
        public SinkRecord deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Storage storage = jsonParser.readValueAs(Storage.class);
            return storage.build();
        }
    }

    static class Serializer
    extends JsonSerializer<SinkRecord> {
        Serializer() {
        }

        @Override
        public void serialize(SinkRecord record, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            Storage storage = new Storage();
            storage.topic = record.topic();
            storage.kafkaPartition = record.kafkaPartition();
            storage.keySchema = record.keySchema();
            storage.key = record.key();
            storage.valueSchema = record.valueSchema();
            storage.value = record.value();
            storage.timestamp = record.timestamp();
            storage.timestampType = record.timestampType();
            storage.offset = record.kafkaOffset();
            if (null != record.headers()) {
                ArrayList<Header> headers = new ArrayList<Header>();
                for (Header header : record.headers()) {
                    headers.add(header);
                }
                storage.headers = headers;
            }
            jsonGenerator.writeObject(storage);
        }
    }

    public static class Storage {
        public String topic;
        public Integer kafkaPartition;
        public Schema keySchema;
        public Object key;
        public Schema valueSchema;
        public Object value;
        public Long timestamp;
        public TimestampType timestampType = TimestampType.NO_TIMESTAMP_TYPE;
        public long offset = 1234L;
        public List<Header> headers;

        public Object value() {
            if (this.valueSchema != null) {
                return ValueHelper.value(this.valueSchema, this.value);
            }
            return this.value;
        }

        public Object key() {
            if (this.keySchema != null) {
                return ValueHelper.value(this.keySchema, this.key);
            }
            return this.key;
        }

        public SinkRecord build() {
            return new SinkRecord(this.topic, this.kafkaPartition.intValue(), this.keySchema, this.key(), this.valueSchema, this.value(), this.offset, this.timestamp, this.timestampType, this.headers);
        }
    }
}

