/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.github.jcustenborder.kafka.connect.utils.jackson.HeaderImpl;
import com.github.jcustenborder.kafka.connect.utils.jackson.KeyValue;
import java.io.IOException;
import org.apache.kafka.connect.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.core.JsonParser;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.DeserializationContext;
import shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import shaded.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.module.SimpleModule;

public class HeaderSerializationModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(HeaderSerializationModule.class);

    public HeaderSerializationModule() {
        this.addSerializer(Header.class, new Serializer());
        this.addDeserializer(Header.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<Header> {
        Deserializer() {
        }

        @Override
        public Header deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            KeyValue storage = jsonParser.readValueAs(KeyValue.class);
            return new HeaderImpl(storage.name, storage.schema, storage.value());
        }
    }

    static class Serializer
    extends JsonSerializer<Header> {
        Serializer() {
        }

        @Override
        public void serialize(Header header, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            KeyValue storage = new KeyValue();
            storage.name = header.key();
            storage.schema = header.schema();
            storage.value(header.value());
            jsonGenerator.writeObject(storage);
        }
    }
}

