/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.recommenders;

import com.github.jcustenborder.kafka.connect.utils.config.recommenders.VisibleCallback;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableSet;

class EnumRecommender
implements ConfigDef.Recommender {
    final Set<String> validEnums;
    final Class<?> enumClass;
    final VisibleCallback visible;

    EnumRecommender(Class<?> enumClass, VisibleCallback visible, String ... excludes) {
        Preconditions.checkNotNull(enumClass, "enumClass cannot be null");
        Preconditions.checkState(enumClass.isEnum(), "enumClass must be an enum.");
        Preconditions.checkNotNull(visible, "visible cannot be null");
        this.enumClass = enumClass;
        this.visible = visible;
        LinkedHashSet<String> validEnums = new LinkedHashSet<String>();
        for (Object o : enumClass.getEnumConstants()) {
            String key = o.toString();
            validEnums.add(key);
        }
        validEnums.removeAll(Arrays.asList(excludes));
        this.validEnums = ImmutableSet.copyOf(validEnums);
    }

    public List<Object> validValues(String s2, Map<String, Object> map) {
        return ImmutableList.copyOf(this.validEnums);
    }

    public boolean visible(String s2, Map<String, Object> map) {
        return this.visible.visible(s2, map);
    }
}

