/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;

public class TaskConfigs {
    public static List<Map<String, String>> single(Map<String, String> settings) {
        Preconditions.checkNotNull(settings, "settings cannot be null.");
        return ImmutableList.of(settings);
    }

    public static List<Map<String, String>> multiple(Map<String, String> settings, int taskCount) {
        Preconditions.checkNotNull(settings, "settings cannot be null.");
        Preconditions.checkState(taskCount > 0, "taskCount must be greater than 0.");
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(taskCount);
        for (int i = 0; i < taskCount; ++i) {
            result.add(settings);
        }
        return ImmutableList.copyOf(result);
    }
}

