/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

class PatternValidator
implements ConfigDef.Validator {
    PatternValidator() {
    }

    static void validatePattern(String setting, String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigException(setting, (Object)pattern, String.format("Could not compile regex '%s'.", pattern));
        }
    }

    public void ensureValid(String setting, Object value) {
        if (value instanceof String) {
            String s = (String)value;
            PatternValidator.validatePattern(setting, s);
        } else if (value instanceof List) {
            List list = (List)value;
            for (String s : list) {
                PatternValidator.validatePattern(setting, s);
            }
        } else {
            throw new ConfigException(setting, value, "value must be a String or List.");
        }
    }
}

