/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators;

import com.github.jcustenborder.kafka.connect.utils.config.ValidEnum;
import com.github.jcustenborder.kafka.connect.utils.config.ValidPattern;
import com.github.jcustenborder.kafka.connect.utils.config.ValidPort;
import com.github.jcustenborder.kafka.connect.utils.config.validators.BlankOrValidator;
import com.github.jcustenborder.kafka.connect.utils.config.validators.PatternValidator;
import com.github.jcustenborder.kafka.connect.utils.config.validators.ValidCharset;
import com.github.jcustenborder.kafka.connect.utils.config.validators.ValidHostAndPort;
import com.github.jcustenborder.kafka.connect.utils.config.validators.ValidURI;
import com.github.jcustenborder.kafka.connect.utils.config.validators.ValidUrl;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;

public class Validators {
    private Validators() {
    }

    public static ConfigDef.Validator pattern() {
        return new PatternValidator();
    }

    public static ConfigDef.Validator patternMatches(String pattern) {
        return ValidPattern.of(pattern);
    }

    public static ConfigDef.Validator patternMatches(Pattern pattern) {
        return ValidPattern.of(pattern);
    }

    public static ConfigDef.Validator blankOr(ConfigDef.Validator validator) {
        Preconditions.checkNotNull((Object)validator, (Object)"validator cannot be null.");
        return BlankOrValidator.of(validator);
    }

    public static ConfigDef.Validator validURI(String ... schemes) {
        return new ValidURI(schemes);
    }

    public static ConfigDef.Validator validUrl() {
        return new ValidUrl();
    }

    public static ConfigDef.Validator validCharset(String ... charsets) {
        if (null == charsets || charsets.length == 0) {
            return new ValidCharset();
        }
        return new ValidCharset(charsets);
    }

    public static ConfigDef.Validator validCharset() {
        return new ValidCharset();
    }

    public static ConfigDef.Validator validEnum(Class<?> enumClass, String ... excludes) {
        return ValidEnum.of(enumClass, excludes);
    }

    public static ConfigDef.Validator validEnum(Class<? extends Enum> enumClass, Enum ... excludes) {
        String[] ex = new String[excludes.length];
        for (int i = 0; i < ex.length; ++i) {
            ex[i] = excludes[i].toString();
        }
        return ValidEnum.of(enumClass, ex);
    }

    public static ConfigDef.Validator validPort() {
        return ValidPort.of();
    }

    public static ConfigDef.Validator validPort(int start, int end) {
        return ValidPort.of(start, end);
    }

    public static ConfigDef.Validator validHostAndPort() {
        return ValidHostAndPort.of();
    }

    public static ConfigDef.Validator validHostAndPort(Integer defaultPort, boolean requireBracketsForIPv6, boolean portRequired) {
        return ValidHostAndPort.of(defaultPort, requireBracketsForIPv6, portRequired);
    }
}

