/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Timestamp;

public class SchemaHelper {
    static final Map<Class<?>, Schema.Type> PRIMITIVES;

    public static Schema schema(Object input) {
        return SchemaHelper.builder(input).build();
    }

    public static SchemaBuilder builder(Object input) {
        SchemaBuilder builder;
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (PRIMITIVES.containsKey(input.getClass())) {
            Schema.Type type = PRIMITIVES.get(input.getClass());
            builder = SchemaBuilder.type((Schema.Type)type);
        } else if (input instanceof Date) {
            builder = Timestamp.builder();
        } else if (input instanceof BigDecimal) {
            builder = Decimal.builder((int)((BigDecimal)input).scale());
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported Type: %s", input.getClass()));
        }
        return builder.optional();
    }

    static {
        HashMap<Class<byte[]>, Schema.Type> primitives = new HashMap<Class<byte[]>, Schema.Type>();
        primitives.put(String.class, Schema.Type.STRING);
        primitives.put(Boolean.class, Schema.Type.BOOLEAN);
        primitives.put(Byte.class, Schema.Type.INT8);
        primitives.put(Short.class, Schema.Type.INT16);
        primitives.put(Integer.class, Schema.Type.INT32);
        primitives.put(Long.class, Schema.Type.INT64);
        primitives.put(Float.class, Schema.Type.FLOAT32);
        primitives.put(Double.class, Schema.Type.FLOAT64);
        primitives.put(byte[].class, Schema.Type.BYTES);
        PRIMITIVES = ImmutableMap.copyOf(primitives);
    }
}

