/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.jcustenborder.kafka.connect.utils.jackson.HeaderImpl;
import com.github.jcustenborder.kafka.connect.utils.jackson.KeyValue;
import java.io.IOException;
import org.apache.kafka.connect.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderSerializationModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(HeaderSerializationModule.class);

    public HeaderSerializationModule() {
        this.addSerializer(Header.class, new Serializer());
        this.addDeserializer(Header.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<Header> {
        Deserializer() {
        }

        public Header deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            KeyValue storage = (KeyValue)jsonParser.readValueAs(KeyValue.class);
            return new HeaderImpl(storage.name, storage.schema, storage.value());
        }
    }

    static class Serializer
    extends JsonSerializer<Header> {
        Serializer() {
        }

        public void serialize(Header header, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            KeyValue storage = new KeyValue();
            storage.name = header.key();
            storage.schema = header.schema();
            storage.value(header.value());
            jsonGenerator.writeObject((Object)storage);
        }
    }
}

