/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import org.apache.kafka.connect.data.Schema;

class ParserKey
implements Comparable<ParserKey> {
    public final Schema.Type type;
    public final String logicalName;

    ParserKey(Schema schema) {
        this(schema.type(), schema.name());
    }

    ParserKey(Schema.Type type, String logicalName) {
        this.type = type;
        this.logicalName = logicalName == null ? "" : logicalName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.logicalName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("logicalName", (Object)this.logicalName).toString();
    }

    @Override
    public int compareTo(ParserKey that) {
        if (null == that) {
            return 1;
        }
        return ComparisonChain.start().compare((Comparable)this.type, (Comparable)that.type).compare((Comparable)((Object)this.logicalName), (Comparable)((Object)that.logicalName)).result();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParserKey) {
            return this.compareTo((ParserKey)obj) == 0;
        }
        return false;
    }
}

