/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.jcustenborder.kafka.connect.utils.jackson.ValueHelper;
import java.io.IOException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;

public class SinkRecordSerializationModule
extends SimpleModule {
    public SinkRecordSerializationModule() {
        this.addSerializer(SinkRecord.class, new Serializer());
        this.addDeserializer(SinkRecord.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<SinkRecord> {
        Deserializer() {
        }

        public SinkRecord deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Storage storage = (Storage)jsonParser.readValueAs(Storage.class);
            return storage.build();
        }
    }

    static class Serializer
    extends JsonSerializer<SinkRecord> {
        Serializer() {
        }

        public void serialize(SinkRecord sourceRecord, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            Storage storage = new Storage();
            storage.topic = sourceRecord.topic();
            storage.kafkaPartition = sourceRecord.kafkaPartition();
            storage.keySchema = sourceRecord.keySchema();
            storage.key = sourceRecord.key();
            storage.valueSchema = sourceRecord.valueSchema();
            storage.value = sourceRecord.value();
            storage.timestamp = sourceRecord.timestamp();
            jsonGenerator.writeObject((Object)storage);
        }
    }

    public static class Storage {
        public String topic;
        public Integer kafkaPartition;
        public Schema keySchema;
        public Object key;
        public Schema valueSchema;
        public Object value;
        public Long timestamp;

        public Object value() {
            if (this.valueSchema != null) {
                return ValueHelper.value(this.valueSchema, this.value);
            }
            return this.value;
        }

        public Object key() {
            if (this.keySchema != null) {
                return ValueHelper.value(this.keySchema, this.key);
            }
            return this.key;
        }

        public SinkRecord build() {
            return new SinkRecord(this.topic, this.kafkaPartition.intValue(), this.keySchema, this.key(), this.valueSchema, this.value(), this.timestamp.longValue());
        }
    }
}

