/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.github.jcustenborder.kafka.connect.utils.config.ValidHostnameAndPort;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;

public class ConfigUtils {
    public static <T> Class<T> getClass(AbstractConfig config, String key, Class<T> expected) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        Preconditions.checkNotNull(expected, (Object)"expected cannot be null");
        Class cls = config.getClass(key);
        Preconditions.checkState((boolean)expected.isAssignableFrom(cls), (String)"'%s' is not assignable from '%s'", (Object[])new Object[]{expected.getSimpleName(), cls.getSimpleName()});
        return cls;
    }

    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, AbstractConfig config, String key) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        String textValue = config.getString(key);
        return Enum.valueOf(enumClass, textValue);
    }

    public static String enumValues(Class<?> enumClass) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        return Joiner.on((String)", ").join((Object[])enumClass.getEnumConstants());
    }

    public static File getAbsoluteFile(AbstractConfig config, String key) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        String path = config.getString(key);
        File file = new File(path);
        Preconditions.checkState((boolean)file.isAbsolute(), (String)"'%s' must be an absolute path.", (Object[])new Object[]{key});
        return new File(path);
    }

    static InetSocketAddress parseInetSocketAddress(String s) {
        Preconditions.checkNotNull((Object)s, (Object)"s cannot be null.");
        Matcher matcher = ValidHostnameAndPort.HOSTNAME_PATTERN.matcher(s);
        Preconditions.checkState((boolean)matcher.matches(), (String)"'%s' does not match '%s'", (Object[])new Object[]{s, ValidHostnameAndPort.HOSTNAME_PATTERN.pattern()});
        Integer port = Ints.tryParse((String)matcher.group(2));
        Preconditions.checkState((port >= 1 && port <= 65535 ? 1 : 0) != 0, (String)"Invalid port value %s. Must be between 1 and 65535", (Object[])new Object[]{port});
        return new InetSocketAddress(matcher.group(1), (int)port);
    }

    public static InetSocketAddress inetSocketAddress(AbstractConfig config, String key) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        String value = config.getString(key);
        return ConfigUtils.parseInetSocketAddress(value);
    }

    public static List<InetSocketAddress> inetSocketAddresses(AbstractConfig config, String key) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        List value = config.getList(key);
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(value.size());
        for (String s : value) {
            addresses.add(ConfigUtils.parseInetSocketAddress(s));
        }
        return ImmutableList.copyOf(addresses);
    }

    static HostAndPort hostAndPort(String input, Integer defaultPort) {
        HostAndPort result = HostAndPort.fromString((String)input);
        if (null != defaultPort) {
            result.withDefaultPort(defaultPort.intValue());
        }
        return result;
    }

    public static HostAndPort hostAndPort(AbstractConfig config, String key, Integer defaultPort) {
        String input = config.getString(key);
        return ConfigUtils.hostAndPort(input, defaultPort);
    }

    public static HostAndPort hostAndPort(AbstractConfig config, String key) {
        return ConfigUtils.hostAndPort(config, key, null);
    }

    public static List<HostAndPort> hostAndPorts(AbstractConfig config, String key, Integer defaultPort) {
        List inputs = config.getList(key);
        ArrayList<HostAndPort> result = new ArrayList<HostAndPort>();
        for (String input : inputs) {
            HostAndPort hostAndPort = ConfigUtils.hostAndPort(input, defaultPort);
            result.add(hostAndPort);
        }
        return ImmutableList.copyOf(result);
    }

    public static List<HostAndPort> hostAndPorts(AbstractConfig config, String key) {
        return ConfigUtils.hostAndPorts(config, key, null);
    }

    static URL url(String key, String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            ConfigException configException = new ConfigException(key, (Object)value, "Could not parse to URL.");
            configException.initCause((Throwable)e);
            throw configException;
        }
    }

    public static URL url(AbstractConfig config, String key) {
        String value = config.getString(key);
        return ConfigUtils.url(key, value);
    }

    public static List<URL> urls(AbstractConfig config, String key) {
        ArrayList<URL> result = new ArrayList<URL>();
        List input = config.getList(key);
        for (String s : input) {
            result.add(ConfigUtils.url(key, s));
        }
        return ImmutableList.copyOf(result);
    }
}

