/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators.filesystem;

import com.github.jcustenborder.repackaged.com.google.common.base.Preconditions;
import com.github.jcustenborder.repackaged.com.google.common.base.Strings;
import java.io.File;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidFileSystem
implements ConfigDef.Validator {
    private static final Logger log = LoggerFactory.getLogger(ValidFileSystem.class);
    public final boolean ensureWritable;

    protected ValidFileSystem(boolean ensureWritable) {
        this.ensureWritable = ensureWritable;
    }

    protected abstract void ensureValid(String var1, Object var2, File var3);

    public void ensureValid(String setting, Object input) {
        log.trace("ensureValid('{}', '{}')", (Object)setting, input);
        Preconditions.checkState(input instanceof String, "'%s' must be a string", (Object)setting);
        String value = input.toString();
        Preconditions.checkState(!Strings.isNullOrEmpty(value), "'%s' cannot be null or empty.", (Object)setting);
        File file = new File(value);
        Preconditions.checkState(file.isAbsolute(), "'%s'(%s) is not an absolute path.", (Object)setting, (Object)file);
        this.ensureValid(setting, input, file);
        if (this.ensureWritable) {
            Preconditions.checkState(file.canWrite(), "'%s'(%s) should be writable.", (Object)setting, (Object)file);
        }
        Preconditions.checkState(file.canRead(), "'%s'(%s) should be readable.", (Object)setting, (Object)file);
    }
}

